/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.analysis;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.objects.Ros2ObjectsUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcess;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostThread;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.trace.layout.IRos2EventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.osgi.framework.Version;

public abstract class AbstractRos2StateProvider
extends AbstractTmfStateProvider {
    private static final @NonNull Version RMW_SOURCE_TIMESTAMP_MINIMUM_VERSION = new Version("8.0.0");
    protected static final IRos2EventLayout LAYOUT = IRos2EventLayout.getDefault();

    protected AbstractRos2StateProvider(ITmfTrace trace, String id) {
        super(Objects.requireNonNull(trace), Objects.requireNonNull(id));
    }

    protected boolean isPubSourceTimestampAvailableFromRmw(@NonNull ITmfEvent event, @NonNull ITmfStateSystem objectsSs) {
        HostProcess process = AbstractRos2StateProvider.hostProcessFrom(event);
        String tracetoolsVersionStr = Ros2ObjectsUtil.getTracetoolsVersion(objectsSs, event.getTimestamp().toNanos(), process);
        if (tracetoolsVersionStr == null) {
            Activator.getInstance().logWarning(String.format("cannot get tracetools version from trace for PID=%d, assuming >=%s", process.getPid(), RMW_SOURCE_TIMESTAMP_MINIMUM_VERSION.toString()));
            return true;
        }
        Version tracetoolsVersion = new Version(tracetoolsVersionStr);
        return tracetoolsVersion.compareTo(RMW_SOURCE_TIMESTAMP_MINIMUM_VERSION) >= 0;
    }

    protected static boolean considerEvent(@NonNull ITmfEvent event) {
        return event.getName().startsWith("ros2:") || event.getName().startsWith("dds:");
    }

    protected static boolean isEvent(@NonNull ITmfEvent event, @NonNull String eventName) {
        return event.getName().equals(eventName);
    }

    protected static boolean hasField(@NonNull ITmfEvent event, @NonNull String fieldName) {
        return event.getContent().getFieldValue(Object.class, new String[]{fieldName}) != null;
    }

    protected static Object getField(@NonNull ITmfEvent event, @NonNull String fieldName) {
        Object val = event.getContent().getFieldValue(Object.class, new String[]{fieldName});
        if (val == null) {
            Activator.getInstance().logError(String.format("null '%s' field for event: %s", fieldName, event.toString()));
        }
        return val;
    }

    protected static @NonNull Long getPid(@NonNull ITmfEvent event) {
        Long vpid = (Long)event.getContent().getField(new String[]{LAYOUT.contextVpid()}).getValue();
        if (vpid == null) {
            return 0L;
        }
        return vpid;
    }

    protected static @NonNull Long getTid(@NonNull ITmfEvent event) {
        Long vtid = (Long)event.getContent().getField(new String[]{LAYOUT.contextVtid()}).getValue();
        if (vtid == null) {
            return 0L;
        }
        return vtid;
    }

    protected static @NonNull HostInfo hostInfoFrom(@NonNull ITmfEvent event) {
        ITmfTrace trace = event.getTrace();
        String hostname = null;
        if (trace instanceof CtfTmfTrace) {
            hostname = (String)((CtfTmfTrace)trace).getEnvironment().get("hostname");
        }
        if (hostname == null) {
            hostname = "";
        }
        return new HostInfo(trace.getHostId(), hostname);
    }

    protected static @NonNull HostThread hostThreadFrom(@NonNull ITmfEvent event) {
        return new HostThread(AbstractRos2StateProvider.hostInfoFrom(event), AbstractRos2StateProvider.getTid(event));
    }

    protected static @NonNull HostProcess hostProcessFrom(@NonNull ITmfEvent event) {
        return new HostProcess(AbstractRos2StateProvider.hostInfoFrom(event), AbstractRos2StateProvider.getPid(event));
    }

    protected static @NonNull HostProcessPointer hostProcessPointerFrom(@NonNull ITmfEvent event, @NonNull Long pointer) {
        return new HostProcessPointer(AbstractRos2StateProvider.hostProcessFrom(event), pointer);
    }

    protected static @NonNull Ros2ObjectHandle handleFrom(@NonNull ITmfEvent event, @NonNull Long handle) {
        return new Ros2ObjectHandle(AbstractRos2StateProvider.hostProcessFrom(event), handle);
    }
}

