/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SchedWakeupHandler
extends VMKernelEventHandler {
    public SchedWakeupHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        FusedVirtualMachineStateProvider sp = this.getStateProvider();
        VirtualMachine host = sp.getCurrentMachine(event);
        if (host != null && host.isGuest()) {
            Integer physicalCPU = sp.getPhysicalCPU(host, cpu);
            if (physicalCPU != null) {
                cpu = physicalCPU;
            } else {
                return;
            }
        }
        String machineHost = event.getTrace().getHostId();
        int tid = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldTid()}).getValue()).intValue();
        int prio = ((Long)event.getContent().getField(new String[]{this.getLayout().fieldPrio()}).getValue()).intValue();
        String threadAttributeName = FusedVMEventHandlerUtils.buildThreadAttributeName(tid, cpu);
        if (threadAttributeName == null) {
            return;
        }
        int threadNode = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ss), new String[]{machineHost, threadAttributeName});
        int quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Status"});
        Object value = ss.queryOngoing(quark);
        if (!(value instanceof Integer)) {
            return;
        }
        int status = (Integer)value;
        long timestamp = FusedVMEventHandlerUtils.getTimestamp(event);
        if (status != 3 && status != 2) {
            ss.modifyAttribute(timestamp, (Object)5, quark);
        }
        quark = ss.getQuarkRelativeAndAdd(threadNode, new String[]{"Prio"});
        ss.modifyAttribute(timestamp, (Object)prio, quark);
    }
}

