/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.messages.Ros2MessagesUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowBuildInfo;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2PublicationMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2SubCallbackMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2PubInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2SubCallbackInstance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2PublisherObject;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2SubscriptionObject;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class Ros2WaitMessageFlowSegment
extends Ros2MessageFlowSegment {
    private final @NonNull Ros2SubCallbackInstance fSubCallbackInstance;
    private final @NonNull Ros2PubInstance fPubInstance;
    private final @NonNull Ros2SubscriptionObject fSubscription;
    private final @NonNull Ros2PublisherObject fPublisher;

    public Ros2WaitMessageFlowSegment(long startTime, long endTime, @NonNull Ros2SubCallbackInstance subCallbackInstance, @NonNull Ros2PubInstance pubInstance, @NonNull Ros2SubscriptionObject subscription, @NonNull Ros2PublisherObject publisher) {
        super(startTime, endTime, null);
        this.fSubCallbackInstance = subCallbackInstance;
        this.fPubInstance = pubInstance;
        this.fSubscription = subscription;
        this.fPublisher = publisher;
    }

    public @NonNull Ros2SubCallbackInstance getSubCallbackInstance() {
        return this.fSubCallbackInstance;
    }

    public @NonNull Ros2PubInstance getPubInstance() {
        return this.fPubInstance;
    }

    public @NonNull Ros2SubscriptionObject getSubscription() {
        return this.fSubscription;
    }

    public @NonNull Ros2PublisherObject getPublisher() {
        return this.fPublisher;
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectSuccessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ITmfStateInterval pubInstanceInterval = Ros2MessagesUtil.getPubInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getEndTime() + 1L, (Ros2ObjectHandle)((Object)this.getPublisher().getHandle()));
        if (pubInstanceInterval == null) {
            return Collections.emptyList();
        }
        long startTime = pubInstanceInterval.getStartTime();
        long endTime = pubInstanceInterval.getEndTime();
        Ros2PubInstance pubInstance = (Ros2PubInstance)((Object)pubInstanceInterval.getValue());
        if (pubInstance == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Ros2PublicationMessageFlowSegment(startTime, endTime, pubInstance, this.getPublisher()));
    }

    @Override
    public @NonNull Collection<@NonNull Ros2MessageFlowSegment> getDirectPredecessors(@NonNull Ros2MessageFlowBuildInfo info) {
        ITmfStateInterval subCallbackInstanceInterval = Ros2MessagesUtil.getSubCallbackInstanceInterval(info.getMessagesSs(), info.getObjectsSs(), this.getStartTime() - 1L, (Ros2ObjectHandle)((Object)this.getSubscription().getHandle()));
        if (subCallbackInstanceInterval == null) {
            return Collections.emptyList();
        }
        long startTime = subCallbackInstanceInterval.getStartTime();
        long endTime = subCallbackInstanceInterval.getEndTime();
        Ros2SubCallbackInstance subCallbackInstance = (Ros2SubCallbackInstance)((Object)subCallbackInstanceInterval.getValue());
        if (subCallbackInstance == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Ros2SubCallbackMessageFlowSegment(startTime, endTime, subCallbackInstance, this.getSubscription()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fSubCallbackInstance, this.fPubInstance, this.fSubscription, this.fPublisher, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Ros2WaitMessageFlowSegment)) {
            return false;
        }
        Ros2WaitMessageFlowSegment o = (Ros2WaitMessageFlowSegment)obj;
        if (!this.fPubInstance.equals((Object)o.fPubInstance)) {
            return false;
        }
        return this.fPublisher.equals((Object)o.fPublisher);
    }

    @Override
    public String toString() {
        return String.format("Ros2WaitMessageFlowSegment: %s, subCallbackInstance=[%s], pubInstance=[%s], sub=[%s], pub=[%s]", super.toString(), this.fSubCallbackInstance.toString(), this.fPubInstance.toString(), this.fSubscription.toString(), this.fPublisher.toString());
    }
}

