/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.graph;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public interface ITmfGraph {
    public ITmfVertex createVertex(IGraphWorker var1, long var2);

    public void add(ITmfVertex var1);

    public @Nullable ITmfEdge appendUnknown(ITmfVertex var1);

    public @Nullable ITmfEdge append(ITmfVertex var1);

    public @Nullable ITmfEdge append(ITmfVertex var1, ITmfEdgeContextState var2);

    public @Nullable ITmfEdge append(ITmfVertex var1, ITmfEdgeContextState var2, @Nullable String var3);

    public @Nullable ITmfEdge edgeUnknown(ITmfVertex var1, ITmfVertex var2);

    public @Nullable ITmfEdge edge(ITmfVertex var1, ITmfVertex var2);

    public @Nullable ITmfEdge edge(ITmfVertex var1, ITmfVertex var2, ITmfEdgeContextState var3);

    public @Nullable ITmfEdge edge(ITmfVertex var1, ITmfVertex var2, ITmfEdgeContextState var3, String var4);

    public @Nullable ITmfEdge edgeVertical(ITmfVertex var1, ITmfVertex var2, ITmfEdgeContextState var3, @Nullable String var4);

    public @Nullable ITmfVertex getTail(IGraphWorker var1);

    public @Nullable ITmfVertex getHead(IGraphWorker var1);

    public @Nullable ITmfVertex getHead();

    public ITmfVertex getHead(ITmfVertex var1);

    public Iterator<ITmfVertex> getNodesOf(IGraphWorker var1);

    public @Nullable IGraphWorker getParentOf(ITmfVertex var1);

    public Collection<IGraphWorker> getWorkers();

    default public void scanLineTraverse(@Nullable ITmfVertex start, ITmfGraphVisitor visitor) {
        if (start == null) {
            return;
        }
        ArrayDeque<ITmfVertex> stack = new ArrayDeque<ITmfVertex>();
        HashSet<ITmfVertex> visited = new HashSet<ITmfVertex>();
        stack.add(start);
        block0: while (!stack.isEmpty()) {
            ITmfVertex curr = (ITmfVertex)stack.removeFirst();
            if (visited.contains(curr)) continue;
            ITmfVertex n = this.getHead(curr);
            visitor.visitHead(n);
            while (true) {
                visitor.visit(n);
                visited.add(n);
                ITmfEdge edge = this.getEdgeFrom(n, EdgeDirection.OUTGOING_VERTICAL_EDGE);
                if (edge != null) {
                    stack.addFirst(edge.getVertexTo());
                    visitor.visit(edge, false);
                }
                if ((edge = this.getEdgeFrom(n, EdgeDirection.INCOMING_VERTICAL_EDGE)) != null) {
                    stack.addFirst(edge.getVertexFrom());
                }
                if ((edge = this.getEdgeFrom(n, EdgeDirection.OUTGOING_HORIZONTAL_EDGE)) == null) continue block0;
                visitor.visit(edge, true);
                n = edge.getVertexTo();
            }
        }
    }

    default public void scanLineTraverse(@Nullable IGraphWorker start, ITmfGraphVisitor visitor) {
        if (start == null) {
            return;
        }
        this.scanLineTraverse(this.getHead(start), visitor);
    }

    public @Nullable ITmfVertex getVertexAt(ITmfTimestamp var1, IGraphWorker var2);

    public boolean isDoneBuilding();

    public void closeGraph(long var1);

    public @Nullable ITmfEdge getEdgeFrom(ITmfVertex var1, EdgeDirection var2);

    public void dispose();

    public static enum EdgeDirection {
        OUTGOING_VERTICAL_EDGE,
        INCOMING_VERTICAL_EDGE,
        OUTGOING_HORIZONTAL_EDGE,
        INCOMING_HORIZONTAL_EDGE;

    }
}

