/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public final class Trace
implements Serializable {
    private static final long serialVersionUID = 1194829124866484394L;
    private final String fName;
    private final UUID fUUID;
    private final String fPath;
    private final long fNbEvents;
    private final long fStart;
    private final long fEnd;
    private final Map<String, String> fProperties;
    private final String fIndexingStatus;

    @JsonCreator
    public Trace(@JsonProperty(value="name") String name, @JsonProperty(value="UUID") UUID uuid, @JsonProperty(value="path") String path, @JsonProperty(value="nbEvents") long nbEvents, @JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="indexingStatus") String indexingStatus) {
        this.fName = name;
        this.fUUID = uuid;
        this.fPath = path;
        this.fNbEvents = nbEvents;
        this.fStart = start;
        this.fEnd = end;
        this.fProperties = properties;
        this.fIndexingStatus = indexingStatus;
    }

    public static Trace from(ITmfTrace trace, UUID uuid) {
        return new Trace(trace.getName(), uuid, trace.getPath(), trace.getNbEvents(), trace.getStartTime().toNanos(), trace.getEndTime().toNanos(), trace instanceof ITmfPropertiesProvider ? ((ITmfPropertiesProvider)trace).getProperties() : new HashMap(), trace.isIndexing() ? "RUNNING" : "COMPLETED");
    }

    public static Trace from(IResource traceResource, UUID uuid) {
        IPath location = ResourceUtil.getLocation((IResource)traceResource);
        if (location == null) {
            location = traceResource.getProjectRelativePath();
        }
        String path = location.removeTrailingSeparator().toOSString();
        return new Trace(traceResource.getName(), uuid, path, 0L, 0L, 0L, new HashMap<String, String>(), "CLOSED");
    }

    public String getName() {
        return this.fName;
    }

    public UUID getUUID() {
        return this.fUUID;
    }

    public String getPath() {
        return this.fPath;
    }

    public long getNbEvents() {
        return this.fNbEvents;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public Map<String, String> getProperties() {
        return this.fProperties;
    }

    public String getIndexingStatus() {
        return this.fIndexingStatus;
    }

    public String toString() {
        return "Trace [fName=" + this.fName + ", fUUID=" + String.valueOf(this.fUUID) + ", fPath=" + this.fPath + ", fNbEvents=" + this.fNbEvents + ", fStart=" + this.fStart + ", fEnd=" + this.fEnd + ", fIndexingStatus=" + this.fIndexingStatus + ", fProperties" + this.fProperties.toString() + "]";
    }
}

