/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUnaryTypeTransformation;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.UniqueType;
import org.eclipse.cdt.internal.core.index.IIndexScope;

public class SemanticUtil {
    private static final char[] OPERATOR_CHARS = "operator".toCharArray();
    private static final CharArraySet cas = new CharArraySet(OverloadableOperator.values().length);
    public static final int TDEF = 1;
    public static final int COND_TDEF = 2;
    public static final int REF = 4;
    public static final int CVTYPE = 8;
    public static final int ALLCVQ = 16;
    public static final int PTR = 32;
    public static final int MPTR = 64;
    public static final int ARRAY = 128;

    static {
        int OPERATOR_SPC = OPERATOR_CHARS.length + 1;
        OverloadableOperator[] overloadableOperatorArray = OverloadableOperator.values();
        int n = overloadableOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OverloadableOperator op = overloadableOperatorArray[n2];
            char[] name = op.toCharArray();
            cas.put(CharArrayUtils.subarray(name, OPERATOR_SPC, name.length));
            ++n2;
        }
    }

    public static final ICPPMethod[] getDeclaredConversionOperators(ICPPClassType clazz) throws DOMException {
        ICPPMethod[] methods;
        ICPPMethod[] conversionOps = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        if (clazz instanceof ICPPDeferredClassInstance) {
            clazz = (ICPPClassType)((Object)((ICPPDeferredClassInstance)clazz).getTemplateDefinition());
        }
        if ((methods = clazz instanceof CPPClosureType ? ClassTypeHelper.getMethods(clazz) : clazz.getDeclaredMethods()) != null) {
            ICPPMethod[] iCPPMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (SemanticUtil.isConversionOperator(method)) {
                    conversionOps = ArrayUtil.append(conversionOps, method);
                }
                ++n2;
            }
        }
        return conversionOps;
    }

    public static ICPPMethod[] getConversionOperators(ICPPClassType clazz) throws DOMException {
        ICPPMethod[] methods = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        ObjectSet<ICPPClassType> ancestry = SemanticUtil.inheritanceClosure(clazz);
        int i = 0;
        while (i < ancestry.size()) {
            methods = ArrayUtil.addAll(methods, SemanticUtil.getDeclaredConversionOperators((ICPPClassType)ancestry.keyAt(i)));
            ++i;
        }
        return methods;
    }

    public static ObjectSet<ICPPClassType> inheritanceClosure(ICPPClassType root) throws DOMException {
        ObjectSet<ICPPClassType> done = new ObjectSet<ICPPClassType>(2);
        ObjectSet<ICPPClassType> current = new ObjectSet<ICPPClassType>(2);
        current.put(root);
        int count = 0;
        while (count < 40 && !current.isEmpty()) {
            ObjectSet<ICPPClassType> next = new ObjectSet<ICPPClassType>(2);
            int i = 0;
            while (i < current.size()) {
                ICPPClassType clazz = (ICPPClassType)current.keyAt(i);
                done.put(clazz);
                ICPPBase[] iCPPBaseArray = clazz.getBases();
                int n = iCPPBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassType ct;
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding binding = base.getBaseClass();
                    if (binding instanceof ICPPClassType && !(binding instanceof IProblemBinding) && !done.containsKey(ct = (ICPPClassType)binding)) {
                        next.put(ct);
                    }
                    ++n2;
                }
                ++i;
            }
            current = next;
            ++count;
        }
        return done;
    }

    public static final boolean isConversionOperator(ICPPFunction method) {
        char[] name;
        if (method instanceof ICPPMethod && (name = method.getNameCharArray()).length > OPERATOR_CHARS.length + 1 && name[OPERATOR_CHARS.length] == ' ' && CharArrayUtils.equals(name, 0, OPERATOR_CHARS.length, OPERATOR_CHARS)) {
            return !cas.containsKey(name, OPERATOR_CHARS.length + 1, name.length - (OPERATOR_CHARS.length + 1));
        }
        return false;
    }

    public static CVQualifier getCVQualifier(IType t) {
        if (t instanceof IQualifierType) {
            IQualifierType qt = (IQualifierType)t;
            return qt.isConst() ? (qt.isVolatile() ? CVQualifier.CONST_VOLATILE : CVQualifier.CONST) : (qt.isVolatile() ? CVQualifier.VOLATILE : CVQualifier.NONE);
        }
        if (t instanceof IPointerType) {
            IPointerType pt = (IPointerType)t;
            return pt.isConst() ? (pt.isVolatile() ? (pt.isRestrict() ? CVQualifier.CONST_VOLATILE_RESTRICT : CVQualifier.CONST_VOLATILE) : (pt.isRestrict() ? CVQualifier.CONST_RESTRICT : CVQualifier.CONST)) : (pt.isVolatile() ? (pt.isRestrict() ? CVQualifier.VOLATILE_RESTRICT : CVQualifier.VOLATILE) : (pt.isRestrict() ? CVQualifier.RESTRICT : CVQualifier.NONE));
        }
        if (t instanceof IArrayType) {
            return SemanticUtil.getCVQualifier(((IArrayType)t).getType());
        }
        return CVQualifier.NONE;
    }

    public static IType getUltimateType(IType type, boolean stopAtPointerToMember) {
        int options = 181;
        return SemanticUtil.getNestedType(type, stopAtPointerToMember ? 181 : 245);
    }

    public static IType getUltimateTypeUptoPointers(IType type) {
        return SemanticUtil.getNestedType(type, 13);
    }

    public static IType getNestedType(IType type, int options) {
        boolean tdef = (options & 1) != 0;
        boolean cond_tdef = (options & 2) != 0;
        boolean ptr = (options & 0x20) != 0;
        boolean mptr = (options & 0x40) != 0;
        boolean allcvq = (options & 0x10) != 0;
        boolean cvtype = (options & 8) != 0;
        IType beforeTypedefs = null;
        while (true) {
            IType t = null;
            if (type instanceof ITypedef) {
                if (tdef || cond_tdef) {
                    if (beforeTypedefs == null && cond_tdef) {
                        beforeTypedefs = type;
                    }
                    t = ((ITypedef)type).getType();
                }
            } else if (type instanceof IPointerType) {
                IPointerType pt;
                boolean isMbrPtr = type instanceof ICPPPointerToMemberType;
                if (ptr && !isMbrPtr || mptr && isMbrPtr) {
                    t = ((IPointerType)type).getType();
                    beforeTypedefs = null;
                } else if (allcvq && ((pt = (IPointerType)type).isConst() || pt.isVolatile() || pt.isRestrict())) {
                    if (pt instanceof ICPPPointerToMemberType) {
                        IType memberOfClass = ((ICPPPointerToMemberType)pt).getMemberOfClass();
                        return new CPPPointerToMemberType(pt.getType(), memberOfClass, false, false, false);
                    }
                    return new CPPPointerType(pt.getType(), false, false, false);
                }
            } else if (type instanceof IQualifierType) {
                IQualifierType qt = (IQualifierType)type;
                IType qttgt = qt.getType();
                if (allcvq || cvtype) {
                    t = qttgt;
                    beforeTypedefs = null;
                } else if (tdef || cond_tdef) {
                    t = SemanticUtil.getNestedType(qttgt, options);
                    if (t == qttgt) {
                        return qt;
                    }
                    return SemanticUtil.addQualifiers(t, qt.isConst(), qt.isVolatile(), false);
                }
            } else if (type instanceof IArrayType) {
                IArrayType atype = (IArrayType)type;
                if ((options & 0x80) != 0) {
                    t = atype.getType();
                    beforeTypedefs = null;
                } else if (allcvq) {
                    IType newNested;
                    nested = atype.getType();
                    if (nested == (newNested = SemanticUtil.getNestedType(nested, 16))) {
                        return type;
                    }
                    return SemanticUtil.replaceNestedType((ITypeContainer)((Object)atype), newNested);
                }
            } else if (type instanceof ICPPReferenceType) {
                ICPPReferenceType rt = (ICPPReferenceType)type;
                if ((options & 4) != 0) {
                    t = rt.getType();
                    beforeTypedefs = null;
                } else if (tdef) {
                    IType newNested;
                    nested = rt.getType();
                    if (nested == (newNested = SemanticUtil.getNestedType(nested, 1))) {
                        return type;
                    }
                    return SemanticUtil.replaceNestedType((ITypeContainer)((Object)rt), newNested);
                }
            }
            if (t == null) {
                if (beforeTypedefs != null) {
                    return beforeTypedefs;
                }
                return type;
            }
            type = t;
        }
    }

    public static IType getSimplifiedType(IType type) {
        if (type instanceof ICPPFunctionType) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            IType ret = null;
            IType[] params = null;
            IType r = ft.getReturnType();
            ret = SemanticUtil.getSimplifiedType(r);
            IType[] ps = ft.getParameterTypes();
            params = SemanticUtil.getSimplifiedTypes(ps);
            if (ret == r && params == ps) {
                return type;
            }
            return new CPPFunctionType(ret, params, ft.getNoexceptSpecifier(), ft.isConst(), ft.isVolatile(), ft.hasRefQualifier(), ft.isRValueReference(), ft.takesVarArgs());
        }
        if (type instanceof ITypedef) {
            IType t = ((ITypedef)type).getType();
            if (t != null) {
                return SemanticUtil.getSimplifiedType(t);
            }
            return type;
        }
        if (type instanceof ITypeContainer) {
            ITypeContainer tc = (ITypeContainer)type;
            IType nestedType = tc.getType();
            if (nestedType == null) {
                return type;
            }
            IType newType = SemanticUtil.getSimplifiedType(nestedType);
            if (newType != nestedType) {
                return SemanticUtil.replaceNestedType(tc, newType);
            }
            return type;
        }
        return type;
    }

    static boolean isSimplified(IType type) {
        if (type instanceof ICPPFunctionType) {
            IType[] ps;
            ICPPFunctionType ft = (ICPPFunctionType)type;
            if (!SemanticUtil.isSimplified(ft.getReturnType())) {
                return false;
            }
            IType[] iTypeArray = ps = ft.getParameterTypes();
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IType p = iTypeArray[n2];
                if (!SemanticUtil.isSimplified(p)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (type instanceof ITypedef) {
            return false;
        }
        if (type instanceof ITypeContainer) {
            return SemanticUtil.isSimplified(((ITypeContainer)type).getType());
        }
        return true;
    }

    public static IType replaceNestedType(ITypeContainer type, IType newNestedType) {
        if (newNestedType == null) {
            return type;
        }
        if (type instanceof IQualifierType) {
            IQualifierType qt = (IQualifierType)((Object)type);
            return SemanticUtil.addQualifiers(newNestedType, qt.isConst(), qt.isVolatile(), false);
        }
        type = (ITypeContainer)type.clone();
        type.setType(newNestedType);
        return type;
    }

    public static IType substituteTypedef(IType type, IType typedefType) {
        if (!((typedefType = SemanticUtil.getNestedType(typedefType, 180)) instanceof ITypedef)) {
            return null;
        }
        IType nestedType = type;
        IType typedefTarget = ((ITypedef)typedefType).getType();
        while (!nestedType.isSameType(typedefTarget)) {
            if (nestedType instanceof IQualifierType) {
                nestedType = ((IQualifierType)nestedType).getType();
                continue;
            }
            if (nestedType instanceof IPointerType) {
                nestedType = ((IPointerType)nestedType).getType();
                continue;
            }
            if (nestedType instanceof IArrayType) {
                nestedType = ((IArrayType)nestedType).getType();
                continue;
            }
            if (nestedType instanceof ICPPReferenceType) {
                nestedType = ((ICPPReferenceType)nestedType).getType();
                continue;
            }
            return SemanticUtil.substituteTypedef(type, typedefTarget);
        }
        IType result = null;
        ITypeContainer containerType = null;
        IType t = type;
        while (true) {
            IType newType;
            IType iType = newType = t == nestedType ? typedefType : (IType)t.clone();
            if (result == null) {
                result = newType;
            }
            if (containerType != null) {
                containerType.setType(newType);
            }
            if (t == nestedType) {
                return result;
            }
            if (!(t instanceof ITypeContainer)) {
                return null;
            }
            containerType = (ITypeContainer)t;
            t = containerType.getType();
        }
    }

    public static boolean isValidType(IType t) {
        while (true) {
            if (t instanceof ISemanticProblem) {
                return false;
            }
            if (t instanceof IFunctionType) {
                IFunctionType ft = (IFunctionType)t;
                IType[] iTypeArray = ft.getParameterTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType parameterType = iTypeArray[n2];
                    if (!SemanticUtil.isValidType(parameterType)) {
                        return false;
                    }
                    ++n2;
                }
                t = ft.getReturnType();
                continue;
            }
            if (t instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType mptr = (ICPPPointerToMemberType)t;
                if (!SemanticUtil.isValidType(mptr.getMemberOfClass())) {
                    return false;
                }
                t = mptr.getType();
                continue;
            }
            if (!(t instanceof ITypeContainer)) break;
            t = ((ITypeContainer)t).getType();
        }
        return true;
    }

    public static IType mapToAST(IType type) {
        IASTTranslationUnit ast;
        IASTNode point = CPPSemantics.getCurrentLookupPoint();
        if (point != null && type instanceof IIndexBinding && type instanceof ICPPClassType && (ast = point.getTranslationUnit()) instanceof CPPASTTranslationUnit) {
            return ((CPPASTTranslationUnit)ast).mapToAST((ICPPClassType)type);
        }
        return type;
    }

    public static ICPPTemplateArgument[] mapToAST(ICPPTemplateArgument[] args) {
        if (CPPSemantics.getCurrentLookupPoint() == null) {
            return args;
        }
        ICPPTemplateArgument[] result = args;
        int i = 0;
        while (i < args.length) {
            ICPPTemplateArgument arg;
            ICPPTemplateArgument newArg = arg = args[i];
            if (arg != null) {
                newArg = SemanticUtil.mapToAST(arg);
                if (result != args) {
                    result[i] = newArg;
                } else if (arg != newArg) {
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument mapToAST(ICPPTemplateArgument arg) {
        IType type = arg.getTypeValue();
        if (type != null) {
            IType mappedOriginalType;
            IType mappedType = SemanticUtil.mapToAST(type);
            IType originalType = arg.getOriginalTypeValue();
            IType iType = mappedOriginalType = originalType == type ? mappedType : SemanticUtil.mapToAST(originalType);
            if (mappedType != type || mappedOriginalType != originalType) {
                return new CPPTemplateTypeArgument(mappedType, mappedOriginalType);
            }
        }
        return arg;
    }

    public static IScope mapToAST(IScope scope, IASTNode point) {
        if (scope instanceof IIndexScope) {
            if (point != null) {
                IASTTranslationUnit ast = point.getTranslationUnit();
                if (ast instanceof ASTTranslationUnit) {
                    return ((ASTTranslationUnit)ast).mapToASTScope(scope);
                }
            } else if (scope.getKind() == EScopeKind.eGlobal) {
                CCorePlugin.log(new Exception("The point argument was not provided. Returning the global index scope."));
            }
        }
        return scope;
    }

    public static void recordPartialSpecialization(ICPPClassTemplatePartialSpecialization indexSpec, ICPPClassTemplatePartialSpecialization astSpec, IASTNode point) {
        IASTTranslationUnit ast;
        if (point != null && (ast = point.getTranslationUnit()) instanceof CPPASTTranslationUnit) {
            ((CPPASTTranslationUnit)ast).recordPartialSpecialization(indexSpec, astSpec);
        }
    }

    public static ICPPClassTemplatePartialSpecialization mapToAST(ICPPClassTemplatePartialSpecialization indexSpec) {
        IASTTranslationUnit ast;
        IASTNode point = CPPSemantics.getCurrentLookupPoint();
        if (point != null && (ast = point.getTranslationUnit()) instanceof CPPASTTranslationUnit) {
            return ((CPPASTTranslationUnit)ast).mapToAST(indexSpec);
        }
        return indexSpec;
    }

    public static IType[] getSimplifiedTypes(IType[] types) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            IType newType = SemanticUtil.getSimplifiedType(type);
            if (result != types) {
                result[i] = newType;
            } else if (type != newType) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = newType;
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] getSimplifiedArguments(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] result = args;
        int i = 0;
        while (i < args.length) {
            ICPPTemplateArgument arg;
            ICPPTemplateArgument newArg = arg = args[i];
            if (arg != null) {
                newArg = SemanticUtil.getSimplifiedArgument(arg);
                if (result != args) {
                    result[i] = newArg;
                } else if (arg != newArg) {
                    result = new ICPPTemplateArgument[args.length];
                    if (i > 0) {
                        System.arraycopy(args, 0, result, 0, i);
                    }
                    result[i] = newArg;
                }
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument getSimplifiedArgument(ICPPTemplateArgument arg) {
        IType type;
        IType newType;
        if (arg.isTypeValue() && (newType = SemanticUtil.getSimplifiedType(type = arg.getTypeValue())) != type) {
            return new CPPTemplateTypeArgument(newType, arg.getOriginalTypeValue());
        }
        return arg;
    }

    public static IType constQualify(IType baseType) {
        return SemanticUtil.addQualifiers(baseType, true, false, false);
    }

    public static IType addQualifiers(IType baseType, boolean cnst, boolean vol, boolean restrict) {
        if (cnst || vol || restrict) {
            if (baseType instanceof IQualifierType) {
                IQualifierType qt = (IQualifierType)baseType;
                if (cnst && !qt.isConst() || vol && !qt.isVolatile()) {
                    return new CPPQualifierType(qt.getType(), cnst || qt.isConst(), vol || qt.isVolatile());
                }
                return baseType;
            }
            if (baseType instanceof ICPPPointerToMemberType) {
                ICPPPointerToMemberType pt = (ICPPPointerToMemberType)baseType;
                if (cnst && !pt.isConst() || vol && !pt.isVolatile() || restrict && !pt.isRestrict()) {
                    return new CPPPointerToMemberType(pt.getType(), pt.getMemberOfClass(), cnst || pt.isConst(), vol || pt.isVolatile(), restrict || pt.isRestrict());
                }
                return baseType;
            }
            if (baseType instanceof IPointerType) {
                IPointerType pt = (IPointerType)baseType;
                if (cnst && !pt.isConst() || vol && !pt.isVolatile() || restrict && !pt.isRestrict()) {
                    return new CPPPointerType(pt.getType(), cnst || pt.isConst(), vol || pt.isVolatile(), restrict || pt.isRestrict());
                }
                return baseType;
            }
            if (baseType instanceof IArrayType) {
                IArrayType at = (IArrayType)baseType;
                IType nested = at.getType();
                IType newNested = SemanticUtil.addQualifiers(nested, cnst, vol, restrict);
                if (newNested != nested && at instanceof ITypeContainer) {
                    return SemanticUtil.replaceNestedType((ITypeContainer)((Object)at), newNested);
                }
                return at;
            }
            if (baseType instanceof ICPPReferenceType) {
                return baseType;
            }
            if (baseType == null) {
                return null;
            }
            return new CPPQualifierType(baseType, cnst, vol);
        }
        return baseType;
    }

    public static boolean haveSameOwner(IBinding b1, IBinding b2) {
        if (b1 == b2) {
            return true;
        }
        if ((b1 = b1.getOwner()) == (b2 = b2.getOwner())) {
            return true;
        }
        if (b1 instanceof IType) {
            if (b2 instanceof IType) {
                return ((IType)((Object)b1)).isSameType((IType)((Object)b2));
            }
            return false;
        }
        if (b1 instanceof ICPPNamespace && b2 instanceof ICPPNamespace) {
            return SemanticUtil.isSameNamespace((ICPPNamespace)b1, (ICPPNamespace)b2);
        }
        return false;
    }

    public static boolean isSameNamespace(ICPPNamespace ns1, ICPPNamespace ns2) {
        IBinding b1 = ns1;
        IBinding b2 = ns2;
        while (true) {
            int i = 0;
            while (b1 instanceof ICPPNamespaceAlias && i < 20) {
                b1 = ((ICPPNamespaceAlias)b1).getBinding();
                ++i;
            }
            i = 0;
            while (b2 instanceof ICPPNamespaceAlias && i < 20) {
                b2 = ((ICPPNamespaceAlias)b2).getBinding();
                ++i;
            }
            if (b1 == null) {
                return b2 == null;
            }
            if (b2 == null) {
                return false;
            }
            if (!(b1 instanceof ICPPNamespace) || !(b2 instanceof ICPPNamespace)) {
                return false;
            }
            if (!CharArrayUtils.equals(b1.getNameCharArray(), b2.getNameCharArray())) {
                return false;
            }
            b1 = b1.getOwner();
            b2 = b2.getOwner();
        }
    }

    public static boolean isVoidType(IType ptype) {
        while (ptype instanceof ITypedef) {
            ptype = ((ITypedef)ptype).getType();
        }
        if (ptype instanceof IBasicType) {
            return ((IBasicType)ptype).getKind() == IBasicType.Kind.eVoid;
        }
        return false;
    }

    public static boolean isAutoOrDecltype(String code) {
        if (code == null) {
            return false;
        }
        return code.equals("auto") || code.equals("typeof") || code.equals("decltype");
    }

    public static boolean isEmptyParameterList(IType[] parameters) {
        if (parameters.length == 0) {
            return true;
        }
        return parameters.length == 1 && SemanticUtil.isVoidType(parameters[0]);
    }

    public static final int calculateInheritanceDepth(IType type, IType baseClass) {
        return SemanticUtil.calculateInheritanceDepth(40, new HashSet<Object>(), type, baseClass);
    }

    private static final int calculateInheritanceDepth(int maxdepth, Set<Object> hashSet, IType type, IType baseClass) {
        if (type == baseClass || type.isSameType(baseClass)) {
            return 0;
        }
        if (maxdepth > 0 && type instanceof ICPPClassType && baseClass instanceof ICPPClassType) {
            ICPPClassType clazz = (ICPPClassType)type;
            if (clazz instanceof ICPPDeferredClassInstance) {
                clazz = (ICPPClassType)((ICPPDeferredClassInstance)clazz).getSpecializedBinding();
            }
            clazz = (ICPPClassType)SemanticUtil.mapToAST(clazz);
            ICPPBase[] iCPPBaseArray = clazz.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof IType && hashSet.add(base)) {
                    int n3;
                    IType tbase = (IType)((Object)base);
                    if (tbase.isSameType(baseClass) || baseClass instanceof ICPPSpecialization && ((IType)((Object)((ICPPSpecialization)((Object)baseClass)).getSpecializedBinding())).isSameType(tbase)) {
                        return 1;
                    }
                    if (tbase instanceof ICPPClassType && (n3 = SemanticUtil.calculateInheritanceDepth(maxdepth - 1, hashSet, tbase, baseClass)) > 0) {
                        return n3 + 1;
                    }
                }
                ++n2;
            }
        }
        return -1;
    }

    public static boolean isUniqueTypeForParameterPack(IType type) {
        if (type instanceof UniqueType) {
            return ((UniqueType)type).isForParameterPack();
        }
        return false;
    }

    public static long computeMaxValue(IEnumeration enumeration) {
        IEnumerator[] enumerators;
        long maxValue = Long.MIN_VALUE;
        IEnumerator[] iEnumeratorArray = enumerators = enumeration.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            Number val;
            IEnumerator enumerator = iEnumeratorArray[n2];
            IValue value = enumerator.getValue();
            if (value != null && (val = value.numberValue()) != null && (v = val.longValue()) > maxValue) {
                maxValue = v;
            }
            ++n2;
        }
        return maxValue;
    }

    public static long computeMinValue(IEnumeration enumeration) {
        IEnumerator[] enumerators;
        long minValue = Long.MAX_VALUE;
        IEnumerator[] iEnumeratorArray = enumerators = enumeration.getEnumerators();
        int n = enumerators.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            Number val;
            IEnumerator enumerator = iEnumeratorArray[n2];
            IValue value = enumerator.getValue();
            if (value != null && (val = value.numberValue()) != null && (v = val.longValue()) < minValue) {
                minValue = v;
            }
            ++n2;
        }
        return minValue;
    }

    public static int findSameType(IType type, IType[] types) {
        int i = 0;
        while (i < types.length) {
            if (type.isSameType(types[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static IValue getValueOfInitializer(IASTInitializer init, IType type) {
        CPPSemantics.pushLookupPoint(init);
        try {
            IValue iValue = SemanticUtil.applyIntegerConversion(SemanticUtil.getValueOfInitializerImpl(init, type), type);
            return iValue;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    private static IValue getValueOfInitializerImpl(IASTInitializer init, IType type) {
        IASTInitializerClause clause = null;
        if (init instanceof IASTEqualsInitializer) {
            clause = ((IASTEqualsInitializer)init).getInitializerClause();
        } else if (init instanceof ICPPASTConstructorInitializer) {
            IType typeUpToPointers;
            IASTInitializerClause[] args = ((ICPPASTConstructorInitializer)init).getArguments();
            if (args.length == 1 && args[0] instanceof IASTExpression && ((typeUpToPointers = SemanticUtil.getUltimateTypeUptoPointers(type)) instanceof IPointerType || typeUpToPointers instanceof IBasicType)) {
                clause = args[0];
            }
        } else if (init instanceof ICPPASTInitializerList) {
            ICPPASTInitializerList list = (ICPPASTInitializerList)init;
            switch (list.getSize()) {
                case 0: {
                    return IntegralValue.create(0L);
                }
                case 1: {
                    clause = list.getClauses()[0];
                    break;
                }
                default: {
                    return ((ICPPASTInitializerList)init).getEvaluation().getValue();
                }
            }
        }
        if (clause instanceof IASTExpression) {
            return ValueFactory.create((IASTExpression)clause);
        }
        if (clause instanceof ICPPASTInitializerList) {
            return ((ICPPASTInitializerList)clause).getEvaluation().getValue();
        }
        return IntegralValue.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    public static IValue applyIntegerConversion(IValue value, IType targetType) {
        IType iType;
        if (value instanceof IntegralValue && value.numberValue() != null && (iType = SemanticUtil.getUltimateTypeUptoPointers(targetType)) instanceof IBasicType) {
            void basicType;
            IBasicType iBasicType = (IBasicType)iType;
            IBasicType cfr_ignored_0 = (IBasicType)iType;
            if (basicType.getKind() == IBasicType.Kind.eBoolean) {
                return IntegralValue.create(value.numberValue().longValue() == 0L ? 0 : 1);
            }
            SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment((IType)basicType);
            if (sizeAndAlignment != null && sizeAndAlignment.size < 8L) {
                long val = value.numberValue().longValue();
                boolean doSignExtend = val < 0L && !basicType.isUnsigned();
                long mask = (1L << (int)(sizeAndAlignment.size * 8L)) - 1L;
                val &= mask;
                if (doSignExtend) {
                    val |= mask ^ 0xFFFFFFFFFFFFFFFFL;
                }
                return IntegralValue.create(val);
            }
        }
        return value;
    }

    public static boolean isConst(IType type) {
        if (type instanceof ICPPReferenceType) {
            ICPPReferenceType refType = (ICPPReferenceType)type;
            return SemanticUtil.isConst(refType.getType());
        }
        return ExpressionTypes.isConst(type);
    }

    public static boolean isVolatile(IType type) {
        if (type instanceof ICPPReferenceType) {
            ICPPReferenceType refType = (ICPPReferenceType)type;
            return SemanticUtil.isVolatile(refType.getType());
        }
        return ExpressionTypes.isVolatile(type);
    }

    static IType[] addImplicitParameterType(IType[] types, ICPPMethod m) {
        IType t = CPPSemantics.getImplicitParameterType(m);
        return SemanticUtil.concatTypes(t, types);
    }

    static IType[] concatTypes(IType t, IType[] types) {
        IType[] result = new IType[types.length + 1];
        result[0] = t;
        System.arraycopy(types, 0, result, 1, types.length);
        return result;
    }

    public static IType[] getParameterTypesIncludingImplicitThis(ICPPFunction function) {
        IType[] result = function.getType().getParameterTypes();
        if (function instanceof ICPPMethod && !function.isStatic()) {
            result = SemanticUtil.addImplicitParameterType(result, (ICPPMethod)function);
        }
        return result;
    }

    public static IType applyTypeTransformation(ICPPUnaryTypeTransformation.Operator operator, IType type) {
        switch (operator) {
            case underlying_type: {
                return TypeTraits.underlyingType(type);
            }
        }
        return null;
    }
}

