/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CField;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CStructure
extends PlatformObject
implements ICompositeType,
ICInternalBinding {
    private IASTName[] declarations;
    private IASTName definition;
    private boolean checked;
    private ICompositeType typeInIndex;

    public CStructure(IASTName name) {
        if (name.getPropertyInParent() == IASTCompositeTypeSpecifier.TYPE_NAME) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    private void checkForDefinition() {
        if (!this.checked && this.definition == null) {
            IASTTranslationUnit translationUnit;
            IIndex index;
            IASTDeclSpecifier spec;
            IASTNode declSpec = this.declarations[0].getParent();
            if (declSpec instanceof ICASTElaboratedTypeSpecifier && (spec = CVisitor.findDefinition((ICASTElaboratedTypeSpecifier)declSpec)) instanceof ICASTCompositeTypeSpecifier) {
                ICASTCompositeTypeSpecifier compTypeSpec = (ICASTCompositeTypeSpecifier)spec;
                this.definition = compTypeSpec.getName();
                this.definition.setBinding(this);
            }
            if (this.definition == null && this.typeInIndex == null && (index = (translationUnit = declSpec.getTranslationUnit()).getIndex()) != null) {
                this.typeInIndex = (ICompositeType)((Object)index.adaptBinding(this));
            }
        }
        this.checked = true;
    }

    @Override
    public String getName() {
        if (this.definition != null) {
            return this.definition.toString();
        }
        return this.declarations[0].toString();
    }

    @Override
    public char[] getNameCharArray() {
        if (this.definition != null) {
            return this.definition.toCharArray();
        }
        return this.declarations[0].toCharArray();
    }

    @Override
    public IScope getScope() throws DOMException {
        IASTDeclSpecifier declSpec = (IASTDeclSpecifier)(this.definition != null ? this.definition.getParent() : this.declarations[0].getParent());
        IScope scope = CVisitor.getContainingScope(declSpec);
        while (scope instanceof ICCompositeTypeScope) {
            scope = scope.getParent();
        }
        return scope;
    }

    @Override
    public IField[] getFields() {
        this.checkForDefinition();
        if (this.definition == null) {
            return new IField[]{new CField.CFieldProblem(this, (IASTNode)this.declarations[0], 7, this.getNameCharArray())};
        }
        ICASTCompositeTypeSpecifier compSpec = (ICASTCompositeTypeSpecifier)this.definition.getParent();
        IField[] fields = this.collectFields(compSpec, IField.EMPTY_FIELD_ARRAY);
        return ArrayUtil.trim(fields);
    }

    private IField[] collectFields(ICASTCompositeTypeSpecifier compSpec, IField[] fields) {
        IASTDeclaration[] members = compSpec.getMembers();
        if (members.length > 0) {
            if (fields == null) {
                fields = new IField[members.length];
            }
            IASTDeclaration[] iASTDeclarationArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration node = iASTDeclarationArray[n2];
                if (node instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] declarators = ((IASTSimpleDeclaration)node).getDeclarators();
                    if (declarators.length == 0) {
                        IASTDeclSpecifier declspec = ((IASTSimpleDeclaration)node).getDeclSpecifier();
                        if (declspec instanceof ICASTCompositeTypeSpecifier) {
                            fields = this.collectFields((ICASTCompositeTypeSpecifier)declspec, fields);
                        }
                    } else {
                        IASTDeclarator[] iASTDeclaratorArray = declarators;
                        int n3 = declarators.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTDeclarator declarator = iASTDeclaratorArray[n4];
                            IASTName name = ASTQueries.findInnermostDeclarator(declarator).getName();
                            IBinding binding = name.resolveBinding();
                            if (binding instanceof IField) {
                                fields = ArrayUtil.append(fields, (IField)binding);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return fields;
    }

    @Override
    public IField findField(String name) {
        IScope scope = this.getCompositeScope();
        if (scope == null) {
            return new CField.CFieldProblem(this, (IASTNode)this.declarations[0], 7, this.getNameCharArray());
        }
        CASTName astName = new CASTName(name.toCharArray());
        astName.setPropertyInParent(CVisitor.STRING_LOOKUP_PROPERTY);
        IBinding binding = scope.getBinding(astName, true);
        if (binding instanceof IField) {
            return (IField)binding;
        }
        return null;
    }

    @Override
    public int getKey() {
        return this.definition != null ? ((IASTCompositeTypeSpecifier)this.definition.getParent()).getKey() : ((IASTElaboratedTypeSpecifier)this.declarations[0].getParent()).getKind();
    }

    @Override
    public IScope getCompositeScope() {
        IScope scope;
        this.checkForDefinition();
        if (this.definition != null) {
            return ((IASTCompositeTypeSpecifier)this.definition.getParent()).getScope();
        }
        if (this.typeInIndex != null && (scope = this.typeInIndex.getCompositeScope()) instanceof ICCompositeTypeScope) {
            return scope;
        }
        return null;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    public void addDefinition(ICASTCompositeTypeSpecifier compositeTypeSpec) {
        if (compositeTypeSpec.isActive()) {
            this.definition = compositeTypeSpec.getName();
            compositeTypeSpec.getName().setBinding(this);
        }
    }

    public void addDeclaration(IASTName decl) {
        if (!decl.isActive() || decl.getPropertyInParent() != IASTElaboratedTypeSpecifier.TYPE_NAME) {
            return;
        }
        decl.setBinding(this);
        if (this.declarations == null || this.declarations.length == 0) {
            this.declarations = new IASTName[]{decl};
            return;
        }
        IASTName first = this.declarations[0];
        if (((ASTNode)((Object)first)).getOffset() > ((ASTNode)((Object)decl)).getOffset()) {
            this.declarations[0] = decl;
            decl = first;
        }
        this.declarations = ArrayUtil.append(IASTName.class, this.declarations, decl);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.definition;
    }

    @Override
    public IBinding getOwner() {
        IBinding result;
        IASTName node = this.definition;
        if (node == null && this.declarations != null && this.declarations.length > 0) {
            node = this.declarations[0];
        }
        if ((result = CVisitor.findEnclosingFunction(node)) != null) {
            return result;
        }
        if (this.definition != null && this.isAnonymous()) {
            return CVisitor.findDeclarationOwner(this.definition, false);
        }
        return null;
    }

    @Override
    public boolean isAnonymous() {
        IASTNode node;
        if (this.getNameCharArray().length > 0 || this.definition == null) {
            return false;
        }
        IASTCompositeTypeSpecifier spec = (IASTCompositeTypeSpecifier)this.definition.getParent();
        return spec != null && (node = spec.getParent()) instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)node).getDeclarators().length == 0;
    }

    public String toString() {
        return this.getName();
    }

    public static class CStructureProblem
    extends ProblemBinding
    implements ICompositeType {
        public CStructureProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        @Override
        public IField findField(String name) {
            return null;
        }

        @Override
        public IScope getCompositeScope() {
            return this;
        }

        @Override
        public IField[] getFields() {
            return IField.EMPTY_FIELD_ARRAY;
        }

        @Override
        public int getKey() {
            return 1;
        }
    }
}

