/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.tracecompass.incubator.internal.filters.core.Activator;
import org.eclipse.tracecompass.incubator.internal.filters.core.shared.LspObservable;
import org.eclipse.tracecompass.incubator.internal.filters.core.shared.LspObserver;

public class LanguageFilterClient
implements LanguageClient,
LspObservable {
    private static final int fCorePoolSize = 2;
    private static final int fMaxPoolSize = 4;
    private static final long fKeepAliveTime = 3000L;
    private LanguageServer fServerProxy;
    private List<LspObserver> fObservers = new ArrayList<LspObserver>();
    private Integer fCursor = 0;
    private ThreadPoolExecutor fThreadPoolExecutor;

    public LanguageFilterClient() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.fThreadPoolExecutor = new ThreadPoolExecutor(2, 4, 3000L, TimeUnit.MILLISECONDS, queue);
    }

    public void telemetryEvent(Object object) {
        throw new UnsupportedOperationException();
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        String uri = diagnostics.getUri();
        for (LspObserver observer : this.fObservers) {
            observer.diagnostic(uri, diagnostics.getDiagnostics());
        }
        TextDocumentIdentifier textDocumentIdentifier = new TextDocumentIdentifier(uri);
        this.fThreadPoolExecutor.execute(this.getCompletionTask(uri, textDocumentIdentifier));
        this.fThreadPoolExecutor.execute(this.getSyntaxHighlightingTask(uri, textDocumentIdentifier));
    }

    private Runnable getCompletionTask(String uri, TextDocumentIdentifier textDocumentIdentifier) {
        return () -> {
            Position position = new Position();
            position.setLine(0);
            position.setCharacter(this.fCursor.intValue());
            CompletionParams completionParams = new CompletionParams(textDocumentIdentifier, position);
            try {
                Either completion = (Either)this.fServerProxy.getTextDocumentService().completion(completionParams).get();
                for (LspObserver observer : this.fObservers) {
                    observer.completion(uri, (Either<List<CompletionItem>, CompletionList>)completion);
                }
            }
            catch (Exception e) {
                Activator.getInstance().logError(e.getMessage());
            }
        };
    }

    private Runnable getSyntaxHighlightingTask(String uri, TextDocumentIdentifier textDocumentIdentifier) {
        return () -> {
            DocumentColorParams colorParams = new DocumentColorParams(textDocumentIdentifier);
            try {
                List colors = (List)this.fServerProxy.getTextDocumentService().documentColor(colorParams).get();
                for (LspObserver observer : this.fObservers) {
                    observer.syntaxHighlighting(uri, colors);
                }
            }
            catch (Exception e) {
                Activator.getInstance().logError(e.getMessage());
            }
        };
    }

    public void showMessage(MessageParams messageParams) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        throw new UnsupportedOperationException();
    }

    public void logMessage(MessageParams message) {
        throw new UnsupportedOperationException();
    }

    public void setServer(LanguageServer server) {
        this.fServerProxy = server;
    }

    @Override
    public void register(@NonNull LspObserver obs) {
        this.fObservers.add(obs);
    }

    public void tellDidOpen(String uri) {
        TextDocumentItem filterBoxId = new TextDocumentItem();
        filterBoxId.setUri(uri);
        DidOpenTextDocumentParams didOpenParams = new DidOpenTextDocumentParams(filterBoxId);
        this.fServerProxy.getTextDocumentService().didOpen(didOpenParams);
    }

    public void tellDidChange(String uri, String input, int cursorPos) {
        this.fCursor = cursorPos;
        if (input.isEmpty()) {
            return;
        }
        Integer min = 0;
        Integer max = input.length() - 1;
        Position p1 = new Position(0, min.intValue());
        Position p2 = new Position(0, max.intValue());
        Range r = new Range(p1, p2);
        TextDocumentContentChangeEvent change = new TextDocumentContentChangeEvent(r, Integer.valueOf(max + 1), input);
        ArrayList<TextDocumentContentChangeEvent> changelist = new ArrayList<TextDocumentContentChangeEvent>();
        changelist.add(change);
        VersionedTextDocumentIdentifier filterBoxId = new VersionedTextDocumentIdentifier();
        filterBoxId.setUri(uri);
        DidChangeTextDocumentParams params = new DidChangeTextDocumentParams(filterBoxId, changelist);
        this.fServerProxy.getTextDocumentService().didChange(params);
    }

    public void shutdown() {
        this.fServerProxy.shutdown();
        this.fServerProxy.exit();
    }
}

