/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.optional.imageio.Draw;
import org.apache.tools.ant.types.optional.imageio.ImageOperation;
import org.apache.tools.ant.types.optional.imageio.Rotate;
import org.apache.tools.ant.types.optional.imageio.Scale;
import org.apache.tools.ant.types.optional.imageio.TransformOperation;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.StringUtils;

public class ImageIOTask
extends MatchingTask {
    private final List<ImageOperation> instructions = new ArrayList<ImageOperation>();
    private boolean overwrite = false;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private File srcDir = null;
    private File destDir = null;
    private ImageFormat outputFormat;
    private boolean garbageCollect = false;
    private boolean failOnError = true;
    private Mapper mapperElement = null;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setFailOnError(boolean flag) {
        this.failOnError = flag;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setFormat(ImageFormat format) {
        this.outputFormat = format;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setGc(boolean gc) {
        this.garbageCollect = gc;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addImageOperation(ImageOperation instr) {
        this.instructions.add(instr);
    }

    public void addRotate(Rotate instr) {
        this.instructions.add(instr);
    }

    public void addScale(Scale instr) {
        this.instructions.add(instr);
    }

    public void addDraw(Draw instr) {
        this.instructions.add(instr);
    }

    public void add(ImageOperation instr) {
        this.addImageOperation(instr);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public int processDir(File srcDir, String[] srcNames, File dstDir, FileNameMapper mapper) {
        int writeCount = 0;
        for (String srcName : srcNames) {
            File srcFile = new File(srcDir, srcName).getAbsoluteFile();
            String[] dstNames = mapper.mapFileName(srcName);
            if (dstNames == null) {
                this.log(srcFile + " skipped, don't know how to handle it", 3);
                continue;
            }
            for (String dstName : dstNames) {
                File dstFile = new File(dstDir, dstName).getAbsoluteFile();
                if (dstFile.exists()) {
                    if (!this.overwrite && srcFile.lastModified() <= dstFile.lastModified()) {
                        this.log(srcFile + " omitted as " + dstFile + " is up to date.", 3);
                        continue;
                    }
                    if (!srcFile.equals(dstFile)) {
                        dstFile.delete();
                    }
                }
                this.processFile(srcFile, dstFile);
                ++writeCount;
            }
        }
        if (this.garbageCollect) {
            System.gc();
        }
        return writeCount;
    }

    @Deprecated
    public void processFile(File file) {
        this.processFile(file, new File(this.destDir == null ? this.srcDir : this.destDir, file.getName()));
    }

    public void processFile(File file, File newFile) {
        this.log("Processing File: " + file.getAbsolutePath());
        try (ImageInputStream input = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            if (!readers.hasNext()) {
                this.log("No decoder available, skipping");
                return;
            }
            ImageReader reader = readers.next();
            if (this.outputFormat == null) {
                this.outputFormat = new ImageFormat(reader.getFormatName());
            }
            reader.setInput(input);
            BufferedImage image = reader.read(0);
            reader.dispose();
            for (ImageOperation instr : this.instructions) {
                if (instr instanceof TransformOperation) {
                    image = ((TransformOperation)instr).executeTransformOperation(image);
                    continue;
                }
                this.log("Not a TransformOperation: " + (Object)((Object)instr));
            }
            File dstParent = newFile.getParentFile();
            if (!(dstParent.isDirectory() || dstParent.mkdirs() || dstParent.isDirectory())) {
                throw new BuildException("Failed to create parent directory %s", new Object[]{dstParent});
            }
            if (this.overwrite && newFile.exists() && !newFile.equals(file)) {
                newFile.delete();
            }
            if (!ImageIO.write((RenderedImage)image, this.outputFormat.getValue(), newFile)) {
                this.log("Failed to save the transformed file");
            }
        }
        catch (IOException | RuntimeException err) {
            if (!file.equals(newFile)) {
                newFile.delete();
            }
            if (!this.failOnError) {
                this.log("Error processing file:  " + err);
            }
            throw new BuildException((Throwable)err);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            IdentityMapper mapper;
            File dest = this.destDir != null ? this.destDir : this.srcDir;
            int writeCount = 0;
            Object object = mapper = this.mapperElement == null ? new IdentityMapper() : this.mapperElement.getImplementation();
            if (this.srcDir != null) {
                writeCount += this.processDir(this.srcDir, super.getDirectoryScanner(this.srcDir).getIncludedFiles(), dest, (FileNameMapper)mapper);
            }
            for (FileSet fs : this.filesets) {
                writeCount += this.processDir(fs.getDir(), fs.getDirectoryScanner().getIncludedFiles(), dest, (FileNameMapper)mapper);
            }
            if (writeCount > 0) {
                this.log("Processed " + writeCount + (writeCount == 1 ? " image." : " images."));
            }
        }
        catch (Exception err) {
            this.log(StringUtils.getStackTrace((Throwable)err), 0);
            throw new BuildException(err.getMessage());
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.srcDir == null && this.filesets.isEmpty()) {
            throw new BuildException("Specify at least one source--a srcDir or a fileset.");
        }
        if (this.srcDir == null && this.destDir == null) {
            throw new BuildException("Specify the destDir, or the srcDir.");
        }
    }

    public static class ImageFormat
    extends EnumeratedAttribute {
        private static final String[] VALUES = ImageIO.getReaderFormatNames();

        public ImageFormat() {
        }

        public ImageFormat(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return VALUES;
        }
    }
}

