/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DotExport {
    public String exportDot(Graph graph) {
        return this.exportDot(CollectionLiterals.newArrayList((Object[])new Graph[]{graph}));
    }

    public String exportDot(List<Graph> graphs) {
        String _xblockexpression = null;
        StringBuilder builder = new StringBuilder();
        for (Graph graph : graphs) {
            boolean _tripleEquals;
            GraphType _type = this.type(graph);
            boolean bl = _tripleEquals = _type == null;
            if (_tripleEquals) {
                throw new IllegalArgumentException("The _type attribute has to be set on the input graph " + graph + ".");
            }
            Functions.Function1 _function = it -> {
                Graph _nestedGraph = it.getNestedGraph();
                return _nestedGraph == null;
            };
            Functions.Function1 _function_1 = it -> {
                boolean _hasName = this.hasName((IAttributeStore)it);
                return !_hasName;
            };
            boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.filter((Iterable)graph.getNodes(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            if (_exists) {
                throw new IllegalArgumentException("The _name attribute has to be set for all nodes of the input graph " + graph + ".");
            }
            builder.append(this.print(graph));
        }
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    public File exportDot(Graph graph, String pathname) {
        String _exportDot = this.exportDot(graph);
        File _file = new File(pathname);
        return DotFileUtils.write(_exportDot, _file);
    }

    public File exportDot(List<Graph> graphs, String pathname) {
        String _exportDot = this.exportDot(graphs);
        File _file = new File(pathname);
        return DotFileUtils.write(_exportDot, _file);
    }

    private String print(Graph it) {
        StringConcatenation _builder = new StringConcatenation();
        GraphType _type = this.type(it);
        _builder.append((Object)_type);
        _builder.append(" ");
        boolean _hasName = this.hasName((IAttributeStore)it);
        if (_hasName) {
            String _name = this.name((IAttributeStore)it);
            _builder.append(_name);
            _builder.append(" ");
        }
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        boolean _hasNonMetaAttributes = this.hasNonMetaAttributes((IAttributeStore)it);
        if (_hasNonMetaAttributes) {
            _builder.append("\t");
            String _printNonMetaAttributes = this.printNonMetaAttributes((IAttributeStore)it, ";");
            _builder.append(_printNonMetaAttributes, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        Functions.Function1 _function = it_1 -> this.print((Node)it_1);
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)it.getNodes(), (Functions.Function1)_function), (CharSequence)"; ");
        _builder.append(_join, "\t");
        _builder.newLineIfNotEmpty();
        ObservableList _edges = it.getEdges();
        for (Edge edge : _edges) {
            _builder.append("\t");
            String _name_1 = this.name((IAttributeStore)edge);
            _builder.append(_name_1, "\t");
            boolean _hasNonMetaAttributes_1 = this.hasNonMetaAttributes((IAttributeStore)edge);
            if (_hasNonMetaAttributes_1) {
                _builder.append(" [");
                String _printNonMetaAttributes_1 = this.printNonMetaAttributes((IAttributeStore)edge, ",");
                _builder.append(_printNonMetaAttributes_1, "\t");
                _builder.append("]");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private boolean isMetaAttribute(String it) {
        return it.startsWith("_");
    }

    private String print(Node it) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        Graph _nestedGraph = it.getNestedGraph();
        boolean bl = _tripleNotEquals = _nestedGraph != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("subgraph ");
            boolean _hasName = this.hasName((IAttributeStore)it.getNestedGraph());
            if (_hasName) {
                String _name = this.name((IAttributeStore)it.getNestedGraph());
                _builder.append(_name);
                _builder.append(" ");
            }
            _builder.append("{");
            _builder.newLineIfNotEmpty();
            boolean _hasNonMetaAttributes = this.hasNonMetaAttributes((IAttributeStore)it.getNestedGraph());
            if (_hasNonMetaAttributes) {
                _builder.append("\t");
                String _printNonMetaAttributes = this.printNonMetaAttributes((IAttributeStore)it.getNestedGraph(), ";");
                _builder.append(_printNonMetaAttributes, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            Functions.Function1 _function = it_1 -> this.print((Node)it_1);
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)it.getNestedGraph().getNodes(), (Functions.Function1)_function), (CharSequence)"; ");
            _builder.append(_join, "\t");
            _builder.newLineIfNotEmpty();
            ObservableList _edges = it.getNestedGraph().getEdges();
            for (Edge edge : _edges) {
                _builder.append("\t");
                String _name_1 = this.name((IAttributeStore)edge);
                _builder.append(_name_1, "\t");
                boolean _hasNonMetaAttributes_1 = this.hasNonMetaAttributes((IAttributeStore)edge);
                if (_hasNonMetaAttributes_1) {
                    _builder.append(" [");
                    String _printNonMetaAttributes_1 = this.printNonMetaAttributes((IAttributeStore)edge, ",");
                    _builder.append(_printNonMetaAttributes_1, "\t");
                    _builder.append("]");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _xifexpression = _builder.toString();
        } else {
            String _name_2 = this.name((IAttributeStore)it);
            String _xifexpression_1 = null;
            boolean _hasNonMetaAttributes_2 = this.hasNonMetaAttributes((IAttributeStore)it);
            if (_hasNonMetaAttributes_2) {
                String _printNonMetaAttributes_2 = this.printNonMetaAttributes((IAttributeStore)it, ",");
                String _plus = " [" + _printNonMetaAttributes_2;
                _xifexpression_1 = String.valueOf(_plus) + "]";
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = String.valueOf(_name_2) + _xifexpression_1;
        }
        return _xifexpression;
    }

    private boolean hasName(IAttributeStore it) {
        Object _get = it.getAttributes().get((Object)"_name");
        return _get != null;
    }

    private GraphType type(Graph it) {
        return DotAttributes._getType(it);
    }

    private String _name(IAttributeStore it) {
        Object _get = it.getAttributes().get((Object)"_name");
        return ((ID)_get).toValue();
    }

    private String _name(Edge it) {
        return DotAttributes._getName(it);
    }

    private boolean hasNonMetaAttributes(IAttributeStore it) {
        Functions.Function1 _function = it_1 -> {
            boolean _isMetaAttribute = this.isMetaAttribute((String)it_1);
            return !_isMetaAttribute;
        };
        return IterableExtensions.exists((Iterable)it.getAttributes().keySet(), (Functions.Function1)_function);
    }

    private String printNonMetaAttributes(IAttributeStore it, String separator) {
        Functions.Function1 _function = it_1 -> {
            boolean _isMetaAttribute = this.isMetaAttribute((String)it_1.getKey());
            return !_isMetaAttribute;
        };
        Functions.Function1 _function_1 = it_1 -> {
            String _key = (String)it_1.getKey();
            String _plus = String.valueOf(_key) + "=";
            String _string = it_1.getValue().toString();
            return String.valueOf(_plus) + _string;
        };
        return IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)it.getAttributes().entrySet(), (Functions.Function1)_function), (Functions.Function1)_function_1)), (CharSequence)(String.valueOf(separator) + " "));
    }

    private String name(IAttributeStore it) {
        if (it instanceof Edge) {
            return this._name((Edge)it);
        }
        if (it != null) {
            return this._name(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

