/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.examples.text.edit.BlockEditPolicy;
import org.eclipse.gef.examples.text.edit.BlockTextPart;
import org.eclipse.gef.examples.text.edit.TextStyleManager;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.Style;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.requests.CaretRequest;
import org.eclipse.gef.examples.text.requests.SearchResult;

public class DocumentPart
extends BlockTextPart
implements TextStyleManager {
    public DocumentPart(Container model) {
        super(model);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Text Editing", (EditPolicy)new BlockEditPolicy());
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == TextStyleManager.class) {
            return key.cast(this);
        }
        return (T)super.getAdapter(key);
    }

    @Override
    public void getTextLocation(CaretRequest search, SearchResult result) {
        if (search.getType() == CaretRequest.DOCUMENT) {
            search.isInto = true;
            search.isForward = !search.isForward;
            search.isRecursive = true;
            search.setType(CaretRequest.COLUMN);
        }
        super.getTextLocation(search, result);
    }

    @Override
    public Object getStyleState(String styleID, SelectionRange range) {
        return StyleService.STATE_EDITABLE;
    }

    @Override
    public Object getStyleValue(String styleID, SelectionRange range) {
        switch (styleID) {
            case "bold": {
                for (EditPart ep : range.getLeafParts()) {
                    TextRun run = (TextRun)ep.getModel();
                    if (run.getContainer().getStyle().isBold()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case "fontSize": {
                int fontHeight = -1;
                for (EditPart editPart : range.getLeafParts()) {
                    TextRun run = (TextRun)editPart.getModel();
                    if (fontHeight == -1) {
                        fontHeight = run.getContainer().getStyle().getFontHeight();
                        continue;
                    }
                    if (fontHeight == run.getContainer().getStyle().getFontHeight()) continue;
                    return StyleService.UNDEFINED;
                }
                return fontHeight;
            }
            case "font": {
                String fontName = null;
                for (EditPart editPart : range.getLeafParts()) {
                    TextRun run = (TextRun)editPart.getModel();
                    if (fontName == null) {
                        fontName = run.getContainer().getStyle().getFontFamily();
                        continue;
                    }
                    if (fontName.equals(run.getContainer().getStyle().getFontFamily())) continue;
                    return StyleService.UNDEFINED;
                }
                return fontName;
            }
            case "italics": {
                for (EditPart editPart : range.getLeafParts()) {
                    TextRun run = (TextRun)editPart.getModel();
                    if (run.getContainer().getStyle().isItalic()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case "underline": {
                for (EditPart name : range.getLeafParts()) {
                    TextRun run = (TextRun)name.getModel();
                    if (run.getContainer().getStyle().isUnderline()) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case "alignment": {
                int alignment = 0;
                for (EditPart editPart : range.getLeafParts()) {
                    TextRun run = (TextRun)editPart.getModel();
                    Style style = run.getBlockContainer().getStyle();
                    if (alignment == 0) {
                        alignment = style.getAlignment();
                    }
                    if (style.isSet(styleID) && style.getAlignment() == alignment) continue;
                    return StyleService.UNDEFINED;
                }
                return alignment;
            }
            case "orientation": {
                int orientation = 0;
                for (EditPart editPart : range.getLeafParts()) {
                    TextRun run = (TextRun)editPart.getModel();
                    Style style = run.getBlockContainer().getStyle();
                    if (orientation == 0) {
                        orientation = style.getOrientation();
                    }
                    if (style.isSet(styleID) && style.getOrientation() == orientation) continue;
                    return StyleService.UNDEFINED;
                }
                return orientation;
            }
        }
        return StyleService.UNDEFINED;
    }
}

