/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.edit;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.edit.LogicContainerEditPart;
import org.eclipse.gef.examples.logicdesigner.edit.LogicXYLayoutEditPolicy;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class LogicDiagramEditPart
extends LogicContainerEditPart
implements LayerConstants {
    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent e) {
                e.result = LogicMessages.LogicDiagram_LabelText;
            }
        };
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("Selection Feedback", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LogicXYLayoutEditPolicy((XYLayout)this.getContentPane().getLayoutManager()));
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        f.setBorder((Border)new MarginBorder(5));
        return f;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.isEmpty()) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return adapter.cast(snapStrategies.get(0));
            }
            return adapter.cast(new CompoundSnapToHelper(snapStrategies.toArray(new SnapToHelper[0])));
        }
        return (T)super.getAdapter(adapter);
    }

    public DragTracker getDragTracker(Request req) {
        SelectionRequest selReq;
        if (req instanceof SelectionRequest && (selReq = (SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new MarqueeDragTracker();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(int x, int y) {
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart editPart) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(int x, int y) {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("router".equals(evt.getPropertyName())) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected void refreshVisuals() {
        Animation.markBegin();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if ((this.getViewer().getControl().getStyle() & 0x8000000) == 0) {
            cLayer.setAntialias(1);
        }
        if (this.getModel().getConnectionRouter().equals(LogicDiagram.ROUTER_MANUAL)) {
            FanRouter router = new FanRouter();
            router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            cLayer.setConnectionRouter((ConnectionRouter)router);
        } else if (this.getModel().getConnectionRouter().equals(LogicDiagram.ROUTER_MANHATTAN)) {
            cLayer.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        } else {
            cLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter(this.getFigure()));
        }
        Animation.run((int)400);
    }
}

