/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.layouts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class FlowLayoutExample
extends AbstractExample {
    FlowLayout layout;
    private Ellipse ellipse1;
    private RectangleFigure rect1;
    private RoundedRectangle rect2;
    private RectangleFigure rect3;
    private Ellipse ellipse2;
    private Triangle triangle1;
    private RoundedRectangle rect4;
    private RectangleFigure rect5;
    private Triangle triangle2;
    private Ellipse ellipse3;
    private RoundedRectangle rect6;

    public static void main(String[] args) {
        new FlowLayoutExample().run();
    }

    @Override
    protected IFigure createContents() {
        Figure container = new Figure();
        container.setBorder((Border)new LineBorder());
        this.layout = new FlowLayout();
        container.setLayoutManager((LayoutManager)this.layout);
        this.ellipse1 = new Ellipse();
        this.ellipse1.setBackgroundColor(ColorConstants.blue);
        this.ellipse1.setSize(60, 40);
        container.add((IFigure)this.ellipse1);
        this.rect1 = new RectangleFigure();
        this.rect1.setBackgroundColor(ColorConstants.red);
        this.rect1.setSize(30, 70);
        container.add((IFigure)this.rect1);
        this.rect2 = new RoundedRectangle();
        this.rect2.setBackgroundColor(ColorConstants.yellow);
        this.rect2.setSize(90, 30);
        container.add((IFigure)this.rect2);
        this.rect3 = new RectangleFigure();
        this.rect3.setBackgroundColor(ColorConstants.gray);
        this.rect3.setSize(50, 80);
        container.add((IFigure)this.rect3);
        this.ellipse2 = new Ellipse();
        this.ellipse2.setBackgroundColor(ColorConstants.green);
        this.ellipse2.setSize(50, 50);
        container.add((IFigure)this.ellipse2);
        this.triangle1 = new Triangle();
        this.triangle1.setBackgroundColor(ColorConstants.black);
        this.triangle1.setSize(50, 50);
        container.add((IFigure)this.triangle1);
        this.rect4 = new RoundedRectangle();
        this.rect4.setBackgroundColor(ColorConstants.cyan);
        this.rect4.setSize(50, 50);
        container.add((IFigure)this.rect4);
        this.rect5 = new RectangleFigure();
        this.rect5.setBackgroundColor(ColorConstants.darkGreen);
        this.rect5.setSize(50, 70);
        container.add((IFigure)this.rect5);
        this.triangle2 = new Triangle();
        this.triangle2.setBackgroundColor(ColorConstants.orange);
        this.triangle2.setSize(50, 50);
        container.add((IFigure)this.triangle2);
        this.ellipse3 = new Ellipse();
        this.ellipse3.setBackgroundColor(ColorConstants.red);
        this.ellipse3.setSize(50, 50);
        container.add((IFigure)this.ellipse3);
        this.rect6 = new RoundedRectangle();
        this.rect6.setBackgroundColor(ColorConstants.yellow);
        this.rect6.setSize(50, 50);
        container.add((IFigure)this.rect6);
        return container;
    }

    @Override
    protected void hookShell(final Shell shell) {
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(1040));
        composite.setLayout((Layout)new GridLayout());
        Button horizontal = new Button(composite, 32);
        horizontal.setText("Horizontal");
        horizontal.setSelection(true);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setHorizontal(!FlowLayoutExample.this.layout.isHorizontal());
                FlowLayoutExample.this.resetShapes();
                FlowLayoutExample.this.getContents().revalidate();
                shell.layout(true);
            }
        });
        final Button stretch = new Button(composite, 32);
        stretch.setText("Stretch Minor Axis");
        stretch.setSelection(false);
        stretch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setStretchMinorAxis(stretch.getSelection());
                FlowLayoutExample.this.resetShapes();
                FlowLayoutExample.this.getContents().revalidate();
                shell.layout(true);
            }
        });
        Group major = new Group(composite, 0);
        major.setLayout((Layout)new FillLayout(512));
        major.setText("Major Axis");
        Button left = new Button((Composite)major, 16);
        left.setText("Top/Left");
        left.setSelection(true);
        left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorAlignment(1);
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        Button center = new Button((Composite)major, 16);
        center.setText("Middle/Center");
        center.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorAlignment(0);
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        Button right = new Button((Composite)major, 16);
        right.setText("Buttom/Right");
        right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorAlignment(2);
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        final Scale spacing = new Scale((Composite)major, 0);
        spacing.setMinimum(0);
        spacing.setMaximum(20);
        spacing.setSelection(5);
        spacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMajorSpacing(spacing.getSelection());
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        Label spacingLabel = new Label((Composite)major, 0x1000000);
        spacingLabel.setText("Spacing");
        Group minor = new Group(composite, 0);
        minor.setLayout((Layout)new FillLayout(512));
        minor.setText("minor axis");
        left = new Button((Composite)minor, 16);
        left.setText("Top/Left");
        left.setSelection(true);
        left.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorAlignment(1);
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        center = new Button((Composite)minor, 16);
        center.setText("Middle/Center");
        center.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorAlignment(0);
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        right = new Button((Composite)minor, 16);
        right.setText("Buttom/Right");
        right.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorAlignment(2);
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        spacing = new Scale((Composite)minor, 0);
        spacing.setMinimum(0);
        spacing.setMaximum(20);
        spacing.setSelection(5);
        spacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowLayoutExample.this.layout.setMinorSpacing(spacing.getSelection());
                FlowLayoutExample.this.getContents().revalidate();
            }
        });
        spacingLabel = new Label((Composite)minor, 0x1000000);
        spacingLabel.setText("Spacing");
    }

    private void resetShapes() {
        this.ellipse1.setSize(60, 40);
        this.rect1.setSize(30, 70);
        this.rect2.setSize(90, 30);
        this.rect3.setSize(50, 80);
        this.ellipse2.setSize(50, 50);
        this.triangle1.setSize(50, 50);
        this.rect4.setSize(50, 50);
        this.rect5.setSize(50, 70);
        this.triangle2.setSize(50, 50);
        this.ellipse3.setSize(50, 50);
        this.rect6.setSize(50, 50);
    }
}

