/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.serial.ui;

import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.serial.internal.ui.Activator;
import org.eclipse.remote.serial.ui.NewSerialPortConnectionWizardPage;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class NewSerialPortConnectionWizard
extends Wizard
implements IRemoteUIConnectionWizard {
    private NewSerialPortConnectionWizardPage page;
    private IRemoteConnectionWorkingCopy workingCopy;
    private Shell shell;
    private IRemoteConnectionType connectionType;

    public NewSerialPortConnectionWizard(Shell shell, IRemoteConnectionType connectionType) {
        this.shell = shell;
        this.connectionType = connectionType;
    }

    public void addPages() {
        this.page = new NewSerialPortConnectionWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        if (this.getConnection() == null) {
            return false;
        }
        this.workingCopy.setAttribute("serial.portName", this.page.getPortName());
        this.workingCopy.setAttribute("serial.baudRate", Integer.toString(this.page.getBaudRateIndex()));
        this.workingCopy.setAttribute("serial.byteSize", Integer.toString(this.page.getByteSizeIndex()));
        this.workingCopy.setAttribute("serial.parity", Integer.toString(this.page.getParityIndex()));
        this.workingCopy.setAttribute("serial.stopBits", Integer.toString(this.page.getStopBitsIndex()));
        return true;
    }

    public IRemoteConnectionWorkingCopy open() {
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)this);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return this.getConnection();
        }
        return null;
    }

    public IRemoteConnectionWorkingCopy getConnection() {
        if (this.workingCopy == null) {
            try {
                this.workingCopy = this.connectionType.newConnection(this.page.getConnectionName());
            }
            catch (RemoteConnectionException e) {
                Activator.log(e.getStatus());
            }
        }
        return this.workingCopy;
    }

    public void setConnection(IRemoteConnectionWorkingCopy connection) {
        this.workingCopy = connection;
    }

    public void setConnectionName(String name) {
    }

    public void setInvalidConnectionNames(Set<String> names) {
    }
}

