/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringRunner;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class TogglingActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private TextSelection selection;

    public void init(IWorkbenchWindow window) {
        this.window = window;
        assert (window != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean isTextSelection = selection != null && selection instanceof TextSelection;
        action.setEnabled(isTextSelection);
        if (!isTextSelection) {
            return;
        }
        this.selection = (TextSelection)CUIPlugin.getActivePage().getActiveEditor().getEditorSite().getSelectionProvider().getSelection();
    }

    public void run(IAction action) {
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (editor == null || editor.getEditorInput() == null) {
            return;
        }
        IWorkingCopy tu = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
        if (tu == null || tu.getResource() == null) {
            return;
        }
        new ToggleRefactoringRunner((ICElement)tu, (ITextSelection)this.selection, (IShellProvider)this.window, tu.getCProject()).run();
    }

    public void dispose() {
    }
}

