/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.core.internal.launching;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.llvm.dsf.lldb.core.internal.LLDBCorePlugin;
import org.eclipse.cdt.llvm.dsf.lldb.core.internal.LLDBTrait;
import org.eclipse.cdt.llvm.dsf.lldb.core.internal.launching.Messages;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

public class LLDBLaunch
extends GdbLaunch {
    private static final String XCODE_HINT = "(Xcode 7.3.1)";
    private static final IntegerTuple LLDB_MINIMUM_REVISION = new IntegerTuple(350, 0, 21, 9);
    private static final IntegerTuple LLDB_MINIMUM_VERSION = new IntegerTuple(3, 8, 0);
    private static final Pattern LLDB_VERSION_PATTERN = Pattern.compile("lldb\\s*version\\s*(\\d+)\\.(\\d+)\\.(\\d+).*", 32);
    private static final Pattern LLDB_REVISION_PATTERN = Pattern.compile("lldb-(\\d+)\\.(\\d+)\\.(\\d+)(\\.(\\d)+)?.*", 32);
    private Optional<IntegerTuple> fLldbVersion;
    private Optional<IntegerTuple> fLldbRevision;
    private Set<LLDBTrait> fTraits = new HashSet<LLDBTrait>();

    public LLDBLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
    }

    public IPath getGDBPath() {
        String lldbPath = this.getAttribute("org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME");
        if (lldbPath != null) {
            return new Path(lldbPath);
        }
        return LLDBLaunch.getLLDBPath(this.getLaunchConfiguration());
    }

    public void setGDBPath(String path) {
        this.setAttribute("org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME", path);
    }

    public static IPath getLLDBPath(ILaunchConfiguration configuration) {
        String defaultLLdbCommand = LLDBLaunch.getDefaultLLDBPath();
        Path retVal = new Path(defaultLLdbCommand);
        try {
            String lldbPath = configuration.getAttribute("org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME", defaultLLdbCommand);
            lldbPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(lldbPath, false);
            retVal = new Path(lldbPath);
        }
        catch (CoreException e) {
            LLDBCorePlugin.getDefault().getLog().log(e.getStatus());
        }
        return retVal;
    }

    protected String getDefaultGDBPath() {
        return LLDBLaunch.getDefaultLLDBPath();
    }

    public String getGDBVersion() throws CoreException {
        String gdbVersion = super.getGDBVersion();
        this.computeLLDBVersions();
        if (this.fLldbRevision.isPresent()) {
            if (this.fLldbRevision.get().compareTo(LLDB_MINIMUM_REVISION) < 0) {
                throw new DebugException(LLDBCorePlugin.createStatus(MessageFormat.format(Messages.LLDBLaunch_minimum_version_error, this.fLldbRevision.get(), LLDB_MINIMUM_REVISION, XCODE_HINT)));
            }
        } else if (this.fLldbVersion.isPresent() && this.fLldbVersion.get().compareTo(LLDB_MINIMUM_VERSION) < 0) {
            throw new DebugException(LLDBCorePlugin.createStatus(MessageFormat.format(Messages.LLDBLaunch_minimum_version_error, this.fLldbVersion.get(), LLDB_MINIMUM_VERSION, "")));
        }
        return gdbVersion;
    }

    private void computeLLDBVersions() throws CoreException {
        if (this.fLldbRevision != null || this.fLldbVersion != null) {
            return;
        }
        this.fLldbRevision = Optional.empty();
        this.fLldbVersion = Optional.empty();
        IPath lldbMiPath = this.getGDBPath();
        String lastSegment = lldbMiPath.lastSegment();
        if (lastSegment.contains("lldb-mi")) {
            lastSegment = lastSegment.replace("lldb-mi", "lldb");
        }
        boolean isLldbMiAbsolute = lldbMiPath.isAbsolute() && lldbMiPath.toFile().exists();
        lldbMiPath = lldbMiPath.removeLastSegments(1).append(lastSegment);
        if (isLldbMiAbsolute && !lldbMiPath.toFile().exists()) {
            return;
        }
        String cmd = String.valueOf(lldbMiPath) + " --version";
        String[] args = CommandLineUtil.argumentsToArray((String)cmd);
        Process process = null;
        Job timeoutJob = null;
        try {
            try {
                final Process finalProc = process = ProcessFactory.getFactory().exec(args, this.getLaunchEnvironment());
                timeoutJob = new Job("LLDB version timeout job"){
                    {
                        super($anonymous0);
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor arg) {
                        finalProc.destroy();
                        return Status.OK_STATUS;
                    }
                };
                timeoutJob.schedule(10000L);
                String streamOutput = LLDBLaunch.readStream(process.getInputStream());
                this.fLldbVersion = LLDBLaunch.getLLDBVersionFromText(streamOutput);
                this.fLldbRevision = LLDBLaunch.getLLDBRevisionFromText(streamOutput);
                if (this.fLldbVersion.isEmpty() && this.fLldbRevision.isEmpty() && !streamOutput.isEmpty()) {
                    Exception detailedException = new Exception("Unexpected output format: \n\n" + streamOutput);
                    throw new DebugException(LLDBCorePlugin.createStatus("Could not determine LLDB version using command: " + StringUtil.join((String[])args, (String)" "), detailedException));
                }
                this.computeTraits();
            }
            catch (IOException e) {
                LLDBCorePlugin.log((Throwable)new DebugException((IStatus)new Status(4, "org.eclipse.cdt.llvm.dsf.lldb.core", 5012, "Error with command: " + StringUtil.join((String[])args, (String)" "), (Throwable)e)));
                if (timeoutJob != null) {
                    timeoutJob.cancel();
                }
                if (process != null) {
                    process.destroy();
                }
            }
        }
        finally {
            if (timeoutJob != null) {
                timeoutJob.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    private void computeTraits() {
        if (this.fLldbVersion.isPresent() && this.fLldbVersion.get().compareTo(new IntegerTuple(4, 0, 0)) < 0 || this.fLldbRevision.isPresent() && this.fLldbRevision.get().compareTo(new IntegerTuple(370, 0, 37)) < 0) {
            this.fTraits.add(LLDBTrait.BROKEN_BREAKPOINT_INSERT_FULL_PATH_LLVM_BUG_28709);
        }
        if (this.fLldbVersion.isPresent() && this.fLldbVersion.get().compareTo(new IntegerTuple(8, 0, 0)) < 0 || this.fLldbRevision.isPresent()) {
            this.fTraits.add(LLDBTrait.MISSING_GDB_SET_BREAKPOINT_PENDING);
        }
    }

    private static String readStream(InputStream stream) throws IOException {
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            String line;
            InputStreamReader r = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                cmdOutput.append(line);
                cmdOutput.append('\n');
            }
            String string = cmdOutput.toString();
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Optional<IntegerTuple> getLLDBRevisionFromText(String versionOutput) {
        Matcher matcher = LLDB_REVISION_PATTERN.matcher(versionOutput);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        try {
            Integer major = Integer.valueOf(matcher.group(1));
            Integer minor = Integer.valueOf(matcher.group(2));
            Integer micro = Integer.valueOf(matcher.group(3));
            String patchGroup = matcher.group(5);
            if (patchGroup != null) {
                Integer patch = Integer.valueOf(patchGroup);
                return Optional.of(new IntegerTuple(major, minor, micro, patch));
            }
            return Optional.of(new IntegerTuple(major, minor, micro));
        }
        catch (NumberFormatException e) {
            LLDBCorePlugin.log(e);
            return Optional.empty();
        }
    }

    private static Optional<IntegerTuple> getLLDBVersionFromText(String versionOutput) {
        Matcher matcher = LLDB_VERSION_PATTERN.matcher(versionOutput);
        if (!matcher.find()) {
            return Optional.empty();
        }
        try {
            Integer major = Integer.valueOf(matcher.group(1));
            Integer minor = Integer.valueOf(matcher.group(2));
            Integer micro = Integer.valueOf(matcher.group(3));
            IntegerTuple version = new IntegerTuple(major, minor, micro);
            return Optional.of(version);
        }
        catch (NumberFormatException e) {
            LLDBCorePlugin.log(e);
            return Optional.empty();
        }
    }

    private static String getDefaultLLDBPath() {
        return Platform.getPreferencesService().getString("org.eclipse.cdt.llvm.dsf.lldb.core", "defaultLLDBCommand", "lldb-mi", null);
    }

    public String getGDBInitFile() throws CoreException {
        return null;
    }

    public boolean hasTrait(LLDBTrait trait) {
        return this.fTraits.contains((Object)trait);
    }

    private static class IntegerTuple
    implements Comparable<IntegerTuple> {
        private Integer[] fIntegers;

        private IntegerTuple(Integer ... integers) {
            this.fIntegers = integers;
        }

        @Override
        public int compareTo(IntegerTuple o) {
            int i = 0;
            while (i < this.fIntegers.length) {
                if (i >= o.fIntegers.length) {
                    return 1;
                }
                int compareTo = this.fIntegers[i].compareTo(o.fIntegers[i]);
                if (compareTo != 0) {
                    return compareTo;
                }
                ++i;
            }
            if (this.fIntegers.length < o.fIntegers.length) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.fIntegers.length) {
                sb.append(this.fIntegers[i]);
                if (i != this.fIntegers.length - 1) {
                    sb.append(".");
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

