/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;

public class NLSHint {
    private static final Pattern TEXT_BLOCK_START_PATTERN = Pattern.compile("^\"\"\"\\s*\r?\n");
    private String fAccessorName;
    private IPackageFragment fAccessorPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private NLSSubstitution[] fSubstitutions;

    public NLSHint(ICompilationUnit cu, CompilationUnit astRoot) {
        Assert.isNotNull((Object)cu);
        Assert.isNotNull((Object)astRoot);
        IPackageFragment cuPackage = (IPackageFragment)cu.getAncestor(4);
        this.fAccessorName = "Messages";
        this.fAccessorPackage = cuPackage;
        this.fResourceBundleName = "messages.properties";
        this.fResourceBundlePackage = cuPackage;
        IJavaProject project = cu.getJavaProject();
        NLSLine[] lines = NLSHint.createRawLines(cu);
        AccessorClassReference accessClassRef = NLSHint.findFirstAccessorReference(lines, astRoot);
        if (accessClassRef == null) {
            ArrayList<NLSLine> eclipseNLSLines = new ArrayList<NLSLine>();
            accessClassRef = this.createEclipseNLSLines(this.getDocument(cu), astRoot, eclipseNLSLines);
            if (!eclipseNLSLines.isEmpty()) {
                NLSLine[] rawLines = lines;
                int rawLinesLength = rawLines.length;
                int eclipseLinesLength = eclipseNLSLines.size();
                lines = new NLSLine[rawLinesLength + eclipseLinesLength];
                System.arraycopy(rawLines, 0, lines, 0, rawLinesLength);
                int i = 0;
                while (i < eclipseLinesLength) {
                    lines[i + rawLinesLength] = (NLSLine)eclipseNLSLines.get(i);
                    ++i;
                }
            }
        }
        Properties props = null;
        if (accessClassRef != null) {
            props = NLSHintHelper.getProperties(project, accessClassRef);
        }
        if (props == null) {
            props = new Properties();
        }
        this.fSubstitutions = this.createSubstitutions(lines, props, astRoot);
        if (accessClassRef != null) {
            this.fAccessorName = accessClassRef.getName();
            ITypeBinding accessorClassBinding = accessClassRef.getBinding();
            try {
                String fullBundleName;
                IPackageFragment accessorPack = NLSHintHelper.getPackageOfAccessorClass(project, accessorClassBinding);
                if (accessorPack != null) {
                    this.fAccessorPackage = accessorPack;
                }
                if ((fullBundleName = accessClassRef.getResourceBundleName()) != null) {
                    this.fResourceBundleName = Signature.getSimpleName((String)fullBundleName) + ".properties";
                    String packName = Signature.getQualifier((String)fullBundleName);
                    IPackageFragment pack = NLSHintHelper.getResourceBundlePackage(project, packName, this.fResourceBundleName);
                    if (pack != null) {
                        this.fResourceBundlePackage = pack;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private AccessorClassReference createEclipseNLSLines(final IDocument document, CompilationUnit astRoot, List<NLSLine> nlsLines) {
        final AccessorClassReference[] firstAccessor = new AccessorClassReference[1];
        final TreeMap lineToNLSLine = new TreeMap();
        astRoot.accept(new ASTVisitor(){
            private ICompilationUnit fCache_CU;
            private CompilationUnit fCache_AST;

            public boolean visit(QualifiedName node) {
                ITypeBinding superType;
                ITypeBinding type = node.getQualifier().resolveTypeBinding();
                if (type != null && (superType = type.getSuperclass()) != null && NLS.class.getName().equals(superType.getQualifiedName())) {
                    Integer line;
                    try {
                        line = document.getLineOfOffset(node.getStartPosition());
                    }
                    catch (BadLocationException e) {
                        return true;
                    }
                    NLSLine nlsLine = (NLSLine)lineToNLSLine.get(line);
                    if (nlsLine == null) {
                        nlsLine = new NLSLine(line);
                        lineToNLSLine.put(line, nlsLine);
                    }
                    SimpleName name = node.getName();
                    NLSElement element = new NLSElement(node.getName().getIdentifier(), name.getStartPosition(), name.getLength(), nlsLine.size() - 1, true);
                    nlsLine.add(element);
                    ICompilationUnit bundleCU = (ICompilationUnit)type.getJavaElement().getAncestor(5);
                    if (this.fCache_CU == null || !this.fCache_CU.equals(bundleCU) || this.fCache_AST == null) {
                        this.fCache_CU = bundleCU;
                        this.fCache_AST = this.fCache_CU != null ? SharedASTProviderCore.getAST((ITypeRoot)this.fCache_CU, SharedASTProviderCore.WAIT_YES, null) : null;
                    }
                    String bundleName = NLSHintHelper.getResourceBundleName(this.fCache_AST);
                    element.setAccessorClassReference(new AccessorClassReference(type, bundleName, new Region(node.getStartPosition(), node.getLength())));
                    if (firstAccessor[0] == null) {
                        firstAccessor[0] = element.getAccessorClassReference();
                    }
                }
                return true;
            }
        });
        nlsLines.addAll(lineToNLSLine.values());
        return firstAccessor[0];
    }

    private IDocument getDocument(ICompilationUnit cu) {
        IPath path = cu.getPath();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(path, LocationKind.NORMALIZE, null);
        }
        catch (CoreException e) {
            return null;
        }
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
            if (buffer != null) {
                IDocument iDocument = buffer.getDocument();
                return iDocument;
            }
        }
        finally {
            try {
                manager.disconnect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException e) {
                return null;
            }
        }
        return null;
    }

    private NLSSubstitution[] createSubstitutions(NLSLine[] lines, Properties props, CompilationUnit astRoot) {
        ArrayList<NLSSubstitution> result = new ArrayList<NLSSubstitution>();
        NLSLine[] nLSLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            NLSLine line = nLSLineArray[n2];
            NLSElement[] nLSElementArray = line.getElements();
            int n3 = nLSElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                NLSElement nlsElement = nLSElementArray[n4];
                if (nlsElement.hasTag()) {
                    AccessorClassReference accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement);
                    if (accessorClassReference == null) {
                        result.add(new NLSSubstitution(1, NLSHint.stripQuotes(nlsElement.getValue(), this.fAccessorPackage.getJavaProject()), nlsElement));
                    } else {
                        String key = NLSHint.stripQuotes(nlsElement.getValue(), this.fAccessorPackage.getJavaProject());
                        String value = props.getProperty(key);
                        result.add(new NLSSubstitution(0, key, value, nlsElement, accessorClassReference));
                    }
                } else if (nlsElement.isEclipseNLS()) {
                    String key = nlsElement.getValue();
                    result.add(new NLSSubstitution(0, key, props.getProperty(key), nlsElement, nlsElement.getAccessorClassReference()));
                } else {
                    result.add(new NLSSubstitution(2, NLSHint.stripQuotes(nlsElement.getValue(), this.fAccessorPackage.getJavaProject()), nlsElement));
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new NLSSubstitution[result.size()]);
    }

    private static AccessorClassReference findFirstAccessorReference(NLSLine[] lines, CompilationUnit astRoot) {
        AccessorClassReference accessorClassReference;
        NLSElement nlsElement;
        int n;
        int n2;
        NLSElement[] nLSElementArray;
        NLSLine line;
        NLSLine[] nLSLineArray = lines;
        int n3 = lines.length;
        int n4 = 0;
        while (n4 < n3) {
            line = nLSLineArray[n4];
            nLSElementArray = line.getElements();
            n2 = nLSElementArray.length;
            n = 0;
            while (n < n2) {
                nlsElement = nLSElementArray[n];
                if (nlsElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement)) != null) {
                    return accessorClassReference;
                }
                ++n;
            }
            ++n4;
        }
        nLSLineArray = lines;
        n3 = lines.length;
        n4 = 0;
        while (n4 < n3) {
            line = nLSLineArray[n4];
            nLSElementArray = line.getElements();
            n2 = nLSElementArray.length;
            n = 0;
            while (n < n2) {
                nlsElement = nLSElementArray[n];
                if (!nlsElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement)) != null) {
                    return accessorClassReference;
                }
                ++n;
            }
            ++n4;
        }
        return null;
    }

    public static String stripQuotes(String str, IJavaProject project) {
        if (str.endsWith("\"\"\"") && TEXT_BLOCK_START_PATTERN.matcher(str).find() && JavaModelUtil.is15OrHigher(project)) {
            return NLSHint.getTextBlock(str.substring(3, str.length() - 3));
        }
        return str.substring(1, str.length() - 1);
    }

    private static NLSLine[] createRawLines(ICompilationUnit cu) {
        try {
            return NLSScanner.scan(cu);
        }
        catch (JavaModelException | InvalidInputException | BadLocationException x) {
            return new NLSLine[0];
        }
    }

    public String getAccessorClassName() {
        return this.fAccessorName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }

    private static char[] normalize(char[] content) {
        StringBuilder result = new StringBuilder();
        boolean isCR = false;
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\r': {
                    result.append(c);
                    isCR = true;
                    break;
                }
                case '\n': {
                    if (!isCR) {
                        result.append(c);
                    }
                    isCR = false;
                    break;
                }
                default: {
                    result.append(c);
                    isCR = false;
                }
            }
            ++n2;
        }
        return result.toString().toCharArray();
    }

    private static String getTextBlock(String x) {
        char[] all = NLSHint.normalize(x.toCharArray());
        char[][] lines = CharOperation.splitOn((char)'\n', (char[])all);
        int size = lines.length;
        ArrayList<char[]> list = new ArrayList<char[]>(lines.length);
        int i = 1;
        while (i < lines.length) {
            char[] line = lines[i];
            if (i + 1 == size && line.length == 0) {
                list.add(line);
                break;
            }
            char[][] sub = CharOperation.splitOn((char)'\r', (char[])line);
            if (sub.length == 0) {
                list.add(line);
            } else {
                char[][] cArray = sub;
                int n = sub.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] cs = cArray[n2];
                    list.add(cs);
                    ++n2;
                }
            }
            ++i;
        }
        size = list.size();
        lines = (char[][])list.toArray((T[])new char[size][]);
        int prefix = -1;
        int i2 = 0;
        while (i2 < size) {
            char[] line = lines[i2];
            boolean blank = true;
            int whitespaces = 0;
            char[] cArray = line;
            int n = line.length;
            int n3 = 0;
            while (n3 < n) {
                char c = cArray[n3];
                if (blank) {
                    if (Character.isWhitespace(c)) {
                        ++whitespaces;
                    } else {
                        blank = false;
                    }
                }
                ++n3;
            }
            if (!(blank && i2 + 1 != size || prefix >= 0 && whitespaces >= prefix)) {
                prefix = whitespaces;
            }
            ++i2;
        }
        if (prefix == -1) {
            prefix = 0;
        }
        StringBuilder result = new StringBuilder();
        boolean newLine = false;
        int i3 = 0;
        while (i3 < lines.length) {
            int length;
            char[] l = lines[i3];
            int trail = length = l.length;
            while (trail > 0) {
                if (!Character.isWhitespace(l[trail - 1])) break;
                --trail;
            }
            if (i3 >= size - 1) {
                if (newLine) {
                    result.append('\n');
                }
                if (trail >= prefix) {
                    newLine = NLSHint.getLineContent(result, l, prefix, trail - 1, false, true);
                }
            } else {
                if (i3 > 0 && newLine) {
                    result.append('\n');
                }
                if (trail <= prefix) {
                    newLine = true;
                } else {
                    boolean merge = length > 0 && l[length - 1] == '\\';
                    newLine = NLSHint.getLineContent(result, l, prefix, trail - 1, merge, false);
                }
            }
            ++i3;
        }
        return result.toString();
    }

    private static boolean getLineContent(StringBuilder result, char[] line, int start, int end, boolean merge, boolean lastLine) {
        char[] chars;
        int lastPointer = 0;
        int i = start;
        block10: while (i < end) {
            char c = line[i];
            if (c != '\\') {
                ++i;
                continue;
            }
            if (i >= end) continue;
            if (lastPointer + 1 <= i) {
                result.append(CharOperation.subarray((char[])line, (int)(lastPointer == 0 ? start : lastPointer), (int)i));
            }
            char next = line[++i];
            switch (next) {
                case '\\': {
                    result.append('\\');
                    if (i != end) break;
                    merge = false;
                    break;
                }
                case 's': {
                    result.append(' ');
                    break;
                }
                case '\"': {
                    result.append('\"');
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                default: {
                    int pos = i + 1;
                    int number = NLSHint.getHexadecimalValue(next);
                    if (number >= 0 && number <= 7) {
                        boolean zeroToThreeNot = number > 3;
                        next = line[pos];
                        if (Character.isDigit(next)) {
                            ++pos;
                            int digit = NLSHint.getHexadecimalValue(next);
                            if (digit >= 0 && digit <= 7) {
                                number = number * 8 + digit;
                                next = line[pos];
                                if (Character.isDigit(next)) {
                                    ++pos;
                                    if (!zeroToThreeNot && (digit = NLSHint.getHexadecimalValue(next)) >= 0 && digit <= 7) {
                                        number = number * 8 + digit;
                                    }
                                }
                            }
                        }
                        if (number < 255) {
                            next = (char)number;
                        }
                        result.append(next);
                        lastPointer = i = pos;
                        continue block10;
                    }
                    result.append(c);
                    lastPointer = i;
                    continue block10;
                }
            }
            lastPointer = ++i;
        }
        end = merge ? end : (end >= line.length ? end : end + 1);
        char[] cArray = chars = lastPointer == 0 ? CharOperation.subarray((char[])line, (int)start, (int)end) : CharOperation.subarray((char[])line, (int)lastPointer, (int)end);
        if (chars != null && chars.length > 0) {
            result.append(chars);
        }
        return !merge && !lastLine;
    }

    private static int getHexadecimalValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }
}

