/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.jdt.ls.core.internal.BaseJDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.LanguageServerApplication;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.services.LanguageServer;

public final class ParentProcessWatcher
implements Runnable,
Function<MessageConsumer, MessageConsumer> {
    private static final long INACTIVITY_DELAY_SECS = 30000L;
    private static final int POLL_DELAY_SECS = 10;
    private volatile long lastActivityTime;
    private final LanguageServerApplication server;
    private ScheduledFuture<?> task;
    private ScheduledExecutorService service;

    public ParentProcessWatcher(LanguageServerApplication server) {
        this.server = server;
        if (ProcessHandle.current().parent().isPresent()) {
            this.server.setParentProcessId(ProcessHandle.current().parent().get().pid());
        }
        this.service = Executors.newScheduledThreadPool(1);
        this.task = this.service.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.parentProcessStillRunning()) {
            BaseJDTLanguageServer baseJDTLanguageServer;
            JavaLanguageServerPlugin.logInfo("Parent process stopped running, forcing server exit");
            this.task.cancel(true);
            if (JavaLanguageServerPlugin.getInstance() != null && (baseJDTLanguageServer = JavaLanguageServerPlugin.getInstance().getProtocol()) instanceof LanguageServer) {
                LanguageServer languageServer = (LanguageServer)baseJDTLanguageServer;
                languageServer.exit();
            } else {
                this.server.exit();
                Executors.newSingleThreadScheduledExecutor().schedule(() -> {
                    JavaLanguageServerPlugin.logInfo("Forcing exit after 1 min.");
                    System.exit(1);
                }, 1L, TimeUnit.MINUTES);
            }
        }
    }

    private boolean parentProcessStillRunning() {
        long pid = this.server.getParentProcessId();
        if (pid == 0L || this.lastActivityTime > System.currentTimeMillis() - 30000L) {
            return true;
        }
        Optional<ProcessHandle> processHandle = ProcessHandle.of(pid);
        return processHandle.isPresent() && processHandle.get().isAlive();
    }

    @Override
    public MessageConsumer apply(MessageConsumer consumer) {
        return message -> {
            this.lastActivityTime = System.currentTimeMillis();
            consumer.consume(message);
        };
    }
}

