/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.core.CompilationUnit;

public class DOMASTNodeUtils {
    public static IJavaElement getEnclosingJavaElement(ASTNode node) {
        ClassInstanceCreation newInst;
        if (node == null) {
            return null;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof MethodDeclaration || node instanceof FieldDeclaration || node instanceof Initializer || node instanceof ImportDeclaration || node instanceof PackageDeclaration || node instanceof org.eclipse.jdt.core.dom.CompilationUnit || node instanceof ModuleDeclaration || node instanceof AnnotationTypeMemberDeclaration || node instanceof Initializer || node instanceof LambdaExpression || node.getLocationInParent() == FieldDeclaration.FRAGMENTS_PROPERTY || node.getLocationInParent() == RecordDeclaration.RECORD_COMPONENTS_PROPERTY) {
            return DOMASTNodeUtils.getDeclaringJavaElement(node);
        }
        if (node instanceof ClassInstanceCreation && (newInst = (ClassInstanceCreation)node).getAnonymousClassDeclaration() != null) {
            return DOMASTNodeUtils.getDeclaringJavaElement((ASTNode)newInst.getAnonymousClassDeclaration());
        }
        return DOMASTNodeUtils.getEnclosingJavaElement(node.getParent());
    }

    public static boolean annotationBetweenNodeAndLocalElement(ASTNode node) {
        if (node == null) {
            return false;
        }
        boolean annotFound = false;
        for (ASTNode working = node; working != null; working = working.getParent()) {
            annotFound |= working instanceof Annotation;
            if (node instanceof VariableDeclaration) {
                return annotFound;
            }
            if (node instanceof VariableDeclarationStatement) {
                return annotFound;
            }
            if (node instanceof VariableDeclarationExpression) {
                return annotFound;
            }
            if (node instanceof TypeParameter) {
                TypeParameter typeParam = (TypeParameter)node;
                return annotFound;
            }
            if (!(node instanceof AbstractTypeDeclaration) && !(node instanceof MethodDeclaration) && !(node instanceof FieldDeclaration) && !(node instanceof Initializer) && !(node instanceof ImportDeclaration) && !(node instanceof PackageDeclaration) && !(node instanceof org.eclipse.jdt.core.dom.CompilationUnit) && !(node instanceof AnnotationTypeMemberDeclaration) && !(node instanceof Initializer) && !(node instanceof LambdaExpression) && node.getLocationInParent() != FieldDeclaration.FRAGMENTS_PROPERTY) continue;
            return annotFound;
        }
        return annotFound;
    }

    public static IJavaElement getLocalJavaElement(ASTNode node) {
        IJavaElement[] r = DOMASTNodeUtils.getLocalOrOtherJavaElements(node, true);
        return r != null && r.length > 0 && r[0] != null ? r[0] : null;
    }

    public static IJavaElement[] getLocalOrOtherJavaElements(ASTNode node, boolean local) {
        FieldDeclaration stmt;
        ASTNode aSTNode;
        ArrayList<IJavaElement> ret;
        VariableDeclaration variable;
        IVariableBinding vb;
        if (node == null) {
            return null;
        }
        if (node instanceof VariableDeclaration && (vb = (variable = (VariableDeclaration)node).resolveBinding()) != null) {
            return new IJavaElement[]{vb.getJavaElement()};
        }
        if (node instanceof VariableDeclarationStatement && !(variable = (VariableDeclarationStatement)node).fragments().isEmpty()) {
            if (local) {
                vb = ((VariableDeclarationFragment)variable.fragments().iterator().next()).resolveBinding();
                if (vb != null) {
                    return new IJavaElement[]{vb.getJavaElement()};
                }
            } else {
                ret = new ArrayList<IJavaElement>();
                List l1 = variable.fragments();
                boolean first = true;
                for (VariableDeclarationFragment v1 : l1) {
                    IJavaElement e;
                    if (first) {
                        first = false;
                        continue;
                    }
                    IVariableBinding vb2 = v1.resolveBinding();
                    if (vb2 == null || (e = vb2.getJavaElement()) == null) continue;
                    ret.add(e);
                }
                return ret.toArray(new IJavaElement[ret.size()]);
            }
        }
        if (node instanceof VariableDeclarationExpression && !(variable = (VariableDeclarationExpression)node).fragments().isEmpty()) {
            if (local) {
                vb = ((VariableDeclarationFragment)variable.fragments().iterator().next()).resolveBinding();
                if (vb != null) {
                    return new IJavaElement[]{vb.getJavaElement()};
                }
            } else {
                ret = new ArrayList();
                List l1 = variable.fragments();
                boolean first = true;
                for (VariableDeclarationFragment v1 : l1) {
                    IJavaElement e;
                    if (first) {
                        first = false;
                        continue;
                    }
                    IVariableBinding vb3 = v1.resolveBinding();
                    if (vb3 == null || (e = vb3.getJavaElement()) == null) continue;
                    ret.add(e);
                }
                return ret.toArray(new IJavaElement[ret.size()]);
            }
        }
        if (!local && (node.getLocationInParent() == FieldDeclaration.TYPE_PROPERTY || node.getLocationInParent() == FieldDeclaration.MODIFIERS_PROPERTY || node.getLocationInParent() == FieldDeclaration.MODIFIERS2_PROPERTY) && (aSTNode = node.getParent()) instanceof FieldDeclaration && (stmt = (FieldDeclaration)aSTNode).fragments().size() > 1) {
            return (IJavaElement[])stmt.fragments().stream().map(VariableDeclaration::resolveBinding).filter(x -> x != null).map(IBinding::getJavaElement).filter(x -> x != null).toArray(IJavaElement[]::new);
        }
        if (node instanceof TypeParameter) {
            TypeParameter typeParam = (TypeParameter)node;
            return new IJavaElement[]{typeParam.resolveBinding().getJavaElement()};
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof MethodDeclaration || node instanceof FieldDeclaration || node instanceof Initializer || node instanceof ImportDeclaration || node instanceof PackageDeclaration || node instanceof org.eclipse.jdt.core.dom.CompilationUnit || node instanceof AnnotationTypeMemberDeclaration || node instanceof Initializer || node instanceof LambdaExpression || node.getLocationInParent() == FieldDeclaration.FRAGMENTS_PROPERTY) {
            return new IJavaElement[]{DOMASTNodeUtils.getEnclosingJavaElement(node)};
        }
        return DOMASTNodeUtils.getLocalOrOtherJavaElements(node.getParent(), local);
    }

    public static IJavaElement getDeclaringJavaElement(ASTNode key) {
        if (key instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            org.eclipse.jdt.core.dom.CompilationUnit unit = (org.eclipse.jdt.core.dom.CompilationUnit)key;
            return unit.getJavaElement();
        }
        IJavaElement je = DOMASTNodeUtils.findElementForNodeViaDirectBinding(key);
        if (je != null) {
            return je;
        }
        IJavaElement je2 = DOMASTNodeUtils.findElementForNodeCustom(key);
        return je2;
    }

    private static IJavaElement findElementForNodeCustom(ASTNode key) {
        PackageDeclaration pack;
        ASTNode unit;
        ImportDeclaration id;
        IJavaElement parentEl;
        ASTNode parentNode;
        VariableDeclarationFragment vdf;
        FieldDeclaration fd;
        List fragments;
        if (key instanceof FieldDeclaration && (fragments = (fd = (FieldDeclaration)key).fragments()).size() > 0 && (vdf = (VariableDeclarationFragment)fragments.get(0)) != null) {
            IJavaElement ret = DOMASTNodeUtils.findElementForNodeViaDirectBinding((ASTNode)vdf);
            return ret;
        }
        if (key instanceof Initializer) {
            Initializer i = (Initializer)key;
            parentNode = i.getParent();
            int domOccurance = -1;
            if (parentNode instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)parentNode;
                domOccurance = typeDecl.bodyDeclarations().stream().filter(Initializer.class::isInstance).toList().indexOf(key) + 1;
            }
            if ((parentEl = DOMASTNodeUtils.findElementForNodeViaDirectBinding(parentNode)) instanceof IParent) {
                IParent parentElement = (IParent)parentEl;
                try {
                    for (IJavaElement child : parentElement.getChildren()) {
                        IInitializer init;
                        int count;
                        if (!(child instanceof IInitializer) || (count = (init = (IInitializer)child).getOccurrenceCount()) != domOccurance) continue;
                        return init;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        if (key instanceof ImportDeclaration && (parentNode = (id = (ImportDeclaration)key).getParent()) instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            unit = (org.eclipse.jdt.core.dom.CompilationUnit)parentNode;
            parentEl = unit.getJavaElement();
            return ((CompilationUnit)parentEl).getImport(id.getName().toString());
        }
        if (key instanceof PackageDeclaration && (unit = (pack = (PackageDeclaration)key).getParent()) instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            org.eclipse.jdt.core.dom.CompilationUnit unit2 = (org.eclipse.jdt.core.dom.CompilationUnit)unit;
            IJavaElement parentEl2 = unit2.getJavaElement();
            return ((CompilationUnit)parentEl2).getPackageDeclaration(pack.getName().getFullyQualifiedName());
        }
        return null;
    }

    private static IJavaElement findElementForNodeViaDirectBinding(ASTNode key) {
        IBinding b;
        if (key != null && (b = DOMASTNodeUtils.getBinding(key)) != null) {
            IJavaElement el = b.getJavaElement();
            return el;
        }
        return null;
    }

    public static IBinding getBinding(ASTNode astNode) {
        ClassInstanceCreation ref;
        MethodRef methodRef;
        SuperMethodReference superRef;
        FieldDeclaration field;
        if (astNode instanceof Name) {
            Name name = (Name)astNode;
            return name.resolveBinding();
        }
        if (astNode instanceof VariableDeclaration) {
            VariableDeclaration variable = (VariableDeclaration)astNode;
            return variable.resolveBinding();
        }
        if (astNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)astNode;
            return enumConstantDeclaration.resolveVariable();
        }
        if (astNode instanceof FieldAccess) {
            FieldAccess fieldAcces = (FieldAccess)astNode;
            return fieldAcces.resolveFieldBinding();
        }
        if (astNode instanceof MethodInvocation) {
            MethodInvocation method = (MethodInvocation)astNode;
            return method.resolveMethodBinding();
        }
        if (astNode instanceof Type) {
            Type type = (Type)astNode;
            return type.resolveBinding();
        }
        if (astNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)astNode;
            return type.resolveBinding();
        }
        if (astNode instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)astNode;
            return method.resolveBinding();
        }
        if (astNode instanceof FieldDeclaration && !(field = (FieldDeclaration)astNode).fragments().isEmpty()) {
            return ((VariableDeclarationFragment)field.fragments().get(0)).resolveBinding();
        }
        if (astNode instanceof SuperFieldAccess) {
            SuperFieldAccess superField = (SuperFieldAccess)astNode;
            return superField.resolveFieldBinding();
        }
        if (astNode instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethod = (SuperMethodInvocation)astNode;
            return superMethod.resolveMethodBinding();
        }
        if (astNode instanceof SuperMethodReference) {
            superRef = (SuperMethodReference)astNode;
            return superRef.resolveMethodBinding();
        }
        if (astNode instanceof ConstructorInvocation) {
            superRef = (ConstructorInvocation)astNode;
            return superRef.resolveConstructorBinding();
        }
        if (astNode instanceof SuperConstructorInvocation) {
            superRef = (SuperConstructorInvocation)astNode;
            return superRef.resolveConstructorBinding();
        }
        if (astNode instanceof MethodRef) {
            methodRef = (MethodRef)astNode;
            return methodRef.resolveBinding();
        }
        if (astNode instanceof MethodReference) {
            methodRef = (MethodReference)astNode;
            return methodRef.resolveMethodBinding();
        }
        if (astNode instanceof AnnotationTypeMemberDeclaration) {
            methodRef = (AnnotationTypeMemberDeclaration)astNode;
            return methodRef.resolveBinding();
        }
        if (astNode instanceof ClassInstanceCreation) {
            ref = (ClassInstanceCreation)astNode;
            return ref.resolveConstructorBinding();
        }
        if (astNode instanceof TypeParameter) {
            ref = (TypeParameter)astNode;
            return ref.resolveBinding();
        }
        if (astNode instanceof MemberValuePair) {
            ref = (MemberValuePair)astNode;
            return ref.resolveMemberValuePairBinding();
        }
        if (astNode instanceof ModuleDeclaration) {
            ref = (ModuleDeclaration)astNode;
            return ref.resolveBinding();
        }
        if (astNode instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)astNode;
            return lambda.resolveMethodBinding();
        }
        if (astNode instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration anon = (AnonymousClassDeclaration)astNode;
            return anon.resolveBinding();
        }
        return null;
    }

    public static boolean insideDocComment(ASTNode node) {
        org.eclipse.jdt.core.dom.CompilationUnit unit;
        ASTNode aSTNode = node.getRoot();
        return aSTNode instanceof org.eclipse.jdt.core.dom.CompilationUnit && (unit = (org.eclipse.jdt.core.dom.CompilationUnit)aSTNode).getCommentList().stream().anyMatch(comment -> comment.getStartPosition() <= node.getStartPosition() && comment.getStartPosition() + comment.getLength() >= node.getStartPosition() + node.getLength());
    }

    public static boolean isWithinRange(ASTNode node, IJavaElement el) {
        if (el instanceof ISourceReference) {
            ISourceReference isr = (ISourceReference)el;
            try {
                ISourceRange r = isr.getSourceRange();
                if (r != null) {
                    int astStart = node.getStartPosition();
                    int astLen = node.getLength();
                    int rangeStart = r.getOffset();
                    int rangeLen = r.getLength();
                    return astStart >= rangeStart && astStart + astLen <= rangeStart + rangeLen;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }
}

