/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.searcher;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.searcher.BaseFrameworkSearcher;
import com.microsoft.java.test.plugin.util.TestFrameworkUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.junit.launcher.JUnit5TestFinder;

public class JUnit5TestSearcher
extends BaseFrameworkSearcher {
    private static final JUnit5TestFinder JUNIT5_TEST_FINDER = new JUnit5TestFinder();
    public static final String JUPITER_NESTED = "org.junit.jupiter.api.Nested";
    public static final String JUNIT_PLATFORM_TESTABLE = "org.junit.platform.commons.annotation.Testable";
    protected static final String DISPLAY_NAME_ANNOTATION_JUNIT5 = "org.junit.jupiter.api.DisplayName";

    public JUnit5TestSearcher() {
        this.testMethodAnnotations = new String[]{JUNIT_PLATFORM_TESTABLE};
    }

    @Override
    public TestKind getTestKind() {
        return TestKind.JUnit5;
    }

    @Override
    public String getJdtTestKind() {
        return "org.eclipse.jdt.junit.loader.junit5";
    }

    @Override
    public boolean isTestMethod(IMethodBinding methodBinding) {
        int modifiers = methodBinding.getModifiers();
        if (Modifier.isAbstract((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isPrivate((int)modifiers)) {
            return false;
        }
        if (methodBinding.isConstructor()) {
            return false;
        }
        return this.findAnnotation(methodBinding.getAnnotations(), this.getTestMethodAnnotations());
    }

    @Override
    public boolean findAnnotation(IAnnotationBinding[] annotations, String[] annotationNames) {
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if (annotation != null) {
                String[] stringArray = annotationNames;
                int n3 = annotationNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    HashSet<ITypeBinding> hierarchy;
                    String annotationName = stringArray[n4];
                    if (this.matchesName(annotation.getAnnotationType(), annotationName)) {
                        return true;
                    }
                    if ((JUPITER_NESTED.equals(annotationName) || JUNIT_PLATFORM_TESTABLE.equals(annotationName)) && this.matchesNameInAnnotationHierarchy(annotation, annotationName, hierarchy = new HashSet<ITypeBinding>())) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isTestClass(IType type) throws JavaModelException {
        return JUNIT5_TEST_FINDER.isTest(type);
    }

    private boolean matchesName(ITypeBinding annotationType, String annotationName) {
        return TestFrameworkUtils.isEquivalentAnnotationType(annotationType, annotationName);
    }

    private boolean matchesNameInAnnotationHierarchy(IAnnotationBinding annotation, String annotationName, Set<ITypeBinding> hierarchy) {
        ITypeBinding type = annotation.getAnnotationType();
        if (type == null) {
            return false;
        }
        IAnnotationBinding[] iAnnotationBindingArray = type.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding annotationType;
            IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
            if (annotationBinding != null && (annotationType = annotationBinding.getAnnotationType()) != null && hierarchy.add(annotationType) && (this.matchesName(annotationType, annotationName) || this.matchesNameInAnnotationHierarchy(annotationBinding, annotationName, hierarchy))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Set<IType> findTestItemsInContainer(IJavaElement element, IProgressMonitor monitor) throws CoreException {
        HashSet<IType> types = new HashSet<IType>();
        try {
            JUNIT5_TEST_FINDER.findTestsInContainer(element, types, monitor);
        }
        catch (OperationCanceledException e) {
            return Collections.emptySet();
        }
        return types;
    }
}

