/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import com.vladsch.flexmark.ext.emoji.Emoji;
import com.vladsch.flexmark.ext.emoji.internal.EmojiOptions;
import com.vladsch.flexmark.ext.emoji.internal.EmojiResolvedShortcut;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EmojiNodeRenderer
implements NodeRenderer {
    final EmojiOptions myOptions;

    public EmojiNodeRenderer(DataHolder options) {
        this.myOptions = new EmojiOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(Emoji.class, this::render));
        return set;
    }

    private void render(Emoji node, NodeRendererContext context, HtmlWriter html) {
        EmojiResolvedShortcut shortcut = EmojiResolvedShortcut.getEmojiText(node, this.myOptions.useShortcutType, this.myOptions.useImageType, this.myOptions.rootImagePath, this.myOptions.useUnicodeFileNames);
        if (shortcut.emoji == null || shortcut.emojiText == null) {
            html.text((CharSequence)":");
            context.renderChildren((Node)node);
            html.text((CharSequence)":");
        } else if (shortcut.isUnicode) {
            html.text((CharSequence)shortcut.emojiText);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, (CharSequence)shortcut.emojiText, null);
            html.attr((CharSequence)"src", (CharSequence)resolvedLink.getUrl());
            html.attr((CharSequence)"alt", (CharSequence)shortcut.alt);
            if (!this.myOptions.attrImageSize.isEmpty()) {
                ((HtmlWriter)html.attr((CharSequence)"height", (CharSequence)this.myOptions.attrImageSize)).attr((CharSequence)"width", (CharSequence)this.myOptions.attrImageSize);
            }
            if (!this.myOptions.attrAlign.isEmpty()) {
                html.attr((CharSequence)"align", (CharSequence)this.myOptions.attrAlign);
            }
            if (!this.myOptions.attrImageClass.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)this.myOptions.attrImageClass);
            }
            html.withAttr(resolvedLink);
            html.tagVoid((CharSequence)"img");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new EmojiNodeRenderer(options);
        }
    }
}

