/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public final class VarDefinitionsUsesVisitor
extends ASTVisitor {
    private final IVariableBinding variableBinding;
    private final ASTNode scopeNode;
    private final boolean includeInnerScopes;
    private final List<SimpleName> writes = new ArrayList<SimpleName>();
    private final List<SimpleName> reads = new ArrayList<SimpleName>();

    public VarDefinitionsUsesVisitor(VariableDeclaration variableDeclaration) {
        this(variableDeclaration.resolveBinding(), VarDefinitionsUsesVisitor.getDeclaringScope(variableDeclaration), true);
    }

    public VarDefinitionsUsesVisitor(IVariableBinding variableBinding, ASTNode scopeNode, boolean includeInnerScopes) {
        if (variableBinding == null || scopeNode == null) {
            throw new IllegalArgumentException("Variable binding and scope node should be provided");
        }
        this.variableBinding = variableBinding;
        this.scopeNode = scopeNode;
        this.includeInnerScopes = includeInnerScopes;
        scopeNode.accept((ASTVisitor)this);
    }

    private static ASTNode getDeclaringScope(VariableDeclaration variableDeclaration) {
        ASTNode node = variableDeclaration.getParent();
        while (VarDefinitionsUsesVisitor.isVariableDeclaration(node)) {
            node = node.getParent();
        }
        return node;
    }

    private static boolean isVariableDeclaration(ASTNode node) {
        switch (node.getNodeType()) {
            case 44: 
            case 58: 
            case 59: 
            case 60: {
                return true;
            }
        }
        return false;
    }

    public boolean visit(SimpleName node) {
        if (ASTNodes.isSameLocalVariable((IBinding)this.variableBinding, (Expression)node)) {
            switch (node.getParent().getNodeType()) {
                case 7: {
                    this.addWriteOrRead(node, Assignment.LEFT_HAND_SIDE_PROPERTY);
                    if (node.getLocationInParent() != Assignment.LEFT_HAND_SIDE_PROPERTY || ASTNodes.hasOperator((Assignment)node.getParent(), Assignment.Operator.ASSIGN, new Assignment.Operator[0])) break;
                    this.reads.add(node);
                    break;
                }
                case 59: {
                    this.addWriteOrRead(node, VariableDeclarationFragment.NAME_PROPERTY);
                    break;
                }
                case 44: {
                    this.addWriteOrRead(node, SingleVariableDeclaration.NAME_PROPERTY);
                    break;
                }
                default: {
                    this.reads.add(node);
                }
            }
        }
        return true;
    }

    public boolean visit(Block node) {
        return this.scopeNode == node || this.includeInnerScopes;
    }

    private void addWriteOrRead(SimpleName node, ChildPropertyDescriptor definitionPropertyDescriptor) {
        if (node.getLocationInParent() == definitionPropertyDescriptor) {
            this.writes.add(node);
        } else {
            this.reads.add(node);
        }
    }

    public List<SimpleName> getWrites() {
        return this.writes;
    }

    public List<SimpleName> getReads() {
        return this.reads;
    }
}

