/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.BuildTarget;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import com.microsoft.gradle.bs.importer.EclipseVmUtil;
import com.microsoft.gradle.bs.importer.GradleBuildServerBuildSupport;
import com.microsoft.gradle.bs.importer.ImporterPlugin;
import com.microsoft.gradle.bs.importer.Utils;
import com.microsoft.gradle.bs.importer.model.BuildServerPreferences;
import com.microsoft.gradle.bs.importer.model.Telemetry;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.AbstractProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.managers.BasicFileDetector;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class GradleBuildServerProjectImporter
extends AbstractProjectImporter {
    private static final String CLIENT_NAME = "jdtls";
    private static final String BSP_VERSION = "2.1.0-M4";
    private static final String SCHEMA_VERSION_KEY = "bspSchemaVersion";
    private static final String SCHEMA_VERSION = "0.1.0";
    public static final String BUILD_GRADLE_DESCRIPTOR = "build.gradle";
    public static final String BUILD_GRADLE_KTS_DESCRIPTOR = "build.gradle.kts";
    public static final String SETTINGS_GRADLE_DESCRIPTOR = "settings.gradle";
    public static final String SETTINGS_GRADLE_KTS_DESCRIPTOR = "settings.gradle.kts";
    public static final String ANDROID_MANIFEST = "AndroidManifest.xml";

    public boolean applies(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (this.rootFolder == null) {
            return false;
        }
        if (!Utils.isBuildServerEnabled(GradleBuildServerProjectImporter.getPreferences())) {
            return false;
        }
        for (IProject project : ProjectUtils.getGradleProjects()) {
            if (!ProjectUtils.isJavaProject((IProject)project) || !project.getLocation().toFile().toPath().startsWith(this.rootFolder.toPath())) continue;
            Telemetry telemetry = new Telemetry("hasBuildshipJavaProject", "true");
            Utils.sendTelemetry(JavaLanguageServerPlugin.getProjectsManager().getConnection(), telemetry);
            return false;
        }
        if (this.directories == null) {
            BasicFileDetector gradleDetector = new BasicFileDetector(this.rootFolder.toPath(), new String[]{BUILD_GRADLE_DESCRIPTOR, SETTINGS_GRADLE_DESCRIPTOR, BUILD_GRADLE_KTS_DESCRIPTOR, SETTINGS_GRADLE_KTS_DESCRIPTOR}).includeNested(false).addExclusions(new String[]{"**/build"}).addExclusions(new String[]{"**/bin"});
            this.directories = gradleDetector.scan(monitor);
        }
        if (this.directories.isEmpty()) {
            return false;
        }
        for (java.nio.file.Path directory : this.directories) {
            BasicFileDetector androidDetector = new BasicFileDetector(directory, new String[]{ANDROID_MANIFEST}).includeNested(false).addExclusions(new String[]{"**/build"}).addExclusions(new String[]{"**/bin"});
            Collection androidDirectories = androidDetector.scan(monitor);
            if (androidDirectories.isEmpty()) continue;
            Telemetry telemetry = new Telemetry("hasAndroidManifest", "true");
            Utils.sendTelemetry(JavaLanguageServerPlugin.getProjectsManager().getConnection(), telemetry);
            return false;
        }
        Telemetry telemetry = new Telemetry("hasAndroidManifest", "false");
        Utils.sendTelemetry(JavaLanguageServerPlugin.getProjectsManager().getConnection(), telemetry);
        return true;
    }

    public boolean applies(Collection<IPath> projectConfigurations, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        return false;
    }

    public void importToWorkspace(IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        IPath rootPath = ResourceUtils.filePathFromURI((String)this.rootFolder.toURI().toString());
        BuildServerConnection buildServer = ImporterPlugin.getBuildServerConnection(rootPath, true);
        java.nio.file.Path inferredRoot = this.directories.stream().filter(directory -> directory.startsWith(this.rootFolder.toPath())).sorted((p1, p2) -> p1.getNameCount() - p2.getNameCount()).findFirst().orElse(this.rootFolder.toPath());
        InitializeBuildParams params = new InitializeBuildParams(CLIENT_NAME, ImporterPlugin.getBundleVersion(), BSP_VERSION, inferredRoot.toUri().toString(), new BuildClientCapabilities(Collections.singletonList("java")));
        BuildServerPreferences data = this.getBuildServerPreferences();
        params.setData((Object)data);
        InitializeBuildResult cfr_ignored_0 = (InitializeBuildResult)buildServer.buildInitialize(params).join();
        buildServer.onBuildInitialized();
        if (monitor.isCanceled()) {
            return;
        }
        List<IProject> projects = this.importProjects(buildServer, monitor);
        if (projects.isEmpty()) {
            return;
        }
        GradleBuildServerBuildSupport buildSupport = new GradleBuildServerBuildSupport();
        for (IProject project : projects) {
            buildSupport.updateClasspath(buildServer, project, monitor);
        }
        for (IProject project : projects) {
            buildSupport.updateProjectDependencies(buildServer, project, monitor);
        }
        for (IProject project : projects) {
            GradleBuildServerProjectImporter.updateConfigurationDigest(project);
        }
    }

    public boolean isResolved(File folder) throws OperationCanceledException, CoreException {
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (Utils.isGradleBuildServerProject(project) && project.getLocation().toPath().startsWith(folder.toPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void reset() {
    }

    public static boolean updateConfigurationDigest(IProject project) {
        DigestStore digestStore = ImporterPlugin.getDigestStore();
        boolean result = false;
        try {
            File buildFile = project.getFile(BUILD_GRADLE_DESCRIPTOR).getLocation().toFile();
            result = buildFile.exists() && digestStore.updateDigest(buildFile.toPath()) || result;
            File settingsFile = project.getFile(SETTINGS_GRADLE_DESCRIPTOR).getLocation().toFile();
            result = settingsFile.exists() && digestStore.updateDigest(settingsFile.toPath()) || result;
            File buildKtsFile = project.getFile(BUILD_GRADLE_KTS_DESCRIPTOR).getLocation().toFile();
            result = buildKtsFile.exists() && digestStore.updateDigest(buildKtsFile.toPath()) || result;
            File settingsKtsFile = project.getFile(SETTINGS_GRADLE_KTS_DESCRIPTOR).getLocation().toFile();
            result = settingsKtsFile.exists() && digestStore.updateDigest(settingsKtsFile.toPath()) || result;
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException((String)"Failed to update digest for Gradle configuration file", (Throwable)e);
        }
        return result;
    }

    private boolean importedByOtherImporters(Collection<java.nio.file.Path> directories) {
        return directories.stream().map(directory -> ProjectUtils.getProjectFromUri((String)directory.toUri().toString())).anyMatch(project -> !Utils.isGradleBuildServerProject(project) && ProjectUtils.isJavaProject((IProject)project));
    }

    private List<IProject> importProjects(BuildServerConnection buildServer, IProgressMonitor monitor) throws CoreException {
        Map<URI, List<BuildTarget>> buildTargetMap = Utils.getBuildTargetsMappedByProjectPath(buildServer);
        LinkedList<IProject> projects = new LinkedList<IProject>();
        for (Map.Entry<URI, List<BuildTarget>> entrySet : buildTargetMap.entrySet()) {
            URI uri = entrySet.getKey();
            IProject project = ProjectUtils.getProjectFromUri((String)uri.toString());
            if (project == null) {
                project = this.createProject(new File(uri), monitor);
            } else {
                if (!project.isAccessible() || !Utils.isGradleBuildServerProject(project)) continue;
                this.updateProjectDescription(project, monitor);
            }
            project.refreshLocal(2, monitor);
            projects.add(project);
        }
        return projects;
    }

    private IProject createProject(File directory, IProgressMonitor monitor) throws CoreException {
        String projectName = this.findFreeProjectName(directory.getName());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        if (projectDescription instanceof ProjectDescription var6_7) {
            VariableDescription variableDescription = new VariableDescription(SCHEMA_VERSION_KEY, SCHEMA_VERSION);
            description.setVariableDescription(SCHEMA_VERSION_KEY, variableDescription);
        }
        projectDescription.setLocation(Path.fromOSString((String)directory.getPath()));
        projectDescription.setNatureIds(new String[]{"com.microsoft.gradle.bs.importer.GradleBuildServerProjectNature"});
        ICommand buildSpec = Utils.getBuildServerBuildSpec(projectDescription);
        ICommand problemReporter = projectDescription.newCommand();
        problemReporter.setBuilderName("java.bs.JavaProblemChecker");
        projectDescription.setBuildSpec(new ICommand[]{problemReporter, buildSpec});
        IProject project = workspace.getRoot().getProject(projectName);
        project.create(projectDescription, monitor);
        project.open(0, monitor);
        return project;
    }

    private void updateProjectDescription(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IProjectDescription projectDescription = project.getDescription();
        Utils.removeBuildshipConfigurations(projectDescription);
        ICommand problemReporter = projectDescription.newCommand();
        problemReporter.setBuilderName("java.bs.JavaProblemChecker");
        Utils.addBuildSpec(projectDescription, new ICommand[]{Utils.getBuildServerBuildSpec(projectDescription), problemReporter});
        project.setDescription(projectDescription, 64, (IProgressMonitor)progress.newChild(1));
        if (project instanceof Project var6_7) {
            ProjectDescription description = internalProject.internalGetDescription();
            if (description == null) {
                return;
            }
            VariableDescription variableDescription = new VariableDescription(SCHEMA_VERSION_KEY, SCHEMA_VERSION);
            boolean changed = description.setVariableDescription(SCHEMA_VERSION_KEY, variableDescription);
            if (changed) {
                internalProject.writeDescription(0);
            }
        }
    }

    private String findFreeProjectName(String baseName) {
        IProject project = Arrays.stream(ProjectUtils.getAllProjects()).filter(p -> p.getName().equals(baseName)).findFirst().orElse(null);
        return project != null ? this.findFreeProjectName(String.valueOf(baseName) + "_") : baseName;
    }

    private BuildServerPreferences getBuildServerPreferences() {
        BuildServerPreferences pref = new BuildServerPreferences();
        Preferences jdtlsPreferences = GradleBuildServerProjectImporter.getPreferences();
        pref.setWrapperEnabled(jdtlsPreferences.isGradleWrapperEnabled());
        pref.setGradleArguments(jdtlsPreferences.getGradleArguments());
        pref.setGradleHome(jdtlsPreferences.getGradleHome());
        pref.setGradleJavaHome(jdtlsPreferences.getGradleJavaHome());
        pref.setGradleJvmArguments(jdtlsPreferences.getGradleJvmArguments());
        pref.setGradleUserHome(jdtlsPreferences.getGradleUserHome());
        pref.setGradleVersion(jdtlsPreferences.getGradleVersion());
        pref.setJdks(EclipseVmUtil.getAllVmInstalls());
        return pref;
    }
}

