/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.ConstructorLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;

public class DOMConstructorLocator
extends DOMPatternLocator {
    private ConstructorLocator locator;

    public DOMConstructorLocator(ConstructorLocator cl) {
        super((SearchPattern)cl.pattern);
        this.locator = cl;
    }

    @Override
    public int match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!node.isConstructor()) {
            return 0;
        }
        if (this.locator.pattern.fineGrain != 0 && !this.locator.pattern.findDeclarations) {
            return 0;
        }
        int referencesLevel = 0;
        int declarationsLevel = this.locator.pattern.findDeclarations ? this.matchLevelForDeclarations(node) : 0;
        return nodeSet.addMatch((ASTNode)node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    @Override
    public int match(Expression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!this.locator.pattern.findReferences) {
            return 0;
        }
        if (node instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)node;
            if (this.locator.pattern.declaringSimpleName == null || this.matchesTypeReference(this.locator.pattern.declaringSimpleName, creationRef.getType())) {
                return this.locator.pattern.mustResolve ? 2 : 1;
            }
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation newInstance = (ClassInstanceCreation)node;
            return (this.locator.pattern.declaringSimpleName == null || this.matchesTypeReference(this.locator.pattern.declaringSimpleName, newInstance.getType())) && this.matchParametersCount((ASTNode)node, newInstance.arguments()) ? 2 : 0;
        }
        return 0;
    }

    @Override
    public int match(ASTNode node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!this.locator.pattern.findReferences) {
            return 0;
        }
        if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superRef = (SuperConstructorInvocation)node;
            if (!this.matchParametersCount(node, superRef.arguments())) {
                return 0;
            }
            if (this.locator.pattern.declaringSimpleName != null) {
                ASTNode current;
                Type superType = null;
                for (current = superRef.getParent(); current != null && !(current instanceof AbstractTypeDeclaration) && !(current instanceof CreationReference); current = current.getParent()) {
                }
                if (current instanceof TypeDeclaration) {
                    TypeDeclaration typeDecl = (TypeDeclaration)current;
                    superType = typeDecl.getSuperclassType();
                }
                if (current instanceof CreationReference) {
                    CreationReference newInstance = (CreationReference)current;
                    superType = newInstance.getType();
                }
                if (!this.matchesTypeReference(this.locator.pattern.declaringSimpleName, superType)) {
                    return 0;
                }
            }
            return this.locator.pattern.mustResolve ? 2 : 1;
        }
        if (node instanceof EnumConstantDeclaration) {
            EnumDeclaration enumDeclaration;
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)node;
            ASTNode aSTNode = node.getParent();
            if (aSTNode instanceof EnumDeclaration && this.locator.matchesName(this.locator.pattern.declaringSimpleName, (enumDeclaration = (EnumDeclaration)aSTNode).getName().getIdentifier().toCharArray()) && this.matchParametersCount((ASTNode)enumConstantDecl, enumConstantDecl.arguments())) {
                return nodeSet.addMatch(node, this.locator.pattern.mustResolve ? 2 : 3);
            }
        }
        return 0;
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding instanceof IMethodBinding) {
            IMethodBinding constructor = (IMethodBinding)binding;
            int level = this.matchConstructor(constructor);
            if (level == 0 && constructor != constructor.getMethodDeclaration()) {
                level = this.matchConstructor(constructor.getMethodDeclaration());
            }
            return level;
        }
        return 0;
    }

    boolean matchParametersCount(ASTNode node, List<Expression> args) {
        if (this.locator.pattern.parameterSimpleNames != null && (!this.locator.pattern.varargs || DOMASTNodeUtils.insideDocComment(node))) {
            int argsLength;
            int length = this.locator.pattern.parameterCount;
            if (length < 0) {
                length = this.locator.pattern.parameterSimpleNames.length;
            }
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return false;
            }
        }
        return true;
    }

    protected int matchLevelForDeclarations(ConstructorDeclaration constructor) {
        if (this.locator.pattern.declaringSimpleName != null && !this.locator.matchesName(this.locator.pattern.declaringSimpleName, constructor.selector)) {
            return 0;
        }
        if (this.locator.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            Argument[] args = constructor.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        if (this.locator.pattern.hasConstructorArguments() && (constructor.typeParameters == null || constructor.typeParameters.length != this.locator.pattern.constructorArguments.length)) {
            return 0;
        }
        return this.locator.pattern.mustResolve ? 2 : 3;
    }

    protected int matchConstructor(IMethodBinding constructor) {
        if (!constructor.isConstructor()) {
            return 0;
        }
        int level = this.resolveLevelForType(this.locator.pattern.declaringSimpleName, this.locator.pattern.declaringQualification, constructor.getDeclaringClass());
        if (level == 0) {
            return 0;
        }
        int parameterCount = this.locator.pattern.parameterCount;
        if (parameterCount > -1) {
            if (parameterCount != constructor.getParameterTypes().length) {
                return 0;
            }
            for (int i = 0; i < parameterCount; ++i) {
                int newLevel = this.resolveLevelForType(this.locator.pattern.parameterSimpleNames[i], this.locator.pattern.parameterQualifications[i], constructor.getParameterTypes()[i]);
                if (level <= newLevel) continue;
                if (newLevel == 0) {
                    return 0;
                }
                level = newLevel;
            }
        }
        return level;
    }

    protected int matchLevelForDeclarations(MethodDeclaration constructor) {
        if (this.locator.pattern.declaringSimpleName != null && !this.locator.matchesName(this.locator.pattern.declaringSimpleName, constructor.getName().toString().toCharArray())) {
            return 0;
        }
        if (this.locator.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            List args = constructor.parameters();
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return 0;
            }
        }
        if (this.locator.pattern.hasConstructorArguments() && (constructor.typeParameters() == null || constructor.typeParameters().size() != this.locator.pattern.constructorArguments.length)) {
            return 0;
        }
        return this.locator.pattern.mustResolve ? 2 : 3;
    }
}

