/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class NetProperties {
    private static Properties props = new Properties();

    private NetProperties() {
    }

    private static void loadDefaultProperties() {
        String string = System.getProperty("java.home");
        if (string == null) {
            throw new Error("Can't find java.home ??");
        }
        try {
            File file = new File(string, "lib");
            file = new File(file, "net.properties");
            string = file.getCanonicalPath();
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            props.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String get(String string) {
        String string2 = props.getProperty(string);
        try {
            return System.getProperty(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Integer getInteger(String string, int n) {
        String string2 = null;
        try {
            string2 = System.getProperty(string, props.getProperty(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Integer(n);
    }

    public static Boolean getBoolean(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string, props.getProperty(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Boolean.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NetProperties.loadDefaultProperties();
                return null;
            }
        });
    }
}

