/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Lines;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.Objects;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Joins
extends ControlsSurface {
    protected int joinType = 0;
    protected float bswidth = 20.0f;
    protected JSlider slider;
    protected JLabel label;

    public Joins() {
        this.setBackground(Color.WHITE);
        this.slider = new JSlider(1, 0, 100, (int)(this.bswidth * 2.0f));
        this.slider.setPreferredSize(new Dimension(15, 100));
        this.slider.addChangeListener(new ChangeListener(this){
            final /* synthetic */ Joins this$0;
            {
                Joins joins = this$0;
                Objects.requireNonNull(joins);
                this.this$0 = joins;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.this$0.getImageType() <= 1) {
                    this.this$0.setImageType(2);
                }
                this.this$0.bswidth = (float)this.this$0.slider.getValue() / 2.0f;
                this.this$0.label.setText(" Width = " + String.valueOf(this.this$0.bswidth));
                this.this$0.label.repaint();
                this.this$0.repaint();
            }
        });
        this.setControls(new Component[]{new DemoControls(this, this), this.slider});
        this.setConstraints(new String[]{"North", "West"});
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        BasicStroke bs = new BasicStroke(this.bswidth, 0, this.joinType);
        GeneralPath p = new GeneralPath();
        p.moveTo((float)(-w) / 4.0f, (float)(-h) / 12.0f);
        p.lineTo((float)w / 4.0f, (float)(-h) / 12.0f);
        p.lineTo((float)(-w) / 6.0f, (float)h / 4.0f);
        p.lineTo(0.0f, (float)(-h) / 4.0f);
        p.lineTo((float)w / 6.0f, (float)h / 4.0f);
        p.closePath();
        p.closePath();
        g2.translate(w / 2, h / 2);
        g2.setColor(Color.BLACK);
        g2.draw(bs.createStrokedShape(p));
    }

    public static void main(String[] s) {
        Joins.createDemoFrame(new Joins());
    }

    class DemoControls
    extends CustomControls
    implements ActionListener {
        Joins demo;
        int[] joinType;
        String[] joinName;
        JMenu menu;
        JMenuItem[] menuitem;
        JoinIcon[] icons;
        JToolBar toolbar;
        final /* synthetic */ Joins this$0;

        public DemoControls(Joins this$0, Joins demo) {
            Joins joins = this$0;
            Objects.requireNonNull(joins);
            this.this$0 = joins;
            super(demo.name);
            this.joinType = new int[]{0, 1, 2};
            this.joinName = new String[]{"Mitered Join", "Rounded Join", "Beveled Join"};
            this.menuitem = new JMenuItem[this.joinType.length];
            this.icons = new JoinIcon[this.joinType.length];
            this.setBorder(new CompoundBorder(this.getBorder(), new EmptyBorder(2, 2, 2, 2)));
            this.demo = demo;
            this.setLayout(new BorderLayout());
            this$0.label = new JLabel(" Width = " + String.valueOf(demo.bswidth));
            Font font = new Font("Serif", 1, 14);
            this$0.label.setFont(font);
            this.add("West", this$0.label);
            JMenuBar menubar = new JMenuBar();
            this.add("East", menubar);
            this.menu = menubar.add(new JMenu(this.joinName[0]));
            font = new Font("Serif", 0, 10);
            this.menu.setFont(font);
            ActionListener actionListener = new ActionListener(this){
                {
                    Objects.requireNonNull(this$1);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            for (int i = 0; i < this.joinType.length; ++i) {
                this.icons[i] = new JoinIcon(this, this.joinType[i]);
                this.menuitem[i] = this.menu.add(new JMenuItem(this.joinName[i]));
                this.menuitem[i].setFont(font);
                this.menuitem[i].setIcon(this.icons[i]);
                this.menuitem[i].addActionListener(this);
            }
            this.menu.setIcon(this.icons[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.joinType.length; ++i) {
                if (!e.getSource().equals(this.menuitem[i])) continue;
                this.demo.joinType = this.joinType[i];
                this.menu.setIcon(this.icons[i]);
                this.menu.setText(this.joinName[i]);
                break;
            }
            this.demo.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 37);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(999L);
            }
            catch (Exception e) {
                return;
            }
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 0; i < this.menuitem.length; ++i) {
                    this.menuitem[i].doClick();
                    for (int k = 10; k < 60; k += 2) {
                        this.demo.slider.setValue(k);
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    try {
                        Thread.sleep(999L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            this.thread = null;
        }

        class JoinIcon
        implements Icon {
            int joinType;

            public JoinIcon(DemoControls this$1, int joinType) {
                Objects.requireNonNull(this$1);
                this.joinType = joinType;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                BasicStroke bs = new BasicStroke(8.0f, 0, this.joinType);
                ((Graphics2D)g).setStroke(bs);
                GeneralPath p = new GeneralPath();
                p.moveTo(0.0f, 3.0f);
                p.lineTo(this.getIconWidth() - 2, this.getIconHeight() / 2);
                p.lineTo(0.0f, this.getIconHeight());
                ((Graphics2D)g).draw(p);
            }

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public int getIconHeight() {
                return 20;
            }
        }
    }
}

