/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.io.IOException;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.parser.ReadBuffer;

public abstract class JavaLazyReadObject
extends JavaHeapObject {
    private final long offset;

    protected JavaLazyReadObject(long offset) {
        this.offset = offset;
    }

    @Override
    public final long getSize() {
        return this.getValueLength() + (long)this.getClazz().getMinimumObjectSize();
    }

    protected final long getOffset() {
        return this.offset;
    }

    protected ReadBuffer buf() {
        return this.getClazz().getReadBuffer();
    }

    protected int idSize() {
        return this.getClazz().getIdentifierSize();
    }

    protected final long getValueLength() {
        try {
            return this.readValueLength();
        }
        catch (IOException exp) {
            System.err.println("lazy read failed at offset " + this.offset);
            exp.printStackTrace();
            return 0L;
        }
    }

    protected final JavaThing[] getValue() {
        try {
            return this.readValue();
        }
        catch (IOException exp) {
            System.err.println("lazy read failed at offset " + this.offset);
            exp.printStackTrace();
            return Snapshot.EMPTY_JAVATHING_ARRAY;
        }
    }

    @Override
    public final long getId() {
        try {
            if (this.idSize() == 4) {
                return (long)this.buf().getInt(this.offset) & 0xFFFFFFFFL;
            }
            return this.buf().getLong(this.offset);
        }
        catch (IOException exp) {
            System.err.println("lazy read failed at offset " + this.offset);
            exp.printStackTrace();
            return -1L;
        }
    }

    protected abstract long readValueLength() throws IOException;

    protected abstract JavaThing[] readValue() throws IOException;

    protected static Number makeId(long id) {
        if ((id & 0xFFFFFFFF00000000L) == 0L) {
            return (int)id;
        }
        return id;
    }

    protected static long getIdValue(Number num) {
        long id = num.longValue();
        if (num instanceof Integer) {
            id &= 0xFFFFFFFFL;
        }
        return id;
    }

    protected final long objectIdAt(long offset) throws IOException {
        if (this.idSize() == 4) {
            return (long)this.intAt(offset) & 0xFFFFFFFFL;
        }
        return this.longAt(offset);
    }

    protected byte byteAt(long offset) throws IOException {
        return this.buf().getByte(offset);
    }

    protected boolean booleanAt(long offset) throws IOException {
        return this.byteAt(offset) != 0;
    }

    protected char charAt(long offset) throws IOException {
        return this.buf().getChar(offset);
    }

    protected short shortAt(long offset) throws IOException {
        return this.buf().getShort(offset);
    }

    protected int intAt(long offset) throws IOException {
        return this.buf().getInt(offset);
    }

    protected long longAt(long offset) throws IOException {
        return this.buf().getLong(offset);
    }

    protected float floatAt(long offset) throws IOException {
        int val = this.intAt(offset);
        return Float.intBitsToFloat(val);
    }

    protected double doubleAt(long offset) throws IOException {
        long val = this.longAt(offset);
        return Double.longBitsToDouble(val);
    }
}

