/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CRLReason;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.provider.certpath.ResponderId;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.util.SignatureUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.GeneralName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;
import sun.security.x509.X509CertImpl;

public class SimpleOCSPServer {
    private final Debug debug = Debug.getInstance("oserv");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.of(KnownOIDs.OCSPBasicResponse);
    private static final SimpleDateFormat utcDateFmt = new SimpleDateFormat("MMM dd yyyy, HH:mm:ss z");
    static final int FREE_PORT = 0;
    private ServerSocket servSocket;
    private final InetAddress listenAddress;
    private int listenPort;
    private final KeyStore keystore;
    private final X509Certificate issuerCert;
    private final X509Certificate signerCert;
    private final PrivateKey signerKey;
    private boolean logEnabled = false;
    private ExecutorService threadPool;
    private volatile boolean started = false;
    private CountDownLatch serverReady = new CountDownLatch(1);
    private volatile boolean receivedShutdown = false;
    private volatile boolean acceptConnections = true;
    private volatile long delayMsec = 0L;
    private boolean omitContentLength = false;
    private long nextUpdateInterval = -1L;
    private Date nextUpdate = null;
    private final ResponderId respId;
    private String sigAlgName;
    private final Map<CertId, CertStatusInfo> statusDb = Collections.synchronizedMap(new HashMap());

    public SimpleOCSPServer(KeyStore ks, String password, String issuerAlias, String signerAlias) throws GeneralSecurityException, IOException {
        this(null, 0, ks, password, issuerAlias, signerAlias);
    }

    public SimpleOCSPServer(InetAddress addr, int port, KeyStore ks, String password, String issuerAlias, String signerAlias) throws GeneralSecurityException, IOException {
        this.keystore = Objects.requireNonNull(ks, "Null keystore provided");
        Objects.requireNonNull(issuerAlias, "Null issuerName provided");
        utcDateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.issuerCert = (X509Certificate)this.keystore.getCertificate(issuerAlias);
        if (this.issuerCert == null) {
            throw new IllegalArgumentException("Certificate for alias " + issuerAlias + " not found");
        }
        if (signerAlias != null) {
            this.signerCert = (X509Certificate)this.keystore.getCertificate(signerAlias);
            if (this.signerCert == null) {
                throw new IllegalArgumentException("Certificate for alias " + signerAlias + " not found");
            }
            this.signerKey = (PrivateKey)this.keystore.getKey(signerAlias, password.toCharArray());
            if (this.signerKey == null) {
                throw new IllegalArgumentException("PrivateKey for alias " + signerAlias + " not found");
            }
        } else {
            this.signerCert = this.issuerCert;
            this.signerKey = (PrivateKey)this.keystore.getKey(issuerAlias, password.toCharArray());
            if (this.signerKey == null) {
                throw new IllegalArgumentException("PrivateKey for alias " + issuerAlias + " not found");
            }
        }
        this.sigAlgName = SignatureUtil.getDefaultSigAlgForKey(this.signerKey);
        this.respId = new ResponderId(this.signerCert.getSubjectX500Principal());
        this.listenAddress = addr;
        this.listenPort = port;
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            this.log("Server has already been started");
            return;
        }
        this.started = true;
        this.threadPool = Executors.newFixedThreadPool(32, new ThreadFactory(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.threadPool.submit(new Runnable(this){
            final /* synthetic */ SimpleOCSPServer this$0;
            {
                SimpleOCSPServer simpleOCSPServer = this$0;
                Objects.requireNonNull(simpleOCSPServer);
                this.this$0 = simpleOCSPServer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (ServerSocket sSock = new ServerSocket();){
                    this.this$0.servSocket = sSock;
                    this.this$0.servSocket.setReuseAddress(true);
                    this.this$0.servSocket.setSoTimeout(500);
                    this.this$0.servSocket.bind(new InetSocketAddress(this.this$0.listenAddress, this.this$0.listenPort), 128);
                    this.this$0.log("Listening on " + String.valueOf(this.this$0.servSocket.getLocalSocketAddress()));
                    this.this$0.listenPort = this.this$0.servSocket.getLocalPort();
                    this.this$0.serverReady.countDown();
                    while (!this.this$0.receivedShutdown) {
                        try {
                            Socket newConnection = this.this$0.servSocket.accept();
                            if (!this.this$0.acceptConnections) {
                                try {
                                    this.this$0.log("Reject connection");
                                    newConnection.close();
                                }
                                catch (IOException iOException) {}
                                continue;
                            }
                            this.this$0.threadPool.submit(new OcspHandler(this.this$0, newConnection));
                        }
                        catch (SocketTimeoutException newConnection) {
                        }
                        catch (IOException ioe) {
                            this.this$0.log("Unexpected Exception: " + String.valueOf(ioe));
                            this.this$0.stop();
                        }
                    }
                    this.this$0.log("Shutting down...");
                    this.this$0.threadPool.shutdown();
                }
                catch (IOException ioe) {
                    SimpleOCSPServer.err(ioe);
                }
                finally {
                    this.this$0.receivedShutdown = false;
                    this.this$0.started = false;
                    this.this$0.serverReady = new CountDownLatch(1);
                }
            }
        });
    }

    public synchronized void rejectConnections() {
        this.log("Reject OCSP connections");
        this.acceptConnections = false;
    }

    public synchronized void acceptConnections() {
        this.log("Accept OCSP connections");
        this.acceptConnections = true;
    }

    public synchronized void stop() {
        if (this.started) {
            this.receivedShutdown = true;
            this.started = false;
            this.log("Received shutdown notification");
        }
    }

    public synchronized void shutdownNow() {
        this.stop();
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCSP Server:\n");
        sb.append("----------------------------------------------\n");
        sb.append("issuer: ").append(this.issuerCert.getSubjectX500Principal()).append("\n");
        sb.append("signer: ").append(this.signerCert.getSubjectX500Principal()).append("\n");
        sb.append("ResponderId: ").append(this.respId).append("\n");
        sb.append("----------------------------------------------");
        return sb.toString();
    }

    private static String dumpHexBytes(byte[] data) {
        return SimpleOCSPServer.dumpHexBytes(data, data.length, 16, "\n", " ");
    }

    private static String dumpHexBytes(byte[] data, int dataLen, int itemsPerLine, String lineDelim, String itemDelim) {
        StringBuilder sb = new StringBuilder();
        if (data != null) {
            for (int i = 0; i < dataLen; ++i) {
                if (i % itemsPerLine == 0 && i != 0) {
                    sb.append(lineDelim);
                }
                sb.append(String.format("%02X", data[i])).append(itemDelim);
            }
        }
        return sb.toString();
    }

    public void enableLog(boolean enable) {
        if (!this.started) {
            this.logEnabled = enable;
        }
    }

    public synchronized void setNextUpdateInterval(long interval) {
        if (!this.started) {
            if (interval <= 0L) {
                this.nextUpdateInterval = -1L;
                this.nextUpdate = null;
                this.log("nexUpdate support has been disabled");
            } else {
                this.nextUpdateInterval = interval * 1000L;
                this.nextUpdate = new Date(System.currentTimeMillis() + this.nextUpdateInterval);
                this.log("nextUpdate set to " + String.valueOf(this.nextUpdate));
            }
        }
    }

    private synchronized Date getNextUpdate() {
        if (this.nextUpdate != null && this.nextUpdate.before(new Date())) {
            long nuEpochTime;
            long currentTime = System.currentTimeMillis();
            for (nuEpochTime = this.nextUpdate.getTime(); currentTime >= nuEpochTime; nuEpochTime += this.nextUpdateInterval) {
            }
            this.nextUpdate = new Date(nuEpochTime);
            this.log("nextUpdate updated to new value: " + String.valueOf(this.nextUpdate));
        }
        return this.nextUpdate;
    }

    public void updateStatusDb(Map<BigInteger, CertStatusInfo> newEntries) throws IOException {
        if (newEntries != null) {
            for (BigInteger serial : newEntries.keySet()) {
                CertStatusInfo info = newEntries.get(serial);
                if (info == null) continue;
                CertId cid = new CertId(this.issuerCert, new SerialNumber(serial));
                this.statusDb.put(cid, info);
                this.log("Added entry for serial " + String.valueOf(serial) + "(" + String.valueOf((Object)info.getType()) + ")");
            }
        }
    }

    private Map<CertId, CertStatusInfo> checkStatusDb(List<LocalOcspRequest.LocalSingleRequest> reqList) {
        HashMap<CertId, CertStatusInfo> returnMap = new HashMap<CertId, CertStatusInfo>();
        for (LocalOcspRequest.LocalSingleRequest req : reqList) {
            CertId cid = req.getCertId();
            CertStatusInfo info = this.statusDb.get(cid);
            if (info != null) {
                this.log("Status for SN " + String.valueOf(cid.getSerialNumber()) + ": " + String.valueOf((Object)info.getType()));
                returnMap.put(cid, info);
                continue;
            }
            this.log("Status for SN " + String.valueOf(cid.getSerialNumber()) + " not found, using CERT_STATUS_UNKNOWN");
            returnMap.put(cid, new CertStatusInfo(CertStatus.CERT_STATUS_UNKNOWN));
        }
        return Collections.unmodifiableMap(returnMap);
    }

    public void setSignatureAlgorithm(String algName) throws NoSuchAlgorithmException {
        if (!this.started) {
            AlgorithmId.get(algName);
            this.sigAlgName = algName;
            this.log("Signature algorithm set to " + algName);
        } else {
            this.log("Signature algorithm cannot be set on a running server, stop the server first");
        }
    }

    public int getPort() {
        if (this.serverReady.getCount() == 0L) {
            InetSocketAddress inetSock = (InetSocketAddress)this.servSocket.getLocalSocketAddress();
            return inetSock.getPort();
        }
        return -1;
    }

    public boolean awaitServerReady(long timeout, TimeUnit unit) throws InterruptedException {
        return this.serverReady.await(timeout, unit);
    }

    public void setDelay(long delayMillis) {
        long l = this.delayMsec = delayMillis > 0L ? delayMillis : 0L;
        if (this.delayMsec > 0L) {
            this.log("OCSP latency set to " + this.delayMsec + " milliseconds.");
        } else {
            this.log("OCSP latency disabled");
        }
    }

    public void setDisableContentLength(boolean isDisabled) {
        if (!this.started) {
            this.omitContentLength = isDisabled;
            this.log("Response Content-Length field " + (isDisabled ? "disabled" : "enabled"));
        }
    }

    private synchronized void log(String message) {
        if (this.logEnabled || this.debug != null) {
            System.out.println("[" + Thread.currentThread().getName() + "][" + System.currentTimeMillis() + "]: " + message);
        }
    }

    private static synchronized void err(String message) {
        System.err.println("[" + Thread.currentThread().getName() + "]: " + message);
    }

    private static synchronized void err(Throwable exc) {
        System.out.print("[" + Thread.currentThread().getName() + "]: Exception: ");
        exc.printStackTrace(System.out);
    }

    public static class CertStatusInfo {
        private final CertStatus certStatusType;
        private CRLReason reason;
        private final Date revocationTime;

        public CertStatusInfo(CertStatus statType) {
            this(statType, null, null);
        }

        public CertStatusInfo(CertStatus statType, Date revDate) {
            this(statType, revDate, null);
        }

        public CertStatusInfo(CertStatus statType, Date revDate, CRLReason revReason) {
            Objects.requireNonNull(statType, "Cert Status must be non-null");
            this.certStatusType = statType;
            switch (statType.ordinal()) {
                case 0: 
                case 2: {
                    this.revocationTime = null;
                    break;
                }
                case 1: {
                    this.revocationTime = revDate != null ? (Date)revDate.clone() : new Date();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown status type: " + String.valueOf((Object)statType));
                }
            }
        }

        public CertStatus getType() {
            return this.certStatusType;
        }

        public Date getRevocationTime() {
            return this.revocationTime != null ? (Date)this.revocationTime.clone() : null;
        }

        public CRLReason getRevocationReason() {
            return this.reason;
        }
    }

    public static enum CertStatus {
        CERT_STATUS_GOOD,
        CERT_STATUS_REVOKED,
        CERT_STATUS_UNKNOWN;

    }

    public class LocalOcspRequest {
        private byte[] nonce;
        private byte[] signature;
        private AlgorithmId algId;
        private int version;
        private GeneralName requestorName;
        private Map<String, Extension> extensions;
        private final List<LocalSingleRequest> requestList;
        private final List<X509Certificate> certificates;

        private LocalOcspRequest(SimpleOCSPServer this$0, byte[] requestBytes) throws IOException, CertificateException {
            DerValue[] topStructs;
            Objects.requireNonNull(this$0);
            this.signature = null;
            this.algId = null;
            this.version = 0;
            this.requestorName = null;
            this.extensions = Collections.emptyMap();
            this.requestList = new ArrayList<LocalSingleRequest>();
            this.certificates = new ArrayList<X509Certificate>();
            Objects.requireNonNull(requestBytes, "Received null input");
            this$0.log("Local OCSP Request Constructor, parsing bytes:\n" + SimpleOCSPServer.dumpHexBytes(requestBytes));
            DerInputStream dis = new DerInputStream(requestBytes);
            for (DerValue dv : topStructs = dis.getSequence(2)) {
                if (dv.tag == 48) {
                    this.parseTbsRequest(dv);
                    continue;
                }
                if (dv.isContextSpecific((byte)0)) {
                    this.parseSignature(dv);
                    continue;
                }
                throw new IOException("Unknown tag at top level: " + dv.tag);
            }
        }

        private void parseSignature(DerValue sigSequence) throws IOException, CertificateException {
            DerValue[] sigItems = sigSequence.data.getSequence(3);
            if (sigItems.length != 3) {
                throw new IOException("Invalid number of signature items: expected 3, got " + sigItems.length);
            }
            this.algId = AlgorithmId.parse(sigItems[0]);
            this.signature = sigItems[1].getBitString();
            if (sigItems[2].isContextSpecific((byte)0)) {
                DerValue[] certDerItems;
                for (DerValue dv : certDerItems = sigItems[2].data.getSequence(4)) {
                    X509CertImpl xc = new X509CertImpl(dv);
                    this.certificates.add(xc);
                }
            } else {
                throw new IOException("Invalid tag in signature block: " + sigItems[2].tag);
            }
        }

        private void parseTbsRequest(DerValue tbsReqSeq) throws IOException {
            while (tbsReqSeq.data.available() > 0) {
                DerValue dv = tbsReqSeq.data.getDerValue();
                if (dv.isContextSpecific((byte)0)) {
                    this.version = dv.data.getInteger();
                    continue;
                }
                if (dv.isContextSpecific((byte)1)) {
                    this.requestorName = new GeneralName(dv.data.getDerValue());
                    continue;
                }
                if (dv.isContextSpecific((byte)2)) {
                    DerValue[] extItems = dv.data.getSequence(2);
                    this.extensions = this.parseExtensions(extItems);
                    continue;
                }
                if (dv.tag != 48) continue;
                while (dv.data.available() > 0) {
                    this.requestList.add(new LocalSingleRequest(this, dv.data));
                }
            }
        }

        private Map<String, Extension> parseExtensions(DerValue[] extDerItems) throws IOException {
            HashMap<String, Extension> extMap = new HashMap<String, Extension>();
            if (extDerItems != null && extDerItems.length != 0) {
                for (DerValue extDerVal : extDerItems) {
                    sun.security.x509.Extension ext = new sun.security.x509.Extension(extDerVal);
                    extMap.put(ext.getId(), ext);
                }
            }
            return extMap;
        }

        private List<LocalSingleRequest> getRequests() {
            return Collections.unmodifiableList(this.requestList);
        }

        private List<X509Certificate> getCertificates() {
            return Collections.unmodifiableList(this.certificates);
        }

        private Map<String, Extension> getExtensions() {
            return Collections.unmodifiableMap(this.extensions);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("OCSP Request: Version %d (0x%X)", this.version + 1, this.version)).append("\n");
            if (this.requestorName != null) {
                sb.append("Requestor Name: ").append(this.requestorName).append("\n");
            }
            int requestCtr = 0;
            for (LocalSingleRequest lsr : this.requestList) {
                sb.append("Request [").append(requestCtr++).append("]\n");
                sb.append(lsr).append("\n");
            }
            if (!this.extensions.isEmpty()) {
                sb.append("Extensions (").append(this.extensions.size()).append(")\n");
                for (Extension ext : this.extensions.values()) {
                    sb.append("\t").append(ext).append("\n");
                }
            }
            if (this.signature != null) {
                sb.append("Signature: ").append(this.algId).append("\n");
                sb.append(SimpleOCSPServer.dumpHexBytes(this.signature)).append("\n");
                int certCtr = 0;
                for (X509Certificate cert : this.certificates) {
                    sb.append("Certificate [").append(certCtr++).append("]").append("\n");
                    sb.append("\tSubject: ");
                    sb.append(cert.getSubjectX500Principal()).append("\n");
                    sb.append("\tIssuer: ");
                    sb.append(cert.getIssuerX500Principal()).append("\n");
                    sb.append("\tSerial: ").append(cert.getSerialNumber());
                }
            }
            return sb.toString();
        }

        public class LocalSingleRequest {
            private final CertId cid;
            private Map<String, Extension> extensions;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private LocalSingleRequest(LocalOcspRequest this$1, DerInputStream dis) throws IOException {
                Objects.requireNonNull(this$1);
                this.extensions = Collections.emptyMap();
                DerValue[] srItems = dis.getSequence(2);
                if (srItems.length != 1 && srItems.length != 2) throw new IOException("Invalid number of items in Request (" + srItems.length + ")");
                this.cid = new CertId(srItems[0].data);
                if (srItems.length != 2) return;
                if (!srItems[1].isContextSpecific((byte)0)) throw new IOException("Illegal tag in Request extensions: " + srItems[1].tag);
                DerValue[] extDerItems = srItems[1].data.getSequence(2);
                this.extensions = this$1.parseExtensions(extDerItems);
            }

            private CertId getCertId() {
                return this.cid;
            }

            private Map<String, Extension> getExtensions() {
                return Collections.unmodifiableMap(this.extensions);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("CertId, Algorithm = ");
                sb.append(this.cid.getHashAlgorithm()).append("\n");
                sb.append("\tIssuer Name Hash: ");
                byte[] cidHashBuf = this.cid.getIssuerNameHash();
                sb.append(SimpleOCSPServer.dumpHexBytes(cidHashBuf, cidHashBuf.length, 256, "", ""));
                sb.append("\n");
                sb.append("\tIssuer Key Hash: ");
                cidHashBuf = this.cid.getIssuerKeyHash();
                sb.append(SimpleOCSPServer.dumpHexBytes(cidHashBuf, cidHashBuf.length, 256, "", ""));
                sb.append("\n");
                sb.append("\tSerial Number: ").append(this.cid.getSerialNumber());
                if (!this.extensions.isEmpty()) {
                    sb.append("Extensions (").append(this.extensions.size()).append(")\n");
                    for (Extension ext : this.extensions.values()) {
                        sb.append("\t").append(ext).append("\n");
                    }
                }
                return sb.toString();
            }
        }
    }

    public class LocalOcspResponse {
        private final int version = 0;
        private final OCSPResponse.ResponseStatus responseStatus;
        private final Map<CertId, CertStatusInfo> respItemMap;
        private final Date producedAtDate;
        private final List<LocalSingleResponse> singleResponseList;
        private final Map<String, Extension> responseExtensions;
        private byte[] signature;
        private final List<X509Certificate> certificates;
        private final Signature signEngine;
        private final AlgorithmId sigAlgId;
        final /* synthetic */ SimpleOCSPServer this$0;

        public LocalOcspResponse(SimpleOCSPServer this$0, OCSPResponse.ResponseStatus respStat) throws IOException, GeneralSecurityException {
            this(this$0, respStat, null, null);
        }

        public LocalOcspResponse(SimpleOCSPServer this$0, OCSPResponse.ResponseStatus respStat, Map<CertId, CertStatusInfo> itemMap, Map<String, Extension> reqExtensions) throws IOException, GeneralSecurityException {
            SimpleOCSPServer simpleOCSPServer = this$0;
            Objects.requireNonNull(simpleOCSPServer);
            this.this$0 = simpleOCSPServer;
            this.version = 0;
            this.singleResponseList = new ArrayList<LocalSingleResponse>();
            this.responseStatus = Objects.requireNonNull(respStat, "Illegal null response status");
            if (this.responseStatus == OCSPResponse.ResponseStatus.SUCCESSFUL) {
                this.respItemMap = Objects.requireNonNull(itemMap, "SUCCESSFUL responses must have a response map");
                this.producedAtDate = new Date();
                for (CertId id : itemMap.keySet()) {
                    this.singleResponseList.add(new LocalSingleResponse(this, id, itemMap.get(id)));
                }
                this.responseExtensions = this.setResponseExtensions(reqExtensions);
                this.certificates = new ArrayList<X509Certificate>();
                if (this$0.signerCert != this$0.issuerCert) {
                    this.certificates.add(this$0.signerCert);
                }
                this.certificates.add(this$0.issuerCert);
                this.signEngine = SignatureUtil.fromKey(this$0.sigAlgName, this$0.signerKey, "");
                this.sigAlgId = SignatureUtil.fromSignature(this.signEngine, this$0.signerKey);
            } else {
                this.respItemMap = null;
                this.producedAtDate = null;
                this.responseExtensions = null;
                this.certificates = null;
                this.signEngine = null;
                this.sigAlgId = null;
            }
        }

        private Map<String, Extension> setResponseExtensions(Map<String, Extension> reqExts) {
            HashMap<String, Extension> respExts = new HashMap<String, Extension>();
            String ocspNonceStr = PKIXExtensions.OCSPNonce_Id.toString();
            if (reqExts != null) {
                for (String id : reqExts.keySet()) {
                    if (!id.equals(ocspNonceStr)) continue;
                    Extension ext = reqExts.get(id);
                    if (ext != null) {
                        respExts.put(id, ext);
                        this.this$0.log("Added OCSP Nonce to response");
                        continue;
                    }
                    this.this$0.log("Error: Found nonce entry, but found null value.  Skipping");
                }
            }
            return respExts;
        }

        private byte[] getBytes() throws IOException {
            DerOutputStream outerSeq = new DerOutputStream();
            DerOutputStream responseStream = new DerOutputStream();
            responseStream.putEnumerated(this.responseStatus.ordinal());
            if (this.responseStatus == OCSPResponse.ResponseStatus.SUCCESSFUL && this.respItemMap != null) {
                this.encodeResponseBytes(responseStream);
            }
            outerSeq.write((byte)48, responseStream);
            return outerSeq.toByteArray();
        }

        private void encodeResponseBytes(DerOutputStream responseStream) throws IOException {
            DerOutputStream explicitZero = new DerOutputStream();
            DerOutputStream respItemStream = new DerOutputStream();
            respItemStream.putOID(OCSP_BASIC_RESPONSE_OID);
            byte[] basicOcspBytes = this.encodeBasicOcspResponse();
            respItemStream.putOctetString(basicOcspBytes);
            explicitZero.write((byte)48, respItemStream);
            responseStream.write(DerValue.createTag((byte)-128, true, (byte)0), explicitZero);
        }

        private byte[] encodeBasicOcspResponse() throws IOException {
            DerOutputStream outerSeq = new DerOutputStream();
            DerOutputStream basicORItemStream = new DerOutputStream();
            byte[] tbsResponseBytes = this.encodeTbsResponse();
            basicORItemStream.write(tbsResponseBytes);
            try {
                this.signEngine.update(tbsResponseBytes);
                this.signature = this.signEngine.sign();
                this.sigAlgId.encode(basicORItemStream);
                basicORItemStream.putBitString(this.signature);
            }
            catch (GeneralSecurityException exc) {
                SimpleOCSPServer.err(exc);
                throw new IOException(exc);
            }
            try {
                DerOutputStream certStream = new DerOutputStream();
                ArrayList<DerValue> certList = new ArrayList<DerValue>();
                if (this.this$0.signerCert != this.this$0.issuerCert) {
                    certList.add(new DerValue(this.this$0.signerCert.getEncoded()));
                }
                certList.add(new DerValue(this.this$0.issuerCert.getEncoded()));
                DerValue[] dvals = new DerValue[certList.size()];
                certStream.putSequence(certList.toArray(dvals));
                basicORItemStream.write(DerValue.createTag((byte)-128, true, (byte)0), certStream);
            }
            catch (CertificateEncodingException cex) {
                SimpleOCSPServer.err(cex);
                throw new IOException(cex);
            }
            outerSeq.write((byte)48, basicORItemStream);
            return outerSeq.toByteArray();
        }

        private byte[] encodeTbsResponse() throws IOException {
            DerOutputStream outerSeq = new DerOutputStream();
            DerOutputStream tbsStream = new DerOutputStream();
            tbsStream.write(this.this$0.respId.getEncoded());
            tbsStream.putGeneralizedTime(this.producedAtDate);
            this.encodeSingleResponses(tbsStream);
            this.encodeExtensions(tbsStream);
            outerSeq.write((byte)48, tbsStream);
            return outerSeq.toByteArray();
        }

        private void encodeSingleResponses(DerOutputStream tbsStream) throws IOException {
            DerValue[] srDerVals = new DerValue[this.singleResponseList.size()];
            int srDvCtr = 0;
            for (LocalSingleResponse lsr : this.singleResponseList) {
                srDerVals[srDvCtr++] = new DerValue(lsr.getBytes());
            }
            tbsStream.putSequence(srDerVals);
        }

        private void encodeExtensions(DerOutputStream tbsStream) throws IOException {
            DerOutputStream extSequence = new DerOutputStream();
            DerOutputStream extItems = new DerOutputStream();
            for (Extension ext : this.responseExtensions.values()) {
                ext.encode(extItems);
            }
            extSequence.write((byte)48, extItems);
            tbsStream.write(DerValue.createTag((byte)-128, true, (byte)1), extSequence);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("OCSP Response: ").append((Object)this.responseStatus).append("\n");
            if (this.responseStatus == OCSPResponse.ResponseStatus.SUCCESSFUL) {
                sb.append("Response Type: ").append(OCSP_BASIC_RESPONSE_OID.toString()).append("\n");
                sb.append(String.format("Version: %d (0x%X)", 1, 0)).append("\n");
                sb.append("Responder Id: ").append(this.this$0.respId.toString()).append("\n");
                sb.append("Produced At: ").append(utcDateFmt.format(this.producedAtDate)).append("\n");
                int srCtr = 0;
                for (LocalSingleResponse lsr : this.singleResponseList) {
                    sb.append("SingleResponse [").append(srCtr++).append("]\n");
                    sb.append(lsr);
                }
                if (!this.responseExtensions.isEmpty()) {
                    sb.append("Extensions (").append(this.responseExtensions.size()).append(")\n");
                    for (Extension ext : this.responseExtensions.values()) {
                        sb.append("\t").append(ext).append("\n");
                    }
                } else {
                    sb.append("\n");
                }
                if (this.signature != null) {
                    sb.append("Signature: ").append(this.sigAlgId).append("\n");
                    sb.append(SimpleOCSPServer.dumpHexBytes(this.signature)).append("\n");
                    int certCtr = 0;
                    for (X509Certificate cert : this.certificates) {
                        sb.append("Certificate [").append(certCtr++).append("]").append("\n");
                        sb.append("\tSubject: ");
                        sb.append(cert.getSubjectX500Principal()).append("\n");
                        sb.append("\tIssuer: ");
                        sb.append(cert.getIssuerX500Principal()).append("\n");
                        sb.append("\tSerial: ").append(cert.getSerialNumber());
                        sb.append("\n");
                    }
                }
            }
            return sb.toString();
        }

        private class LocalSingleResponse {
            private final CertId certId;
            private final CertStatusInfo csInfo;
            private final Date thisUpdate;
            private final Date lsrNextUpdate;
            private final Map<String, Extension> singleExtensions;

            public LocalSingleResponse(LocalOcspResponse localOcspResponse, CertId cid, CertStatusInfo info) {
                Objects.requireNonNull(localOcspResponse);
                this.certId = Objects.requireNonNull(cid, "CertId must be non-null");
                this.csInfo = Objects.requireNonNull(info, "CertStatusInfo must be non-null");
                this.thisUpdate = localOcspResponse.producedAtDate;
                this.lsrNextUpdate = localOcspResponse.this$0.getNextUpdate();
                this.singleExtensions = Collections.emptyMap();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("Certificate Status: ").append((Object)this.csInfo.getType());
                sb.append("\n");
                if (this.csInfo.getType() == CertStatus.CERT_STATUS_REVOKED) {
                    sb.append("Revocation Time: ");
                    sb.append(utcDateFmt.format(this.csInfo.getRevocationTime()));
                    sb.append("\n");
                    if (this.csInfo.getRevocationReason() != null) {
                        sb.append("Revocation Reason: ");
                        sb.append((Object)this.csInfo.getRevocationReason()).append("\n");
                    }
                }
                sb.append("CertId, Algorithm = ");
                sb.append(this.certId.getHashAlgorithm()).append("\n");
                sb.append("\tIssuer Name Hash: ");
                byte[] cidHashBuf = this.certId.getIssuerNameHash();
                sb.append(SimpleOCSPServer.dumpHexBytes(cidHashBuf, cidHashBuf.length, 256, "", ""));
                sb.append("\n");
                sb.append("\tIssuer Key Hash: ");
                cidHashBuf = this.certId.getIssuerKeyHash();
                sb.append(SimpleOCSPServer.dumpHexBytes(cidHashBuf, cidHashBuf.length, 256, "", ""));
                sb.append("\n");
                sb.append("\tSerial Number: ").append(this.certId.getSerialNumber());
                sb.append("\n");
                sb.append("This Update: ");
                sb.append(utcDateFmt.format(this.thisUpdate)).append("\n");
                if (this.lsrNextUpdate != null) {
                    sb.append("Next Update: ");
                    sb.append(utcDateFmt.format(this.lsrNextUpdate)).append("\n");
                }
                if (!this.singleExtensions.isEmpty()) {
                    sb.append("Extensions (").append(this.singleExtensions.size()).append(")\n");
                    for (Extension ext : this.singleExtensions.values()) {
                        sb.append("\t").append(ext).append("\n");
                    }
                }
                return sb.toString();
            }

            public byte[] getBytes() throws IOException {
                byte[] nullData = new byte[]{};
                DerOutputStream responseSeq = new DerOutputStream();
                DerOutputStream srStream = new DerOutputStream();
                this.certId.encode(srStream);
                CertStatus csiType = this.csInfo.getType();
                switch (csiType.ordinal()) {
                    case 0: {
                        srStream.write(DerValue.createTag((byte)-128, false, (byte)0), nullData);
                        break;
                    }
                    case 1: {
                        DerOutputStream revInfo = new DerOutputStream();
                        revInfo.putGeneralizedTime(this.csInfo.getRevocationTime());
                        CRLReason revReason = this.csInfo.getRevocationReason();
                        if (revReason != null) {
                            byte[] revDer = new byte[]{10, 1, (byte)revReason.ordinal()};
                            revInfo.write(DerValue.createTag((byte)-128, true, (byte)0), revDer);
                        }
                        srStream.write(DerValue.createTag((byte)-128, true, (byte)1), revInfo);
                        break;
                    }
                    case 2: {
                        srStream.write(DerValue.createTag((byte)-128, false, (byte)2), nullData);
                        break;
                    }
                    default: {
                        throw new IOException("Unknown CertStatus: " + String.valueOf((Object)csiType));
                    }
                }
                srStream.putGeneralizedTime(this.thisUpdate);
                if (this.lsrNextUpdate != null) {
                    DerOutputStream nuStream = new DerOutputStream();
                    nuStream.putGeneralizedTime(this.lsrNextUpdate);
                    srStream.write(DerValue.createTag((byte)-128, true, (byte)0), nuStream);
                }
                responseSeq.write((byte)48, srStream);
                return responseSeq.toByteArray();
            }
        }
    }

    private class OcspHandler
    implements Runnable {
        private final boolean USE_GET;
        private final Socket sock;
        InetSocketAddress peerSockAddr;
        final /* synthetic */ SimpleOCSPServer this$0;

        private OcspHandler(SimpleOCSPServer simpleOCSPServer, Socket incomingSocket) {
            SimpleOCSPServer simpleOCSPServer2 = simpleOCSPServer;
            Objects.requireNonNull(simpleOCSPServer2);
            this.this$0 = simpleOCSPServer2;
            this.USE_GET = !System.getProperty("com.sun.security.ocsp.useget", "").equals("false");
            this.sock = incomingSocket;
        }

        @Override
        public void run() {
            try {
                if (this.this$0.delayMsec > 0L) {
                    this.this$0.log("Delaying response for " + this.this$0.delayMsec + " milliseconds.");
                    Thread.sleep(this.this$0.delayMsec);
                }
            }
            catch (InterruptedException ie) {
                this.this$0.log("Delay of " + this.this$0.delayMsec + " milliseconds was interrupted");
            }
            try (Socket ocspSocket = this.sock;
                 InputStream in = ocspSocket.getInputStream();
                 OutputStream out = ocspSocket.getOutputStream();){
                OCSPResponse.ResponseStatus respStat;
                LocalOcspResponse ocspResp;
                block39: {
                    this.peerSockAddr = (InetSocketAddress)ocspSocket.getRemoteSocketAddress();
                    String[] headerTokens = this.readLine(in).split(" ");
                    ocspResp = null;
                    respStat = OCSPResponse.ResponseStatus.INTERNAL_ERROR;
                    try {
                        LocalOcspRequest ocspReq;
                        if (headerTokens[0] != null) {
                            this.this$0.log("Received incoming HTTP " + headerTokens[0] + " from " + String.valueOf(this.peerSockAddr));
                            switch (headerTokens[0].toUpperCase()) {
                                case "POST": {
                                    ocspReq = this.parseHttpOcspPost(in);
                                    break;
                                }
                                case "GET": {
                                    ocspReq = this.parseHttpOcspGet(headerTokens, in);
                                    break;
                                }
                                default: {
                                    respStat = OCSPResponse.ResponseStatus.MALFORMED_REQUEST;
                                    throw new IOException("Not a GET or POST");
                                }
                            }
                        } else {
                            respStat = OCSPResponse.ResponseStatus.MALFORMED_REQUEST;
                            throw new IOException("Unable to get HTTP method");
                        }
                        if (ocspReq != null) {
                            this.this$0.log(ocspReq.toString());
                            Map<CertId, CertStatusInfo> statusMap = this.this$0.checkStatusDb(ocspReq.getRequests());
                            if (statusMap.isEmpty()) {
                                respStat = OCSPResponse.ResponseStatus.UNAUTHORIZED;
                            } else {
                                ocspResp = new LocalOcspResponse(this.this$0, OCSPResponse.ResponseStatus.SUCCESSFUL, statusMap, ocspReq.getExtensions());
                            }
                            break block39;
                        }
                        respStat = OCSPResponse.ResponseStatus.MALFORMED_REQUEST;
                        throw new IOException("Found null request");
                    }
                    catch (IOException | RuntimeException exc) {
                        SimpleOCSPServer.err(exc);
                    }
                }
                if (ocspResp == null) {
                    ocspResp = new LocalOcspResponse(this.this$0, respStat);
                }
                this.sendResponse(out, ocspResp);
                out.flush();
                this.this$0.log("Closing " + String.valueOf(ocspSocket));
            }
            catch (IOException | GeneralSecurityException exc) {
                SimpleOCSPServer.err(exc);
            }
        }

        public void sendResponse(OutputStream out, LocalOcspResponse resp) throws IOException {
            byte[] respBytes;
            StringBuilder sb = new StringBuilder();
            try {
                respBytes = resp.getBytes();
            }
            catch (RuntimeException re) {
                SimpleOCSPServer.err(re);
                return;
            }
            sb.append("HTTP/1.0 200 OK\r\n");
            sb.append("Content-Type: application/ocsp-response\r\n");
            if (!this.this$0.omitContentLength) {
                sb.append("Content-Length: ").append(respBytes.length).append("\r\n");
            }
            sb.append("\r\n");
            this.this$0.log(resp.toString());
            out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            out.write(respBytes);
        }

        private LocalOcspRequest parseHttpOcspPost(InputStream inStream) throws IOException, CertificateException {
            boolean endOfHeader = false;
            boolean properContentType = false;
            int length = -1;
            while (!endOfHeader) {
                String[] lineTokens = this.readLine(inStream).split(" ");
                if (lineTokens[0].isEmpty()) {
                    endOfHeader = true;
                    continue;
                }
                if (lineTokens[0].equalsIgnoreCase("Content-Type:")) {
                    if (lineTokens[1] == null || !lineTokens[1].equals("application/ocsp-request")) {
                        this.this$0.log("Unknown Content-Type: " + (lineTokens[1] != null ? lineTokens[1] : "<NULL>"));
                        return null;
                    }
                    properContentType = true;
                    this.this$0.log("Content-Type = " + lineTokens[1]);
                    continue;
                }
                if (!lineTokens[0].equalsIgnoreCase("Content-Length:") || lineTokens[1] == null) continue;
                length = Integer.parseInt(lineTokens[1]);
                this.this$0.log("Content-Length = " + length);
            }
            if (properContentType && length >= 0) {
                if (this.USE_GET && length <= 255) {
                    throw new IOException("Should have received small GET, not POST.");
                }
                byte[] ocspBytes = new byte[length];
                inStream.read(ocspBytes);
                return new LocalOcspRequest(this.this$0, ocspBytes);
            }
            return null;
        }

        private LocalOcspRequest parseHttpOcspGet(String[] headerTokens, InputStream inStream) throws IOException, CertificateException {
            StringBuilder sb = new StringBuilder("OCSP GET REQUEST\n");
            for (String hTok : headerTokens) {
                sb.append(hTok).append("\n");
            }
            this.this$0.log(sb.toString());
            boolean endOfHeader = false;
            while (!endOfHeader) {
                String[] lineTokens = this.readLine(inStream).split(":", 2);
                if (lineTokens[0].isEmpty()) {
                    endOfHeader = true;
                    continue;
                }
                if (lineTokens.length == 2) {
                    this.this$0.log(String.format("ReqHdr: %s: %s", lineTokens[0].trim(), lineTokens[1].trim()));
                    continue;
                }
                this.this$0.log("ReqHdr: " + lineTokens[0].trim());
            }
            return new LocalOcspRequest(this.this$0, Base64.getMimeDecoder().decode(URLDecoder.decode(headerTokens[1].replaceAll("/", ""), StandardCharsets.UTF_8)));
        }

        private String readLine(InputStream is) throws IOException {
            PushbackInputStream pbis = new PushbackInputStream(is);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean done = false;
            while (!done) {
                byte b = (byte)pbis.read();
                if (b == 13) {
                    byte bNext = (byte)pbis.read();
                    if (bNext == 10 || bNext == -1) {
                        done = true;
                        continue;
                    }
                    pbis.unread(bNext);
                    bos.write(b);
                    continue;
                }
                if (b == -1) {
                    done = true;
                    continue;
                }
                bos.write(b);
            }
            return bos.toString(StandardCharsets.UTF_8);
        }
    }
}

