/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildCause;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.mylyn.internal.builds.ui.editor.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SummaryPart
extends AbstractBuildEditorPart {
    public SummaryPart() {
        super(320);
        this.setPartName(Messages.SummaryPart_summary);
    }

    private void append(StringBuilder sb, String text) {
        if (text != null) {
            if (sb.length() > 0) {
                sb.append(". ");
            }
            sb.append(text);
        }
    }

    @Override
    protected Control createContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.createLabel(composite, toolkit, Messages.SummaryPart_startedOn);
        Text text = this.createTextReadOnly(composite, toolkit, "");
        this.bind(text, IBuild.class, (EStructuralFeature)BuildPackage.Literals.BUILD__TIMESTAMP);
        IBuild build = this.getInput(IBuild.class);
        if (build.getCause().size() > 0) {
            LinkedHashSet<String> causeDescriptions = new LinkedHashSet<String>();
            for (IBuildCause cause : build.getCause()) {
                if (cause.getDescription() == null) continue;
                causeDescriptions.add(cause.getDescription());
            }
            StringBuilder sb = new StringBuilder();
            for (String string : causeDescriptions) {
                this.append(sb, string);
            }
            if (sb.length() > 0) {
                sb.append(".");
            }
            this.createLabel(composite, toolkit, Messages.SummaryPart_cause);
            text = this.createTextReadOnly(composite, toolkit, "", 64);
            text.setText(sb.toString());
        }
        return composite;
    }

    @Override
    public Control createControl(Composite parent, FormToolkit toolkit) {
        return this.createContent(parent, toolkit);
    }
}

