/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.GwtIncompatible;
import com.google.javascript.rhino.jstype.TernaryValue;

@GwtIncompatible(value="Unsupported java.lang.Character fields")
public class TokenUtil {
    static boolean isJSIdentifier(String s) {
        int length = s.length();
        if (length == 0 || Character.isIdentifierIgnorable(s.charAt(0)) || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (!Character.isIdentifierIgnorable(s.charAt(i)) && Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJSSpace(int c) {
        if (c <= 127) {
            return c == 32 || c == 9 || c == 12 || c == 11;
        }
        return c == 160 || Character.getType((char)c) == 12;
    }

    public static boolean isJSFormatChar(int c) {
        return c > 127 && Character.getType(c) == 16;
    }

    public static boolean isWhitespace(int c) {
        return Character.isWhitespace(c);
    }

    public static TernaryValue isStrWhiteSpaceChar(int c) {
        switch (c) {
            case 11: {
                return TernaryValue.UNKNOWN;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 160: 
            case 8232: 
            case 8233: 
            case 65279: {
                return TernaryValue.TRUE;
            }
        }
        return Character.getType(c) == 12 ? TernaryValue.TRUE : TernaryValue.FALSE;
    }
}

