/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.ui.internal.java.search.JSPSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.search.FindOccurrencesProcessor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPFindOccurrencesProcessor
extends FindOccurrencesProcessor {
    public boolean findOccurrences(IDocument document, ITextSelection textSelection, IFile file) {
        String matchText;
        String type;
        ITextRegion r;
        IStructuredDocument structuredDocument;
        IStructuredDocumentRegion sdRegion;
        boolean findOccurrences = false;
        if (document instanceof IStructuredDocument && (sdRegion = (structuredDocument = (IStructuredDocument)document).getRegionAtCharacterOffset(textSelection.getOffset())) != null && (r = sdRegion.getRegionAtCharacterOffset(textSelection.getOffset())) != null && this.enabledForRegionType(type = r.getType()) && (matchText = sdRegion.getText(r)) != null && type != null) {
            JSPSearchQuery searchQuery = (JSPSearchQuery)this.getSearchQuery(file, structuredDocument, matchText, type, textSelection);
            findOccurrences = true;
            if (searchQuery != null) {
                if (searchQuery.getSearchText() == null || searchQuery.getSearchText().length() == 0) {
                    findOccurrences = false;
                } else {
                    NewSearchUI.activateSearchResultView();
                    if (searchQuery.canRunInBackground()) {
                        NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
                    } else {
                        NewSearchUI.runQueryInForeground(null, (ISearchQuery)searchQuery);
                    }
                }
            }
        }
        return findOccurrences;
    }

    protected String[] getPartitionTypes() {
        return new String[]{"org.eclipse.jst.jsp.DEFAULT_JSP", "org.eclipse.jst.jsp.SCRIPT.JAVA"};
    }

    protected String[] getRegionTypes() {
        return new String[]{"BLOCK_TEXT", "JSP_CONTENT"};
    }

    protected ISearchQuery getSearchQuery(IFile file, IStructuredDocument document, String regionText, String regionType, ITextSelection textSelection) {
        return new JSPSearchQuery(file, this.getJavaElement((IDocument)document, textSelection));
    }

    private IJavaElement getJavaElement(IDocument document, ITextSelection textSelection) {
        IJavaElement[] elements = this.getJavaElementsForCurrentSelection(document, textSelection);
        return elements.length > 0 ? elements[0] : null;
    }

    private IJavaElement[] getJavaElementsForCurrentSelection(IDocument document, ITextSelection selection) {
        IJavaElement[] elements = new IJavaElement[]{};
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            IDOMDocument xmlDoc;
            JSPTranslationAdapter adapter;
            if (model != null && model instanceof IDOMModel && (adapter = (JSPTranslationAdapter)(xmlDoc = ((IDOMModel)model).getDocument()).getAdapterFor(IJSPTranslation.class)) != null) {
                JSPTranslationExtension translation = adapter.getJSPTranslation();
                elements = translation.getElementsFromJspRange(selection.getOffset(), selection.getOffset() + selection.getLength());
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return elements;
    }
}

