/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class RenameBranchOperation
implements IEGitOperation {
    private final Repository repository;
    private final Ref branch;
    private final String newName;

    public RenameBranchOperation(Repository repository, Ref branch, String newName) {
        this.repository = repository;
        this.branch = branch;
        this.newName = newName;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        String taskName = NLS.bind((String)CoreText.RenameBranchOperation_TaskName, (Object)this.branch.getName(), (Object)this.newName);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setTaskName(taskName);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Git git = new Git(this.repository);){
                git.branchRename().setOldName(this.branch.getName()).setNewName(this.newName).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException | JGitInternalException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

