/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import java.util.LinkedList;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlDocumentFormatter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;

public class XmlDocumentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList<IDocument> fDocuments = new LinkedList();
    private final FormattingPreferences prefs;
    private int indent = -1;

    public XmlDocumentFormattingStrategy() {
        this.prefs = new FormattingPreferences();
    }

    public XmlDocumentFormattingStrategy(FormattingPreferences prefs, int indent) {
        Assert.isNotNull((Object)prefs);
        this.prefs = prefs;
        this.indent = indent;
    }

    public void format() {
        super.format();
        IDocument document = this.fDocuments.removeFirst();
        if (document != null) {
            String documentText = document.get();
            XmlDocumentFormatter formatter = new XmlDocumentFormatter();
            if (this.indent != -1) {
                formatter.setInitialIndent(this.indent);
            }
            formatter.setDefaultLineDelimiter(TextUtilities.getDefaultLineDelimiter((IDocument)document));
            String formattedText = formatter.format(documentText, this.prefs);
            if (formattedText != null && !formattedText.equals(documentText)) {
                document.set(formattedText);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fDocuments.addLast((IDocument)context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fDocuments.clear();
    }
}

