/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class ContentAssistAction
extends TextEditorAction {
    private ITextOperationTarget fOperationTarget;

    public ContentAssistAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        ITextEditor editor;
        if (this.fOperationTarget != null && (editor = this.getTextEditor()) != null && this.validateEditorInputState()) {
            Display display = null;
            IWorkbenchPartSite site = editor.getSite();
            Shell shell = site.getShell();
            if (shell != null && !shell.isDisposed()) {
                display = shell.getDisplay();
            }
            BusyIndicator.showWhile(display, () -> this.fOperationTarget.doOperation(13));
        }
    }

    @Override
    public void update() {
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        if (this.fOperationTarget == null) {
            this.setEnabled(false);
            return;
        }
        ITextOperationTarget iTextOperationTarget = this.fOperationTarget;
        if (iTextOperationTarget instanceof ITextOperationTargetExtension) {
            ITextOperationTargetExtension targetExtension = (ITextOperationTargetExtension)iTextOperationTarget;
            targetExtension.enableOperation(13, this.canModifyEditor());
        }
        this.setEnabled(this.fOperationTarget.canDoOperation(13));
    }

    @Override
    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }
}

