/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LinkPrototypeAction
extends AbstractLaunchConfigurationAction {
    public static final String ID_LINK_PROTOTYPE_ACTION = DebugUIPlugin.getUniqueIdentifier() + ".ID_LINK_PROTOTYPE_ACTION";

    public LinkPrototypeAction(Viewer viewer, String mode) {
        super(LaunchConfigurationsMessages.LinkPrototypeAction_Link_prototype_1, viewer, mode);
    }

    @Override
    protected void performAction() {
        try {
            ILaunchConfiguration firstLaunchConfiguration = (ILaunchConfiguration)this.getStructuredSelection().getFirstElement();
            ILaunchConfigurationType type = firstLaunchConfiguration.getType();
            Object[] prototypes = type.getPrototypes();
            DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)DebugUITools.newDebugModelPresentation(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
            ElementListSelectionDialog selectPrototypeDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            selectPrototypeDialog.setElements(prototypes);
            selectPrototypeDialog.setInitialSelections(new Object[]{firstLaunchConfiguration.getPrototype()});
            selectPrototypeDialog.setMultipleSelection(false);
            selectPrototypeDialog.setEmptySelectionMessage("You have to select a prototype.");
            selectPrototypeDialog.setTitle("Please select a prototype");
            int open = selectPrototypeDialog.open();
            if (open == 0) {
                Object selectedPrototype = selectPrototypeDialog.getFirstResult();
                for (Object launchConfiguration : this.getStructuredSelection().toList()) {
                    ILaunchConfigurationDialog dialog;
                    if (!(launchConfiguration instanceof ILaunchConfiguration)) continue;
                    ILaunchConfigurationWorkingCopy workingCopy = ((ILaunchConfiguration)launchConfiguration).getWorkingCopy();
                    workingCopy.setPrototype((ILaunchConfiguration)selectedPrototype, true);
                    workingCopy.doSave();
                    if (this.getStructuredSelection().size() != 1 || !((dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog()) instanceof LaunchConfigurationsDialog)) continue;
                    ((LaunchConfigurationsDialog)dialog).getTabViewer().setInput(workingCopy);
                }
                this.getViewer().refresh();
            }
        }
        catch (CoreException e) {
            this.errorDialog(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        ILaunchConfigurationType type = null;
        for (Object object : selection.toList()) {
            ILaunchConfigurationType currentType;
            void launchConfig;
            if (!(object instanceof ILaunchConfiguration)) {
                return false;
            }
            ILaunchConfiguration iLaunchConfiguration = (ILaunchConfiguration)object;
            if (launchConfig.isPrototype()) {
                return false;
            }
            try {
                currentType = launchConfig.getType();
                if (currentType.getPrototypes().length == 0) {
                    return false;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
                return false;
            }
            if (type == null) {
                type = currentType;
                continue;
            }
            if (type.equals(currentType)) continue;
            return false;
        }
        return true;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_DLCL_LINK_PROTO");
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugUITools.getImageDescriptor("IMG_ELCL_LINK_PROTO");
    }

    public String getToolTipText() {
        return LaunchConfigurationsMessages.LaunchConfigurationsDialog_7;
    }
}

