/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.ast.ASTProvider;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private ISourceModuleDocumentProvider fDocumentProvider;

    public PHPReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fDocumentProvider = DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    private void reconcile(final boolean initialReconcile) {
        PHPStructuredEditor editor;
        IModelElement modelElement;
        if (!(this.fEditor instanceof PHPStructuredEditor)) {
            return;
        }
        if (this.fProgressMonitor == null) {
            this.fProgressMonitor = new NullProgressMonitor();
        }
        if ((modelElement = (editor = (PHPStructuredEditor)this.fEditor).getModelElement()) instanceof ISourceModule) {
            final Program[] ast = new Program[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws ModelException {
                    ast[0] = PHPReconcilingStrategy.this.reconcile((ISourceModule)modelElement, initialReconcile);
                }

                public void handleException(Throwable ex) {
                    Status status = new Status(4, "org.eclipse.php.ui", 0, "Error in php Core during reconcile", ex);
                    PHPCorePlugin.getDefault().getLog().log((IStatus)status);
                }
            });
            editor.reconciled(ast[0], initialReconcile, this.fProgressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program reconcile(ISourceModule unit, boolean initialReconcile) throws ModelException {
        IProblemRequestorExtension extension = this.getProblemRequestorExtension();
        if (extension != null) {
            extension.setProgressMonitor(this.fProgressMonitor);
            extension.setIsActive(true);
        }
        try {
            ASTProvider astProvider = PHPUiPlugin.getDefault().getASTProvider();
            ISourceModule iSourceModule = unit;
            synchronized (iSourceModule) {
                unit.reconcile(true, null, this.fProgressMonitor);
            }
            Program createdAST = astProvider.getAST(unit, SharedASTProvider.WAIT_NO, this.fProgressMonitor);
            if (astProvider.isActive(unit) && createdAST != null) {
                Program program = createdAST;
                return program;
            }
            if (initialReconcile || astProvider.isActive(unit)) {
                boolean useShortTags;
                boolean isSupportingASPTags;
                PHPVersion phpVersion = ProjectOptions.getPHPVersion((IProject)unit.getScriptProject().getProject());
                ASTParser newParser = ASTParser.newParser((PHPVersion)phpVersion, (boolean)(isSupportingASPTags = ProjectOptions.isSupportingASPTags((IProject)unit.getScriptProject().getProject())), (boolean)(useShortTags = ProjectOptions.useShortTags((IProject)unit.getScriptProject().getProject())), (ISourceModule)unit);
                Program program = createdAST = newParser != null ? newParser.createAST(null) : null;
                if (createdAST != null && this.fDocument != null) {
                    createdAST.setSourceModule(unit);
                    createdAST.setSourceRange(0, this.fDocument.getLength());
                    createdAST.setLineEndTable(Util.lineEndTable((IDocument)this.fDocument));
                }
                Program program2 = createdAST;
                return program2;
            }
        }
        catch (OperationCanceledException ex) {
            Assert.isTrue((this.fProgressMonitor == null || this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new ModelException((Throwable)e, 4);
        }
        finally {
            if (extension != null) {
                extension.setProgressMonitor(null);
                extension.setIsActive(false);
            }
        }
        return null;
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }
}

