/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterNode;

public class FormatterContext
implements IFormatterContext,
Cloneable {
    private int indent;
    private boolean indenting = true;
    private boolean comment = false;
    private boolean wrapping = false;
    private int blankLines = 0;
    private final List<PathEntry> path = new ArrayList<PathEntry>();

    public FormatterContext(int indent) {
        this.indent = indent;
    }

    @Override
    public IFormatterContext copy() {
        try {
            return (IFormatterContext)this.clone();
        }
        catch (CloneNotSupportedException e) {
            DLTKCore.error((String)"FormatterContext.copy() error", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    @Override
    public void decIndent() {
        --this.indent;
    }

    @Override
    public void incIndent() {
        ++this.indent;
    }

    @Override
    public void resetIndent() {
        this.indent = 0;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public boolean isIndenting() {
        return this.indenting;
    }

    @Override
    public void setIndenting(boolean value) {
        this.indenting = value;
    }

    @Override
    public boolean isComment() {
        return this.comment;
    }

    @Override
    public void setComment(boolean value) {
        this.comment = value;
    }

    @Override
    public int getBlankLines() {
        return this.blankLines;
    }

    @Override
    public void resetBlankLines() {
        this.blankLines = -1;
    }

    @Override
    public void setBlankLines(int value) {
        if (value >= 0 && value > this.blankLines) {
            this.blankLines = value;
        }
    }

    @Override
    public void enter(IFormatterNode node) {
        this.path.add(new PathEntry(node));
    }

    @Override
    public void leave(IFormatterNode node) {
        PathEntry entry = this.path.remove(this.path.size() - 1);
        if (entry.node != node) {
            throw new IllegalStateException("leave() - node mismatch");
        }
        if (!this.path.isEmpty() && this.isCountable(node)) {
            PathEntry parent = this.path.get(this.path.size() - 1);
            ++parent.childIndex;
        }
    }

    protected boolean isCountable(IFormatterNode node) {
        return true;
    }

    @Override
    public IFormatterNode getParent() {
        if (this.path.size() > 1) {
            PathEntry entry = this.path.get(this.path.size() - 2);
            return entry.node;
        }
        return null;
    }

    @Override
    public int getChildIndex() {
        if (this.path.size() > 1) {
            PathEntry entry = this.path.get(this.path.size() - 2);
            return entry.childIndex;
        }
        return -1;
    }

    @Override
    public boolean isWrapping() {
        return this.wrapping;
    }

    @Override
    public void setWrapping(boolean value) {
        this.wrapping = value;
    }

    private static class PathEntry {
        final IFormatterNode node;
        int childIndex = 0;

        public PathEntry(IFormatterNode node) {
            this.node = node;
        }
    }
}

