/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.server.core.builtin.PHPProjectModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class PHPProjectModuleFactory
extends ProjectModuleFactoryDelegate {
    private static final IModule[] EMPTY_MODULE = new IModule[0];

    public ModuleDelegate getModuleDelegate(IModule module) {
        return new PHPProjectModule(module.getProject());
    }

    protected IModule[] createModules(IProject project) {
        try {
            if (!PHPToolkitUtil.isPHPProject((IProject)project)) {
                return EMPTY_MODULE;
            }
        }
        catch (CoreException e) {
            return EMPTY_MODULE;
        }
        PHPVersion phpVersion = ProjectOptions.getPHPVersion((IProject)project);
        String moduleVersion = this.getModuleVersion(phpVersion);
        if (moduleVersion == null) {
            return EMPTY_MODULE;
        }
        String id = project.getName();
        String name = project.getName();
        IModule module = this.createModule(id, name, "php.web", moduleVersion, project);
        return new IModule[]{module};
    }

    private String getModuleVersion(PHPVersion phpVersion) {
        if (phpVersion == null) {
            return null;
        }
        return phpVersion.getAlias().substring(3);
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{Path.EMPTY};
    }
}

