/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.utils.pty.ConPTY;
import org.eclipse.cdt.utils.pty.PTYInputStream;

public class ConPTYInputStream
extends PTYInputStream {
    private ConPTY conPty;

    public ConPTYInputStream(ConPTY conPty) {
        super(null);
        this.conPty = conPty;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > buf.length || len < 0 || off + len > buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmpBuf = new byte[len];
        if ((len = this.conPty.read(tmpBuf)) <= 0) {
            return -1;
        }
        System.arraycopy(tmpBuf, 0, buf, off, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        if (this.conPty == null) {
            return;
        }
        try {
            this.conPty.close();
        }
        finally {
            this.conPty = null;
        }
    }
}

