/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.internal.FileDropAction;

public class FileDropEditorIncludeAction
extends FileDropAction {
    public boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        if (!(targetEditor instanceof PHPStructuredEditor)) {
            return super.run(event, targetEditor);
        }
        String[] fileNames = (String[])event.data;
        if (fileNames == null || fileNames.length == 0) {
            return false;
        }
        IModelElement editorElement = ((PHPStructuredEditor)targetEditor).getModelElement();
        if (editorElement != null) {
            ISourceModule sourceModule = ((ModelElement)editorElement).getSourceModule();
            ASTParser parser = ASTParser.newParser((ISourceModule)sourceModule);
            try {
                Program program = parser.createAST(null);
                program.recordModifications();
                AST ast = program.getAST();
                IDocument document = ((PHPStructuredEditor)targetEditor).getDocument();
                int i = 0;
                while (i < fileNames.length) {
                    String relativeLocationFromIncludePath = this.getFileName(fileNames[i], (IModelElement)sourceModule);
                    if (relativeLocationFromIncludePath != null) {
                        Include include = ast.newInclude((Expression)ast.newScalar("'" + relativeLocationFromIncludePath.toString() + "'"), 1);
                        program.statements().add(i, ast.newExpressionStatement((Expression)include));
                        TextEdit edits = program.rewrite(document, null);
                        edits.apply(document);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private String getFileName(String input, IModelElement sourceModule) {
        IFile fileForLocation = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(input));
        if (fileForLocation == null) {
            return null;
        }
        IPath relativeLocationFromIncludePath = IncludePathUtils.getRelativeLocationFromIncludePath(sourceModule.getScriptProject(), DLTKCore.create((IFile)fileForLocation));
        if (relativeLocationFromIncludePath.isEmpty()) {
            return null;
        }
        return relativeLocationFromIncludePath.toString();
    }
}

