/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.settings.capabilities.ClientCapabilitiesWrapper;
import org.eclipse.lemminx.settings.capabilities.ServerCapabilitiesConstants;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;

public class XMLCapabilityManager {
    private final Set<String> registeredCapabilities = new HashSet<String>(3);
    private final LanguageClient languageClient;
    private final XMLTextDocumentService textDocumentService;
    private ClientCapabilitiesWrapper clientWrapper;

    public XMLCapabilityManager(LanguageClient languageClient, XMLTextDocumentService textDocumentService) {
        this.languageClient = languageClient;
        this.textDocumentService = textDocumentService;
    }

    public void setClientCapabilities(ClientCapabilities clientCapabilities, ExtendedClientCapabilities extendedClientCapabilities) {
        this.clientWrapper = new ClientCapabilitiesWrapper(clientCapabilities, extendedClientCapabilities);
    }

    public ClientCapabilitiesWrapper getClientCapabilities() {
        if (this.clientWrapper == null) {
            this.clientWrapper = new ClientCapabilitiesWrapper();
        }
        return this.clientWrapper;
    }

    public void toggleCapability(boolean enabled, String id, String capability, Object options) {
        if (enabled) {
            this.registerCapability(id, capability, options);
        } else {
            this.unregisterCapability(id, capability);
        }
    }

    public void unregisterCapability(String id, String method) {
        if (this.registeredCapabilities.remove(id)) {
            Unregistration unregistration = new Unregistration(id, method);
            UnregistrationParams unregistrationParams = new UnregistrationParams(Collections.singletonList(unregistration));
            this.languageClient.unregisterCapability(unregistrationParams);
        }
    }

    public void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    public void registerCapability(String id, String method, Object options) {
        if (this.registeredCapabilities.add(id)) {
            Registration registration = new Registration(id, method, options);
            RegistrationParams registrationParams = new RegistrationParams(Collections.singletonList(registration));
            this.languageClient.registerCapability(registrationParams);
        }
    }

    public void initializeCapabilities() {
        if (this.getClientCapabilities().isCodeActionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.CODE_ACTION_ID, "textDocument/codeAction", ServerCapabilitiesConstants.DEFAULT_CODEACTION_OPTIONS);
        }
        if (this.getClientCapabilities().isCompletionDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.COMPLETION_ID, "textDocument/completion", ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        if (this.getClientCapabilities().isDocumentHighlightDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DOCUMENT_HIGHLIGHT_ID, "textDocument/documentHighlight");
        }
        if (this.getClientCapabilities().isRangeFoldingDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.FOLDING_RANGE_ID, "textDocument/foldingRange");
        }
        if (this.getClientCapabilities().isHoverDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.HOVER_ID, "textDocument/hover");
        }
        if (this.getClientCapabilities().isLinkDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.LINK_ID, "textDocument/documentLink", ServerCapabilitiesConstants.DEFAULT_LINK_OPTIONS);
        }
        if (this.getClientCapabilities().isColorDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.COLOR_ID, "textDocument/documentColor", ServerCapabilitiesConstants.DEFAULT_COLOR_OPTIONS);
        }
        if (this.getClientCapabilities().isRenameDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.RENAME_ID, "textDocument/rename", ServerCapabilitiesConstants.DEFAULT_RENAME_OPTIONS);
        }
        if (this.getClientCapabilities().isDefinitionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.DEFINITION_ID, "textDocument/definition");
        }
        if (this.getClientCapabilities().isDefinitionDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.TYPEDEFINITION_ID, "textDocument/typeDefinition");
        }
        if (this.getClientCapabilities().isReferencesDynamicRegistrationSupported()) {
            this.registerCapability(ServerCapabilitiesConstants.REFERENCES_ID, "textDocument/references");
        }
        if (this.getClientCapabilities().isLinkedEditingRangeDynamicRegistered()) {
            this.registerCapability(ServerCapabilitiesConstants.LINKED_EDITING_RANGE_ID, "textDocument/linkedEditingRange");
        }
        if (this.getClientCapabilities().isDidChangeWatchedFilesRegistered()) {
            this.registerWatchedFiles();
        }
        this.syncDynamicCapabilitiesWithPreferences();
    }

    private void registerWatchedFiles() {
        ArrayList<FileSystemWatcher> watchers = new ArrayList<FileSystemWatcher>(2);
        watchers.add(new FileSystemWatcher(Either.forLeft("**/*.xsd")));
        watchers.add(new FileSystemWatcher(Either.forLeft("**/*.dtd")));
        watchers.add(new FileSystemWatcher(Either.forLeft("**/*.rng")));
        watchers.add(new FileSystemWatcher(Either.forLeft("**/*.rnc")));
        DidChangeWatchedFilesRegistrationOptions options = new DidChangeWatchedFilesRegistrationOptions(watchers);
        this.registerCapability(ServerCapabilitiesConstants.WORKSPACE_WATCHED_FILES_ID, "workspace/didChangeWatchedFiles", options);
    }

    public void registerExecuteCommand(List<String> commands) {
        this.registerCapability(ServerCapabilitiesConstants.WORKSPACE_EXECUTE_COMMAND_ID, "workspace/executeCommand", new ExecuteCommandOptions(commands));
    }

    public void syncDynamicCapabilitiesWithPreferences() {
        XMLFormattingOptions formattingPreferences = this.textDocumentService.getSharedFormattingSettings();
        if (this.getClientCapabilities().isFormattingDynamicRegistrationSupported()) {
            this.toggleCapability(formattingPreferences.isEnabled(), ServerCapabilitiesConstants.FORMATTING_ID, "textDocument/formatting", null);
        }
        if (this.getClientCapabilities().isRangeFormattingDynamicRegistrationSupported()) {
            this.toggleCapability(formattingPreferences.isEnabled(), ServerCapabilitiesConstants.FORMATTING_RANGE_ID, "textDocument/rangeFormatting", null);
        }
        if (this.getClientCapabilities().isSelectionRangeDynamicRegistered()) {
            this.toggleCapability(true, ServerCapabilitiesConstants.SELECTION_RANGE_ID, "textDocument/selectionRange", null);
        }
        XMLSymbolSettings symbolSettings = this.textDocumentService.getSharedSymbolSettings();
        if (this.getClientCapabilities().isDocumentSymbolDynamicRegistrationSupported()) {
            this.toggleCapability(symbolSettings.isEnabled(), ServerCapabilitiesConstants.DOCUMENT_SYMBOL_ID, "textDocument/documentSymbol", null);
        }
        XMLCodeLensSettings codeLensSettings = this.textDocumentService.getSharedCodeLensSettings();
        if (this.getClientCapabilities().isCodeLensDynamicRegistrationSupported()) {
            this.toggleCapability(codeLensSettings.isEnabled(), ServerCapabilitiesConstants.CODE_LENS_ID, "textDocument/codeLens", null);
        }
    }

    public Set<String> getRegisteredCapabilities() {
        return this.registeredCapabilities;
    }
}

