/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.util.ArrayList;
import org.eclipse.birt.core.framework.jar.Bundle;
import org.eclipse.birt.core.framework.jar.ConfigurationElement;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public class ExtensionPoint
implements IExtensionPoint {
    protected Bundle bundle;
    protected String uniqueId;
    protected String namespace;
    protected String name;
    protected ConfigurationElement[] allExtConfigurations;
    protected String schema;

    ExtensionPoint(Bundle bundle, String id) {
        this.bundle = bundle;
        int dotAt = id.lastIndexOf(46);
        if (dotAt == -1) {
            this.namespace = bundle.getSymbolicName();
            this.name = id;
            if (id.length() != 0) {
                this.uniqueId = String.valueOf(this.namespace) + "." + id;
            }
        } else {
            this.uniqueId = id;
            this.name = id.substring(dotAt + 1);
            this.namespace = id.substring(0, dotAt);
        }
    }

    public IConfigurationElement[] getConfigurationElements() {
        if (this.allExtConfigurations == null) {
            ArrayList<IConfigurationElement> extConfigList = new ArrayList<IConfigurationElement>();
            IExtension[] extensions = this.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] extConfigurations = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < extConfigurations.length) {
                    extConfigList.add(extConfigurations[j]);
                    ++j;
                }
                ++i;
            }
            this.allExtConfigurations = extConfigList.toArray(new ConfigurationElement[extConfigList.size()]);
        }
        return this.allExtConfigurations;
    }

    public String getLabel() {
        return null;
    }

    public String getLabel(String locale) throws InvalidRegistryObjectException {
        return null;
    }

    public String getSchemaReference() {
        return this.schema;
    }

    public String getUniqueIdentifier() {
        return this.uniqueId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.uniqueId);
        sb.append(" from ");
        sb.append(this.bundle.getSymbolicName());
        return sb.toString();
    }

    public IContributor getContributor() throws InvalidRegistryObjectException {
        return this.bundle.getContributor();
    }

    public IExtension getExtension(String extensionId) throws InvalidRegistryObjectException {
        return this.bundle.platform.extensionRegistry.getExtension(this.uniqueId, extensionId);
    }

    public IExtension[] getExtensions() throws InvalidRegistryObjectException {
        return this.bundle.platform.extensionRegistry.getExtensions(this.uniqueId);
    }

    public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
        return this.bundle.getSymbolicName();
    }

    public String getSimpleIdentifier() throws InvalidRegistryObjectException {
        return this.name;
    }

    public boolean isValid() {
        return true;
    }
}

