/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.palette;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.gef.ui.palette.customize.PaletteCustomizerEx;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.description.tool.ToolGroup;
import org.eclipse.sirius.diagram.description.tool.ToolGroupExtension;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.tools.api.management.ToolFilter;
import org.eclipse.sirius.diagram.tools.api.management.ToolManagement;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.PaletteManager;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.ConnectionCreationTool;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.CreationToolPaletteFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.GenericConnectionCreationTool;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.PaletteImageProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.SectionPaletteDrawer;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.SiriusDiagramPaletteFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.ToolGroupPaletteStack;
import org.eclipse.sirius.viewpoint.ToolGroupInstance;
import org.eclipse.sirius.viewpoint.ToolInstance;
import org.eclipse.sirius.viewpoint.ToolSectionInstance;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class PaletteManagerImpl
implements PaletteManager {
    private static PaletteImageProvider paletteImageProvider = new PaletteImageProvider();
    private EditDomain editDomain;
    private PaletteRoot paletteRoot;
    private boolean isDisposed;

    public PaletteManagerImpl(EditDomain editDomain) {
        this.editDomain = editDomain;
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
    }

    @Override
    public void addToolFilter(ToolFilter toolFilter) {
    }

    @Override
    public void removeToolFilter(ToolFilter toolFilter) {
    }

    @Override
    public void update(DDiagram dDiagram) {
        this.update(dDiagram, false);
    }

    @Override
    public void update(final DDiagram dDiagram, final boolean clean) {
        if (dDiagram != null) {
            this.initPaletteRoot();
            if (Display.getCurrent() != null) {
                this.updatePalette(dDiagram, clean);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PaletteManagerImpl.this.updatePalette(dDiagram, clean);
                    }
                });
            }
        }
    }

    private void updatePalette(DDiagram diagram, boolean clean) {
        this.initPaletteRoot();
        if (this.paletteRoot != null && clean && !this.paletteRoot.getChildren().isEmpty()) {
            PaletteContainer defaultTools = this.paletteRoot.getDefaultEntry().getParent();
            ArrayList children = new ArrayList(this.paletteRoot.getChildren());
            for (PaletteEntry child : children) {
                if (child == defaultTools) continue;
                this.paletteRoot.remove(child);
            }
        }
        this.updatePalette(diagram);
        this.paletteRoot = null;
    }

    private void initPaletteRoot() {
        PaletteViewer viewer = this.editDomain.getPaletteViewer();
        this.paletteRoot = viewer != null ? viewer.getPaletteRoot() : (PaletteRoot)ReflectionHelper.getFieldValueWithoutException((Object)this.editDomain, (String)"paletteRoot").get();
    }

    private void updatePalette(DDiagram dDiagram) {
        if (dDiagram != null) {
            DiagramDescription description = dDiagram.getDescription();
            Session session = null;
            if (dDiagram instanceof DSemanticDiagram) {
                session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)dDiagram).getTarget());
            }
            this.addDefaultTools(dDiagram);
            this.replaceNoteAttachmentCreationToolIfNeeded();
            if (session != null && description != null && description.eResource() != null && !description.eIsProxy()) {
                this.updatePalette(description, session, dDiagram);
                PaletteViewer paletteViewer = this.editDomain.getPaletteViewer();
                if (paletteViewer != null) {
                    Optional.ofNullable((PaletteCustomizerEx)paletteViewer.getCustomizer()).ifPresent(custo -> custo.applyCustomizationsToPalette(this.paletteRoot));
                }
            }
        }
    }

    private void addGenericConnectionTool() {
        PaletteToolEntry paletteEntry = new PaletteToolEntry("GenericConnectionCreationTool", Messages.GenericConnectionCreationTool_label, (PaletteFactory)new SiriusDiagramPaletteFactory());
        paletteEntry.setToolClass(GenericConnectionCreationTool.class);
        ImageDescriptor descIcon = DiagramUIPlugin.Implementation.findImageDescriptor("icons/full/obj16/EdgeCreationDescription.gif");
        paletteEntry.setSmallIcon(descIcon);
        paletteEntry.setLargeIcon(descIcon);
        PaletteContainer container = this.paletteRoot.getDefaultEntry().getParent();
        container.add((PaletteEntry)paletteEntry);
    }

    private void updatePalette(DiagramDescription description, Session session, DDiagram dDiagram) {
        if (LayerService.withoutLayersMode((DiagramDescription)description)) {
            this.updatePaletteForDiagramWithoutLayer(description, session, dDiagram);
        } else {
            this.updatePaletteForDiagramWithLayer(description, session, dDiagram);
        }
    }

    private void updatePaletteForDiagramWithoutLayer(DiagramDescription description, Session session, DDiagram dDiagram) {
        String name = PaletteManagerImpl.getLabel((IdentifiedElement)description);
        String id = PaletteManagerImpl.getHashLabel((IdentifiedElement)description);
        Optional<PaletteGroup> descGroup = this.getPaletteEntry((PaletteContainer)this.paletteRoot, id, PaletteGroup.class);
        if (!descGroup.isPresent()) {
            descGroup = Optional.of(new PaletteGroup(id, name));
            this.paletteRoot.add((PaletteEntry)descGroup.get());
        }
        List vsmTools = dDiagram.getUiState().getToolSections().stream().flatMap(section -> section.getTools().stream()).collect(Collectors.toList());
        this.updateContainer(session, dDiagram, (PaletteContainer)descGroup.get(), vsmTools);
    }

    private static String getLabel(IdentifiedElement element) {
        return new IdentifiedElementQuery(element).getLabel();
    }

    private void updatePaletteForDiagramWithLayer(DiagramDescription description, Session session, DDiagram dDiagram) {
        for (ToolSectionInstance sectionInstance : dDiagram.getUiState().getToolSections()) {
            if ("defaultSectionId".equals(sectionInstance.getId())) continue;
            Optional<SectionPaletteDrawer> paletteEntry = this.getPaletteEntry((PaletteContainer)this.paletteRoot, PaletteManagerImpl.getHashLabel((IdentifiedElement)((ToolSection)sectionInstance.getSection())), SectionPaletteDrawer.class);
            EList toolInstances = sectionInstance.getTools();
            if (!paletteEntry.isPresent()) {
                PaletteContainer container = PaletteManagerImpl.createPaletteDrawner((ToolSection)sectionInstance.getSection());
                this.updateContainer(session, dDiagram, container, (List<? extends ToolInstance>)toolInstances);
                this.paletteRoot.add((PaletteEntry)container);
                continue;
            }
            this.updateContainer(session, dDiagram, (PaletteContainer)paletteEntry.get(), (List<? extends ToolInstance>)toolInstances);
        }
        for (Layer layer : new ArrayList(DiagramPlugin.getPlugin().getToolManagement(dDiagram).getDeactivatedLayersAndAllLayersOfDeselectedViewpoints())) {
            this.setLayerVisibility(layer, false);
        }
        for (Layer layer : new ArrayList(DiagramPlugin.getPlugin().getToolManagement(dDiagram).getActivatedLayersOfSelectedViewpoints())) {
            this.setLayerVisibility(layer, true);
        }
    }

    private <T extends PaletteEntry> Optional<T> getPaletteEntry(PaletteContainer container, String id, Class<T> type) {
        Optional<Object> matchingPaletteEntry = Optional.empty();
        List children = container.getChildren();
        List<PaletteEntry> matchingPaletteEntries = children.stream().filter(type::isInstance).map(type::cast).filter(paletteEntry -> id.equals(paletteEntry.getId())).toList();
        if (!matchingPaletteEntries.isEmpty()) {
            if (matchingPaletteEntries.size() > 1) {
                List<String> labelEntries = matchingPaletteEntries.stream().map(PaletteEntry::getLabel).toList();
                String formatedEntries = String.join((CharSequence)", ", labelEntries);
                DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.PaletteManagerImpl_severalCandidatesInPalette, type.getName(), formatedEntries));
            }
            matchingPaletteEntry = matchingPaletteEntries.stream().findFirst();
        } else {
            matchingPaletteEntry = Optional.empty();
        }
        return matchingPaletteEntry;
    }

    private void replaceNoteAttachmentCreationToolIfNeeded() {
        CreationToolEntry noteAttachment;
        String notesContainerLabel = Platform.getResourceString((Bundle)DiagramUIPlugin.getInstance().getBundle(), (String)"%NoteStack.Label");
        PaletteContainer notesContainer = this.getPaletteContainer((PaletteContainer)this.paletteRoot, notesContainerLabel);
        if (notesContainer != null && !((noteAttachment = this.getNoteAttachementToolEntry(notesContainer)).getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY) instanceof SiriusDiagramPaletteFactory)) {
            SiriusDiagramPaletteFactory viewpointDiagramPaletteFactory = new SiriusDiagramPaletteFactory();
            PaletteToolEntry paletteEntry = new PaletteToolEntry(noteAttachment.getId(), noteAttachment.getLabel(), (PaletteFactory)viewpointDiagramPaletteFactory);
            paletteEntry.setToolProperty(CreationTool.PROPERTY_CREATION_FACTORY, (Object)viewpointDiagramPaletteFactory);
            paletteEntry.setDescription(noteAttachment.getDescription());
            paletteEntry.setLargeIcon(noteAttachment.getLargeIcon());
            paletteEntry.setSmallIcon(noteAttachment.getSmallIcon());
            notesContainer.add(notesContainer.getChildren().indexOf(noteAttachment), (PaletteEntry)paletteEntry);
            notesContainer.remove((PaletteEntry)noteAttachment);
        }
    }

    private CreationToolEntry getNoteAttachementToolEntry(PaletteContainer container) {
        String noteAttachmentToolLabel = Platform.getResourceString((Bundle)DiagramUIPlugin.getInstance().getBundle(), (String)"%NoteAttachmentTool.Label");
        for (PaletteEntry child : container.getChildren()) {
            CreationToolEntry paletteToolEntry;
            if (!(child instanceof CreationToolEntry) || !noteAttachmentToolLabel.equals((paletteToolEntry = (CreationToolEntry)child).getLabel())) continue;
            return paletteToolEntry;
        }
        return null;
    }

    private PaletteContainer getPaletteContainer(PaletteContainer container, String searchedLabel) {
        PaletteContainer result = null;
        if (container != null) {
            for (PaletteEntry child : container.getChildren()) {
                if (child instanceof PaletteContainer) {
                    PaletteContainer paletteContainer = (PaletteContainer)child;
                    result = searchedLabel.equals(paletteContainer.getLabel()) ? (PaletteContainer)child : this.getPaletteContainer(paletteContainer, searchedLabel);
                }
                if (result != null) break;
            }
        }
        return result;
    }

    @Override
    public void hideLayer(Layer layer) {
    }

    @Override
    public void showLayer(Layer layer) {
    }

    private void setLayerVisibility(Layer layer, boolean visibility) {
        EList sections = layer.getToolSections();
        List children = this.paletteRoot.getChildren();
        List sectionDrawers = children.stream().filter(SectionPaletteDrawer.class::isInstance).map(SectionPaletteDrawer.class::cast).collect(Collectors.toList());
        for (SectionPaletteDrawer sectionDrawer : sectionDrawers) {
            this.setToolSectionsVisibility(layer, sectionDrawer, (Collection<ToolSection>)sections, visibility);
            if (sectionDrawer.getChildren().isEmpty()) {
                sectionDrawer.setVisible(false);
                continue;
            }
            if (!visibility && sectionDrawer.isEmptyOfContributors()) {
                sectionDrawer.setVisible(false);
                continue;
            }
            if (!visibility || sectionDrawer.isEmptyOfContributors()) continue;
            sectionDrawer.setVisible(true);
        }
    }

    private void setToolSectionsVisibility(Layer layer, SectionPaletteDrawer drawer, Collection<ToolSection> sections, boolean visibility) {
        for (ToolSection section : sections) {
            if (drawer.getId().equals(PaletteManagerImpl.getHashLabel((IdentifiedElement)section))) {
                if (visibility && PaletteManagerImpl.isSectionNotEmpty(section)) {
                    drawer.addLayer(layer);
                } else {
                    drawer.removeLayer(layer);
                }
            }
            PaletteManagerImpl.setToolsVisibility(drawer, layer, section, visibility);
        }
    }

    private static boolean isSectionNotEmpty(ToolSection toolSection) {
        boolean result = !toolSection.getOwnedTools().isEmpty();
        result = result || !toolSection.getReusedTools().isEmpty();
        Iterator iterator = toolSection.getSubSections().iterator();
        while (!result && iterator.hasNext()) {
            ToolSection subSection = (ToolSection)iterator.next();
            result = PaletteManagerImpl.isSectionNotEmpty(subSection);
        }
        return result;
    }

    private static void setToolsVisibility(PaletteDrawer drawner, Layer layer, ToolSection section, boolean visibility) {
        for (PaletteEntry entry : drawner.getChildren()) {
            if (entry instanceof ToolGroupPaletteStack) {
                ToolGroupPaletteStack stack = (ToolGroupPaletteStack)entry;
                PaletteManagerImpl.setPaletteStackVisibility(stack, layer, (Collection<? extends ToolEntry>)section.getOwnedTools(), visibility);
                PaletteManagerImpl.setPaletteStackVisibility(stack, layer, (Collection<? extends ToolEntry>)section.getReusedTools(), visibility);
                for (ToolGroupExtension groupExtension : section.getGroupExtensions()) {
                    if (!stack.getId().equals(ToolManagement.getId((EObject)groupExtension.getGroup()))) continue;
                    if (visibility) {
                        stack.addLayer(layer);
                    } else {
                        stack.removeLayer(layer);
                    }
                    for (PaletteEntry subEntry : stack.getChildren()) {
                        PaletteManagerImpl.setPaletteEntryVisibility(subEntry, (Collection<? extends ToolEntry>)groupExtension.getTools(), visibility);
                    }
                }
                if (!visibility && stack.isEmptyOfContributors()) {
                    stack.setVisible(false);
                    continue;
                }
                if (!visibility || stack.isEmptyOfContributors()) continue;
                stack.setVisible(true);
                continue;
            }
            PaletteManagerImpl.setPaletteEntryVisibility(entry, (Collection<? extends ToolEntry>)section.getOwnedTools(), visibility);
            PaletteManagerImpl.setPaletteEntryVisibility(entry, (Collection<? extends ToolEntry>)section.getReusedTools(), visibility);
        }
    }

    private static void setPaletteStackVisibility(ToolGroupPaletteStack stack, Layer layer, Collection<? extends ToolEntry> toolEntries, boolean visibility) {
        for (ToolEntry toolEntry : toolEntries) {
            if (!(toolEntry instanceof ToolGroup) || !stack.getId().equals(ToolManagement.getId((EObject)toolEntry))) continue;
            if (visibility) {
                stack.addLayer(layer);
                continue;
            }
            stack.removeLayer(layer);
        }
    }

    private static void setPaletteEntryVisibility(PaletteEntry entry, Collection<? extends ToolEntry> toolEntries, boolean visibility) {
        for (ToolEntry toolEntry : toolEntries) {
            if (!entry.getId().equals(ToolManagement.getId((EObject)toolEntry))) continue;
            entry.setVisible(visibility);
        }
    }

    private static String getHashLabel(IdentifiedElement element) {
        String toolSectionLabel = PaletteManagerImpl.getLabel(element);
        return ToolManagement.hash((byte[])toolSectionLabel.getBytes());
    }

    private void addDefaultTools(DDiagram diagram) {
        PaletteContainer container = this.paletteRoot.getDefaultEntry().getParent();
        for (Object entry : container.getChildren()) {
            if (!(entry instanceof PaletteSeparator) || !"defaultTools".equals(((PaletteSeparator)entry).getId())) continue;
            return;
        }
        PaletteSeparator marker = new PaletteSeparator("defaultTools");
        marker.setVisible(false);
        container.add((PaletteEntry)marker);
        if (Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_DISPLAY_GENERIC_EDGE_CREATION_TOOL.name(), false, null)) {
            this.addGenericConnectionTool();
        }
        for (ToolSectionInstance toolSectionInstance : diagram.getUiState().getToolSections()) {
            if (!"defaultSectionId".equals(toolSectionInstance.getId())) continue;
            EList tools = toolSectionInstance.getTools();
            for (ToolInstance toolInstance : tools) {
                if (!"GenericConnectionCreationTool".equals(toolInstance.getId()) && !"Pinning".equals(toolInstance.getId())) continue;
                this.addElementToContainer(container, toolInstance.getToolEntry());
            }
        }
    }

    private static PaletteContainer createPaletteDrawner(ToolSection section) {
        ImageDescriptor descIcon;
        String name = MessageTranslator.INSTANCE.getMessage((EObject)section, PaletteManagerImpl.getLabel((IdentifiedElement)section));
        String iconPath = section.getIcon();
        SectionPaletteDrawer paletteDrawner = new SectionPaletteDrawer(name);
        paletteDrawner.setId(PaletteManagerImpl.getHashLabel((IdentifiedElement)section));
        if (StringUtil.isEmpty((String)iconPath)) {
            iconPath = "icons/obj16/ToolSection.gif";
        }
        if ((descIcon = DiagramUIPlugin.Implementation.findImageDescriptor(iconPath)) != null) {
            paletteDrawner.setSmallIcon(descIcon);
        }
        return paletteDrawner;
    }

    protected void updateContainer(Session session, DDiagram dDiagram, PaletteContainer container, List<? extends ToolInstance> toolEntries) {
        for (ToolInstance toolInstance : toolEntries) {
            ToolEntry toolEntry = toolInstance.getToolEntry();
            if (toolEntry instanceof AbstractToolDescription) {
                Optional<PaletteEntry> paletteEntry = this.getPaletteEntry(container, toolInstance.getId(), PaletteEntry.class);
                if (!toolInstance.isFiltered()) {
                    this.addElementToContainer(container, toolEntry, paletteEntry);
                    continue;
                }
                paletteEntry.ifPresent(arg_0 -> ((PaletteContainer)container).remove(arg_0));
                continue;
            }
            if (!(toolInstance instanceof ToolGroupInstance)) continue;
            Optional<ToolGroupPaletteStack> paletteStack = this.getPaletteEntry(container, toolInstance.getId(), ToolGroupPaletteStack.class);
            boolean paletteWasCreated = false;
            if (!paletteStack.isPresent()) {
                paletteStack = Optional.of(new ToolGroupPaletteStack(((ToolGroup)toolEntry).getName()));
                paletteWasCreated = true;
            }
            for (ToolInstance siriusToolChild : ((ToolGroupInstance)toolInstance).getTools()) {
                Optional<PaletteEntry> paletteEntry = this.getPaletteEntry((PaletteContainer)paletteStack.get(), siriusToolChild.getId(), PaletteEntry.class);
                if (!siriusToolChild.isFiltered()) {
                    this.addElementToContainer((PaletteContainer)paletteStack.get(), siriusToolChild.getToolEntry(), paletteEntry);
                    continue;
                }
                if (!paletteEntry.isPresent()) continue;
                paletteStack.get().remove(paletteEntry.get());
                if (!paletteStack.get().getChildren().isEmpty()) continue;
                container.remove((PaletteEntry)paletteStack.get());
            }
            if (!paletteWasCreated || paletteStack.get().getChildren().isEmpty()) continue;
            paletteStack.get().setId(toolInstance.getId());
            container.add((PaletteEntry)paletteStack.get());
        }
    }

    protected void addElementToContainer(PaletteContainer container, ToolEntry toolEntry) {
        this.addElementToContainer(container, toolEntry, Optional.empty());
    }

    protected void addElementToContainer(PaletteContainer container, ToolEntry toolEntry, Optional<PaletteEntry> existingPaletteEntry) {
        if (toolEntry instanceof ToolGroup) {
            ToolGroupPaletteStack paletteStack;
            String newName = this.isFromDiagramEnvironment(toolEntry) ? MessageTranslator.INSTANCE.getMessage(DiagramPlugin.getPlugin().getBundle(), PaletteManagerImpl.getLabel((IdentifiedElement)toolEntry)) : MessageTranslator.INSTANCE.getMessage((EObject)toolEntry, PaletteManagerImpl.getLabel((IdentifiedElement)toolEntry));
            if (existingPaletteEntry.isEmpty()) {
                paletteStack = new ToolGroupPaletteStack(newName);
                paletteStack.setId(ToolManagement.getId((EObject)toolEntry));
                container.add((PaletteEntry)paletteStack);
            } else if (existingPaletteEntry.get() instanceof PaletteStack) {
                paletteStack = (PaletteStack)existingPaletteEntry.get();
            } else {
                throw new IllegalArgumentException(MessageFormat.format(Messages.PaletteManagerImpl_alreadyExistingEntry, newName));
            }
            for (AbstractToolDescription tool : ((ToolGroup)toolEntry).getTools()) {
                Optional<PaletteEntry> paletteEntry = this.getPaletteEntry((PaletteContainer)paletteStack, ToolManagement.getId((EObject)tool), PaletteEntry.class);
                this.addElementToContainer((PaletteContainer)paletteStack, (ToolEntry)tool, paletteEntry);
            }
        } else if (toolEntry instanceof AbstractToolDescription && existingPaletteEntry.isEmpty()) {
            String descriptionEntry;
            String nameEntry;
            AbstractToolDescription toolDescription = (AbstractToolDescription)toolEntry;
            ImageDescriptor imageEntry = paletteImageProvider.getImageDescriptor(toolDescription);
            if (this.isFromDiagramEnvironment((ToolEntry)toolDescription)) {
                nameEntry = MessageTranslator.INSTANCE.getMessage(DiagramPlugin.getPlugin().getBundle(), PaletteManagerImpl.getLabel((IdentifiedElement)toolDescription));
                descriptionEntry = MessageTranslator.INSTANCE.getMessage(DiagramPlugin.getPlugin().getBundle(), toolDescription.getDocumentation());
            } else {
                nameEntry = MessageTranslator.INSTANCE.getMessage((EObject)toolDescription, PaletteManagerImpl.getLabel((IdentifiedElement)toolDescription));
                descriptionEntry = MessageTranslator.INSTANCE.getMessage((EObject)toolDescription, toolDescription.getDocumentation());
            }
            PaletteToolBasedCreationFactory creationFactory = new PaletteToolBasedCreationFactory(toolDescription);
            ConnectionCreationToolEntry paletteEntry = null;
            if (toolDescription instanceof EdgeCreationDescription) {
                paletteEntry = new ConnectionCreationToolEntry(nameEntry, descriptionEntry, (CreationFactory)creationFactory, imageEntry, imageEntry);
                paletteEntry.setToolClass(ConnectionCreationTool.class);
            } else if (this.requiresPaletteToolEntry(toolDescription)) {
                paletteEntry = this.createPaletteToolEntry(nameEntry, descriptionEntry, creationFactory, imageEntry);
            }
            if (paletteEntry != null) {
                paletteEntry.setId(ToolManagement.getId((EObject)toolDescription));
                container.add((PaletteEntry)paletteEntry);
            }
        }
    }

    private boolean isFromDiagramEnvironment(ToolEntry toolEntry) {
        URI uri;
        boolean result = false;
        Resource eResource = toolEntry.eResource();
        if (eResource != null && (uri = eResource.getURI()) != null) {
            result = uri.toString().equals("environment:/diagram");
        }
        return result;
    }

    private boolean requiresPaletteToolEntry(AbstractToolDescription toolDescription) {
        boolean result = false;
        if (toolDescription instanceof NodeCreationDescription) {
            result = true;
        } else if (toolDescription instanceof ContainerCreationDescription) {
            result = true;
        } else if (toolDescription instanceof RequestDescription) {
            result = true;
        } else if (toolDescription instanceof SelectionWizardDescription) {
            result = true;
        } else if (toolDescription instanceof PaneBasedSelectionWizardDescription) {
            result = true;
        } else if (toolDescription instanceof ToolDescription) {
            result = true;
        }
        return result;
    }

    private PaletteToolEntry createPaletteToolEntry(String nameEntry, String descriptionEntry, CreationFactory creationFactory, ImageDescriptor imageEntry) {
        CreationToolPaletteFactory paletteFactory = new CreationToolPaletteFactory(creationFactory);
        PaletteToolEntry creationToolEntry = new PaletteToolEntry(nameEntry, descriptionEntry, (PaletteFactory)paletteFactory);
        creationToolEntry.setLabel(nameEntry);
        creationToolEntry.setDescription(descriptionEntry);
        creationToolEntry.setSmallIcon(imageEntry);
        creationToolEntry.setLargeIcon(imageEntry);
        creationToolEntry.setToolProperty(CreationTool.PROPERTY_CREATION_FACTORY, (Object)creationFactory);
        creationToolEntry.setToolClass(CreationTool.class);
        return creationToolEntry;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    private static class PaletteGroup
    extends org.eclipse.gef.palette.PaletteGroup {
        PaletteGroup(String id, String label) {
            super(label);
            this.setId(id);
        }
    }

    private static class PaletteToolBasedCreationFactory
    implements CreationFactory {
        private AbstractToolDescription toolDescription;

        PaletteToolBasedCreationFactory(AbstractToolDescription toolDescription) {
            this.toolDescription = toolDescription;
        }

        public Object getObjectType() {
            return this.toolDescription.getClass();
        }

        public Object getNewObject() {
            return this.toolDescription;
        }
    }
}

