/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.wizards.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FragmentMergeHelper {
    public static void merge(MModelFragments sourceFragments, MModelFragments targetFragments) {
        targetFragments.getFragments().addAll(sourceFragments.getFragments());
        ArrayList sourceImports = new ArrayList();
        FragmentMergeHelper.consolidateImports(targetFragments);
        sourceImports.addAll(sourceFragments.getImports());
        for (MApplicationElement sourceImport : sourceImports) {
            boolean doImport = true;
            for (MApplicationElement targetImport : targetFragments.getImports()) {
                if (!FragmentMergeHelper.haveSameID(sourceImport, targetImport)) continue;
                doImport = false;
                FragmentMergeHelper.changeReferenceToExistingElement(targetFragments.getFragments(), targetImport, sourceImport);
                break;
            }
            if (!doImport) continue;
            targetFragments.getImports().add(sourceImport);
        }
    }

    private static void consolidateImports(MModelFragments targetFragments) {
        List fragments = targetFragments.getFragments();
        for (MModelFragment fragment : fragments) {
            List elements = fragment.getElements();
            for (MApplicationElement element : elements) {
                MApplicationElement previousImport = FragmentMergeHelper.getPreviousImport(element, targetFragments);
                if (previousImport == null) continue;
                FragmentMergeHelper.changeReferenceToExistingElement(targetFragments.getFragments(), element, previousImport);
            }
        }
    }

    private static MApplicationElement getPreviousImport(MApplicationElement element, MModelFragments targetFragments) {
        List imports = targetFragments.getImports();
        for (MApplicationElement imported : imports) {
            if (!FragmentMergeHelper.haveSameID(element, imported)) continue;
            return imported;
        }
        return null;
    }

    private static void changeReferenceToExistingElement(List<MModelFragment> fragments, MApplicationElement target, MApplicationElement source) {
        Collection settings = EcoreUtil.UsageCrossReferencer.find((EObject)((EObject)source), fragments);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature().isMany()) {
                List list = (List)setting.getEObject().eGet(setting.getEStructuralFeature());
                list.remove(source);
                list.add(target);
                continue;
            }
            setting.getEObject().eSet(setting.getEStructuralFeature(), (Object)target);
        }
        EcoreUtil.delete((EObject)((EObject)source));
    }

    public static boolean haveSameID(MApplicationElement firstElement, MApplicationElement secondElement) {
        if (firstElement.getElementId() == null || secondElement.getElementId() == null) {
            return false;
        }
        if (firstElement.getElementId().isEmpty() || secondElement.getElementId().isEmpty()) {
            return false;
        }
        return firstElement.getElementId().equals(secondElement.getElementId());
    }
}

