/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.shadows;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.ColorProvider;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.eclipse.pde.api.tools.annotations.NoReference;
import org.eclipse.swt.graphics.Color;

@NoExtend
@NoReference
@NoInstantiate
public abstract class AbstractDropShadowBorder
extends AbstractBackground {
    protected static final int DEFAULT_DROP_SHADOW_SIZE = 6;
    protected static final int DEFAULT_HALO_SIZE = 3;
    protected static final int DEFAULT_SHADOW_ALPHA = 25;
    protected static final double DEFAULT_SOFTNESS = 4.0;
    private static final Insets DEFAULT_SHADOW_INSETS = new Insets();
    private static final Rectangle CLIP_RECT_CACHE = new Rectangle();
    private int dropShadowSize = 6;
    private int haloSize = 3;
    private Insets insets = DEFAULT_SHADOW_INSETS;
    private int shadowAlpha = 25;
    private Color shadowColor = ColorProvider.SystemColorFactory.getColorProvider().getShadowColor();
    private double softness = 4.0;

    protected AbstractDropShadowBorder() {
    }

    protected int calcAlphaValue(double progress) {
        return Math.max(1, (int)((double)this.shadowAlpha * Math.exp(-this.softness * progress)));
    }

    @Override
    public Insets getInsets(IFigure figure) {
        return this.insets;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
        Color foregroundColor = graphics.getForegroundColor();
        int alpha = graphics.getAlpha();
        int lineWidth = graphics.getLineWidth();
        graphics.getClip(CLIP_RECT_CACHE);
        graphics.setForegroundColor(this.shadowColor);
        graphics.setLineWidth(2);
        Rectangle shadowRect = AbstractDropShadowBorder.getPaintRectangle(figure, this.getInsets(figure));
        this.updateClip(graphics, shadowRect);
        this.paintHalo(graphics, shadowRect, this.haloSize);
        this.paintDropShadow(graphics, shadowRect, this.dropShadowSize);
        graphics.setForegroundColor(foregroundColor);
        graphics.setAlpha(alpha);
        graphics.setLineWidth(lineWidth);
        graphics.clipRect(CLIP_RECT_CACHE);
    }

    protected abstract void paintDropShadow(Graphics var1, Rectangle var2, int var3);

    protected abstract void paintHalo(Graphics var1, Rectangle var2, int var3);

    public void setDropShadowSize(int dropShadowSize) {
        this.dropShadowSize = dropShadowSize;
    }

    public void setHaloSize(int haloSize) {
        this.haloSize = haloSize;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setShadowAlpha(int shadowAlpha) {
        this.shadowAlpha = shadowAlpha;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    public void setSoftness(double softness) {
        this.softness = softness;
    }

    private void updateClip(Graphics graphics, Rectangle shadowRect) {
        int shadowSize = Math.max(this.haloSize, this.dropShadowSize) + 1;
        shadowRect.expand(shadowSize, shadowSize);
        graphics.setClip(shadowRect);
        shadowRect.shrink(shadowSize, shadowSize);
    }
}

