/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ClipboardCompare
extends BaseCompareAction
implements IObjectActionDelegate {
    private final String clipboard = "Clipboard";
    private final String compareFailed = "Comparision Failed";
    private IWorkbenchPart activePart;

    @Override
    protected void run(ISelection selection) {
        IFile[] files = Utilities.getFiles(selection);
        Shell parentShell = CompareUIPlugin.getShell();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            try {
                this.processComparison(file, parentShell);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)parentShell, (String)"Comparision Failed", (String)e.getMessage());
            }
            ++n2;
        }
    }

    @Override
    protected boolean isEnabled(ISelection selection) {
        return Utilities.getFiles(selection).length == 1 && this.getClipboard() != null;
    }

    private void processComparison(IFile file, Shell parentShell) throws IOException, CoreException {
        CompareEditor existingCompare;
        ISelection selection;
        ITextEditor txtEditor;
        ISelection selection2;
        String cb = this.getClipboard().toString();
        String fileName = file.getName();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (this.activePart instanceof IViewPart) {
            String fileContents = new String(file.getContents().readAllBytes(), file.getCharset());
            this.showComparison(fileContents, fileName, cb, parentShell);
            return;
        }
        if (editor instanceof FormEditor) {
            FormEditor fromEditor = (FormEditor)editor;
            editor = fromEditor.getActiveEditor();
        }
        if (editor instanceof ITextEditor && (selection2 = (txtEditor = (ITextEditor)editor).getSelectionProvider().getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection2;
            String selectionContents = textSelection.getText();
            if (selectionContents.isEmpty()) {
                String fileContents = new String(file.getContents().readAllBytes(), file.getCharset());
                this.showComparison(fileContents, fileName, cb, parentShell);
            } else {
                this.showComparison(selectionContents, fileName, cb, parentShell);
            }
            return;
        }
        if (editor instanceof CompareEditor && (selection = (existingCompare = (CompareEditor)editor).getSite().getSelectionProvider().getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            String selectedText = textSelection.getText();
            String fileContents = new String(file.getContents().readAllBytes(), file.getCharset());
            this.showComparison(fileContents, fileName, selectedText, parentShell);
        }
    }

    private void showComparison(final String source, final String fileName, final String clipboardContents, Shell parentShell) {
        if (source == null) {
            MessageDialog.openInformation((Shell)parentShell, (String)"Comparision Failed", (String)"Failed to process selected file");
            return;
        }
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftLabel(fileName);
        config.setRightLabel("Clipboard");
        config.setLeftEditable(true);
        config.setRightEditable(true);
        CompareEditorInput compareInput = new CompareEditorInput(config){

            @Override
            protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                class ClipboardTypedElement
                implements ITypedElement,
                IEncodedStreamContentAccessor {
                    private final String name;
                    private final String content;

                    public ClipboardTypedElement(String name, String content) {
                        this.name = name;
                        this.content = content;
                    }

                    @Override
                    public String getName() {
                        return this.name;
                    }

                    @Override
                    public Image getImage() {
                        return null;
                    }

                    @Override
                    public String getType() {
                        return null;
                    }

                    @Override
                    public String getCharset() throws CoreException {
                        return "UTF-8";
                    }

                    @Override
                    public InputStream getContents() throws CoreException {
                        return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
                    }
                }
                return new DiffNode(new ClipboardTypedElement(fileName, source), new ClipboardTypedElement("Clipboard", clipboardContents));
            }
        };
        CompareUI.openCompareEditor(compareInput);
    }

    private Object getClipboard() {
        Clipboard clip = new Clipboard(Display.getDefault());
        try {
            Object object = clip.getContents((Transfer)TextTransfer.getInstance());
            return object;
        }
        finally {
            clip.dispose();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

