/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFixCore;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsRewriteOperations;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.NullAnnotationsCleanUpCore;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CreatePackageInfoWithDefaultNullnessProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ExtractToNullCheckedLocalProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MakeLocalVariableNonNullProposalCore;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public abstract class NullAnnotationsCorrectionProcessorCore<T> {
    protected final int CORRECTION_CHANGE = 1;

    public void getAddMissingDefaultNullnessProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        CompilationUnit astRoot = context.getASTRoot();
        if ("package-info.java".equals(astRoot.getJavaElement().getElementName())) {
            NullAnnotationsFixCore fix = NullAnnotationsFixCore.createAddMissingDefaultNullnessAnnotationsFix(astRoot, problem);
            Hashtable<String, String> options = new Hashtable<String, String>();
            FixCorrectionProposalCore proposal = new FixCorrectionProposalCore(fix, new NullAnnotationsCleanUpCore(options, problem.getProblemId()), 5, context);
            proposals.add(this.fixCorrectionProposalCoreToT(proposal, 1));
        } else {
            IPackageFragment pack = (IPackageFragment)astRoot.getJavaElement().getParent();
            String nonNullByDefaultAnnotationname = NullAnnotationsFixCore.getNonNullByDefaultAnnotationName((IJavaElement)pack, true);
            String label = Messages.format(CorrectionMessages.NullAnnotationsCorrectionProcessor_create_packageInfo_with_defaultnullness, new String[]{nonNullByDefaultAnnotationname});
            CreatePackageInfoWithDefaultNullnessProposalCore proposal = CreatePackageInfoWithDefaultNullnessProposalCore.createFor(problem.getProblemId(), label, pack);
            proposals.add(this.createPackageInfoWithDefaultNullnessProposalCoreToT(proposal, 1));
        }
    }

    public void getReturnAndArgumentTypeProposal(IInvocationContext context, IProblemLocation problem, NullAnnotationsRewriteOperations.ChangeKind changeKind, Collection<T> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        boolean isArgumentProblem = NullAnnotationsFixCore.isComplainingAboutArgument(selectedNode);
        if (isArgumentProblem || NullAnnotationsFixCore.isComplainingAboutReturn(selectedNode)) {
            this.getNullAnnotationInSignatureProposal(context, problem, proposals, changeKind, isArgumentProblem);
        }
    }

    public void getNullAnnotationInSignatureProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals, NullAnnotationsRewriteOperations.ChangeKind changeKind, boolean isArgumentProblem) {
        NullAnnotationsFixCore fix = NullAnnotationsFixCore.createNullAnnotationInSignatureFix(context.getASTRoot(), problem, changeKind, isArgumentProblem);
        if (fix != null) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (fix.getCu() != context.getASTRoot()) {
                final CompilationUnit cu = fix.getCu();
                final IInvocationContext originalContext = context;
                context = new IInvocationContext(){

                    @Override
                    public int getSelectionOffset() {
                        return originalContext.getSelectionOffset();
                    }

                    @Override
                    public int getSelectionLength() {
                        return originalContext.getSelectionLength();
                    }

                    @Override
                    public ASTNode getCoveringNode() {
                        return originalContext.getCoveringNode();
                    }

                    @Override
                    public ASTNode getCoveredNode() {
                        return originalContext.getCoveredNode();
                    }

                    @Override
                    public ICompilationUnit getCompilationUnit() {
                        return (ICompilationUnit)cu.getJavaElement();
                    }

                    @Override
                    public CompilationUnit getASTRoot() {
                        return cu;
                    }
                };
            }
            int relevance = changeKind == NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN ? 9 : 10;
            FixCorrectionProposalCore proposal = new FixCorrectionProposalCore(fix, new NullAnnotationsCleanUpCore(options, problem.getProblemId()), relevance, context);
            proposals.add(this.fixCorrectionProposalCoreToT(proposal, 1));
        }
    }

    public void getRemoveRedundantAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        NullAnnotationsFixCore fix = NullAnnotationsFixCore.createRemoveRedundantNullAnnotationsFix(context.getASTRoot(), problem);
        if (fix == null) {
            return;
        }
        Hashtable<String, String> options = new Hashtable<String, String>();
        FixCorrectionProposalCore proposal = new FixCorrectionProposalCore(fix, new NullAnnotationsCleanUpCore(options, problem.getProblemId()), 5, context);
        proposals.add(this.fixCorrectionProposalCoreToT(proposal, 1));
    }

    public void getExtractCheckedLocalProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        CompilationUnit compilationUnit = context.getASTRoot();
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        SimpleName name = NullAnnotationsCorrectionProcessorCore.findProblemFieldName(selectedNode, problem.getProblemId());
        if (name == null) {
            return;
        }
        MethodDeclaration method = ASTNodes.getParent(selectedNode, MethodDeclaration.class);
        if (method == null) {
            method = ASTNodes.getParent(selectedNode, Initializer.class);
        }
        if (method == null) {
            return;
        }
        ExtractToNullCheckedLocalProposalCore proposal = new ExtractToNullCheckedLocalProposalCore(cu, compilationUnit, name, (ASTNode)method);
        proposals.add(this.extractToNullCheckedLocalProposalCoreToT(proposal, 1));
    }

    private static SimpleName findProblemFieldName(ASTNode selectedNode, int problemID) {
        if (selectedNode instanceof FieldAccess) {
            selectedNode = ((FieldAccess)selectedNode).getName();
        } else if (selectedNode instanceof QualifiedName) {
            selectedNode = ((QualifiedName)selectedNode).getName();
        }
        if (selectedNode instanceof SimpleName) {
            SimpleName name = (SimpleName)selectedNode;
            if (problemID == 33555356) {
                return name;
            }
            IBinding binding = name.resolveBinding();
            if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
                return name;
            }
        }
        return null;
    }

    public void getLocalVariableAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        String nonNullAnnotationName = NullAnnotationsFixCore.getNonNullAnnotationName(astRoot.getJavaElement(), false);
        if (nonNullAnnotationName == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression nodeToCast = (Expression)selectedNode;
        IBinding callerBinding = Bindings.resolveExpressionBinding(nodeToCast, false);
        if (callerBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)callerBinding;
            if (variableBinding.isField()) {
                return;
            }
            ITypeBinding type = variableBinding.getType();
            if (type == null || type.isArray()) {
                return;
            }
            MakeLocalVariableNonNullProposalCore proposal = new MakeLocalVariableNonNullProposalCore(cu, variableBinding, astRoot, 10, nonNullAnnotationName);
            proposals.add(this.makeLocalVariableNonNullProposalCoreToT(proposal));
        }
    }

    protected abstract T makeLocalVariableNonNullProposalCoreToT(MakeLocalVariableNonNullProposalCore var1);

    protected abstract T extractToNullCheckedLocalProposalCoreToT(ExtractToNullCheckedLocalProposalCore var1, int var2);

    protected abstract T createPackageInfoWithDefaultNullnessProposalCoreToT(CreatePackageInfoWithDefaultNullnessProposalCore var1, int var2);

    protected abstract T fixCorrectionProposalCoreToT(FixCorrectionProposalCore var1, int var2);
}

