/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.ui.databinding.BaseDatabindingModel;

public class ImageRunNetworkModel
extends BaseDatabindingModel {
    public static final String NETWORK_MODE = "networkMode";
    public static final String DEFAULT_MODE = "";
    public static final String BRIDGE_MODE = "bridge";
    public static final String HOST_MODE = "host";
    public static final String NONE_MODE = "none";
    public static final String OTHER_MODE = "other";
    public static final String CONTAINER_MODE = "container";
    public static final String CONTAINER_NAMES = "containerNames";
    public static final String SELECTED_CONTAINER = "selectedContainer";
    public static final String OTHER_STRING = "otherString";
    private String networkMode;
    private IDockerConnection connection;
    private String selectedContainer;
    private String otherString;
    private List<String> containerNames = new ArrayList<String>();

    public ImageRunNetworkModel(IDockerConnection connection) {
        this.connection = connection;
        this.networkMode = DEFAULT_MODE;
        this.refreshContainerNames();
    }

    public ImageRunNetworkModel(IDockerImage selectedImage) {
        this.connection = selectedImage.getConnection();
        this.networkMode = DEFAULT_MODE;
        this.refreshContainerNames();
    }

    public void setConnection(IDockerConnection connection) {
        this.connection = connection;
        this.refreshContainerNames();
    }

    public void refreshContainerNames() {
        ArrayList<String> refreshedContainerNames = new ArrayList<String>();
        IDockerConnection connection = this.connection;
        if (connection != null && connection.isOpen()) {
            connection.getContainers().stream().filter(container -> EnumDockerStatus.fromStatusMessage((String)container.status()) == EnumDockerStatus.RUNNING).forEach(container -> refreshedContainerNames.add(container.name()));
            Collections.sort(refreshedContainerNames);
        }
        this.setContainerNames(refreshedContainerNames);
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public void setNetworkMode(String networkMode) {
        if (networkMode != null) {
            this.networkMode = networkMode;
            this.firePropertyChange(NETWORK_MODE, this.networkMode, this.networkMode);
        }
    }

    public String getNetworkModeString() {
        String mode = this.getNetworkMode();
        if (CONTAINER_MODE.equals(mode)) {
            return "container:" + this.getSelectedContainer();
        }
        if (OTHER_MODE.equals(mode)) {
            return this.getOtherString();
        }
        return mode;
    }

    public String getSelectedContainer() {
        return this.selectedContainer;
    }

    public void setSelectedContainer(String selectedContainer) {
        this.selectedContainer = selectedContainer;
        this.firePropertyChange(SELECTED_CONTAINER, this.selectedContainer, this.selectedContainer);
    }

    public String getOtherString() {
        return this.otherString;
    }

    public void setOtherString(String otherString) {
        this.otherString = otherString;
        this.firePropertyChange(OTHER_STRING, this.otherString, this.otherString);
    }

    public List<String> getContainerNames() {
        return this.containerNames;
    }

    public void setContainerNames(List<String> refreshedContainerNames) {
        this.containerNames = refreshedContainerNames;
        this.firePropertyChange(CONTAINER_NAMES, this.containerNames, this.containerNames);
    }
}

