/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractMesonCommandHandler
extends AbstractHandler {
    private IContainer fContainer;

    protected abstract void run(Shell var1);

    protected Object execute1(ExecutionEvent event) {
        Object obj;
        IContainer container;
        ISelection k = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!k.isEmpty() && k instanceof IStructuredSelection && (container = this.getContainer(obj = ((IStructuredSelection)k).getFirstElement())) != null) {
            this.setSelectedContainer(container);
            this.run(HandlerUtil.getActiveShell((ExecutionEvent)event));
        }
        return null;
    }

    protected IContainer getContainer(Object obj) {
        Collection c;
        Object[] objArray;
        IContainer fContainer = null;
        if (obj instanceof Collection && (objArray = (c = (Collection)obj).toArray()).length > 0) {
            obj = objArray[0];
        }
        if (obj instanceof ICElement) {
            if (obj instanceof ICContainer || obj instanceof ICProject) {
                fContainer = (IContainer)((ICElement)obj).getUnderlyingResource();
            } else if ((obj = ((ICElement)obj).getResource()) != null) {
                fContainer = ((IResource)obj).getParent();
            }
        } else {
            fContainer = obj instanceof IResource ? (obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent()) : null;
        }
        return fContainer;
    }

    protected void showError(String title, String content) {
        MessageDialog.openError((Shell)new Shell(), (String)title, (String)content);
    }

    protected List<String> separateTargets(String rawArgList) {
        StringTokenizer st = new StringTokenizer(rawArgList, " ");
        ArrayList<String> targetList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            StringBuilder tmpTarget;
            String currentWord = st.nextToken().trim();
            if (currentWord.startsWith("'")) {
                tmpTarget = new StringBuilder();
                while (!currentWord.endsWith("'")) {
                    tmpTarget.append(currentWord).append(' ');
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget.append(currentWord);
                targetList.add(tmpTarget.toString());
                continue;
            }
            if (currentWord.startsWith("\"")) {
                tmpTarget = new StringBuilder();
                while (!currentWord.endsWith("\"")) {
                    tmpTarget.append(currentWord).append(' ');
                    if (!st.hasMoreTokens()) {
                        return null;
                    }
                    currentWord = st.nextToken().trim();
                }
                tmpTarget.append(currentWord);
                targetList.add(tmpTarget.toString());
                continue;
            }
            targetList.add(currentWord);
        }
        return targetList;
    }

    protected List<String> separateOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        rawArgList = rawArgList.trim();
        boolean finished = false;
        int lastIndex = rawArgList.indexOf("--");
        if (lastIndex != -1) {
            while (!finished) {
                int index = rawArgList.indexOf("--", lastIndex + 2);
                if (index != -1) {
                    String previous = rawArgList.substring(lastIndex, index).trim();
                    argList.add(previous);
                    rawArgList = rawArgList.substring(index);
                    continue;
                }
                argList.add(rawArgList);
                finished = true;
            }
        }
        return argList;
    }

    protected List<String> simpleParseOptions(String rawArgList) {
        ArrayList<String> argList = new ArrayList<String>();
        int lastArgIndex = -1;
        int i = 0;
        while (i < rawArgList.length()) {
            char ch = rawArgList.charAt(i);
            while (Character.isWhitespace(ch)) {
                if (++i < rawArgList.length()) {
                    ch = rawArgList.charAt(i);
                    continue;
                }
                return argList;
            }
            lastArgIndex = i;
            boolean inString = false;
            while (i < rawArgList.length()) {
                ch = rawArgList.charAt(i);
                if (ch == '\\') {
                    ++i;
                } else if (ch == '\"') {
                    inString = !inString;
                } else if (Character.isWhitespace(ch) && !inString) {
                    argList.add(rawArgList.substring(lastArgIndex, i));
                    break;
                }
                ++i;
            }
            if (i >= rawArgList.length()) {
                argList.add(rawArgList.substring(lastArgIndex));
            }
            ++i;
        }
        return argList;
    }

    protected IPath getExecDir(IContainer container) {
        int type = container.getType();
        IPath execDir = null;
        execDir = type == 1 ? container.getLocation().removeLastSegments(1) : container.getLocation();
        return execDir;
    }

    protected IPath getCWD(IContainer container) {
        int type = container.getType();
        IPath cwd = null;
        cwd = type == 1 ? container.getFullPath().removeLastSegments(1) : container.getFullPath();
        return cwd;
    }

    protected IContainer getSelectedContainer() {
        return this.fContainer;
    }

    public void setSelectedContainer(IContainer container) {
        this.fContainer = container;
    }
}

