/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public abstract class ASTAttribute
extends ASTNode
implements IASTAttribute {
    private final char[] name;
    private final IASTToken argumentClause;

    public ASTAttribute(char[] name, IASTToken arguments) {
        this.name = name;
        this.argumentClause = arguments;
    }

    @Override
    public char[] getName() {
        return this.name;
    }

    @Override
    public IASTToken getArgumentClause() {
        return this.argumentClause;
    }

    @Override
    public void setArgumentClause(IASTToken argumentClause) {
        this.assertNotFrozen();
        if (argumentClause != null) {
            argumentClause.setParent(this);
            argumentClause.setPropertyInParent(ARGUMENT_CLAUSE);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitAttributes) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.argumentClause != null && !this.argumentClause.accept(action)) {
            return false;
        }
        return !action.shouldVisitAttributes || action.leave(this) != 2;
    }
}

